/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.fluids;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;

public class PhosphophylliteFluidStack
extends FluidStack {
    private static final Field delegateField;
    Fluid fluid;
    IRegistryDelegate<Fluid> delegateWrapper = new IRegistryDelegate<Fluid>(){

        public Fluid get() {
            return PhosphophylliteFluidStack.this.fluid;
        }

        public ResourceLocation name() {
            return PhosphophylliteFluidStack.this.fluid.delegate.name();
        }

        public Class<Fluid> type() {
            return PhosphophylliteFluidStack.this.fluid.delegate.type();
        }
    };
    private long amount = 0L;
    private CompoundNBT tag;

    private void setDelegate(IRegistryDelegate<Fluid> delegate) {
        try {
            delegateField.set((Object)this, delegate);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public PhosphophylliteFluidStack() {
        super((Fluid)Fluids.field_204546_a, 0);
        this.setDelegate(this.delegateWrapper);
        this.setFluid(Fluids.field_204541_a);
    }

    public PhosphophylliteFluidStack(Fluid fluid, int amount) {
        super((Fluid)Fluids.field_204546_a, 0);
        this.setDelegate(this.delegateWrapper);
        this.setFluid(fluid);
        this.setAmount(amount);
    }

    public PhosphophylliteFluidStack(Fluid fluid, int amount, CompoundNBT nbt) {
        super((Fluid)Fluids.field_204546_a, 0, nbt);
        this.setDelegate(this.delegateWrapper);
        this.setFluid(fluid);
        this.setAmount(amount);
    }

    public PhosphophylliteFluidStack(Fluid fluid, long amount, CompoundNBT nbt) {
        super((Fluid)Fluids.field_204546_a, 0, nbt);
        this.setDelegate(this.delegateWrapper);
        this.setFluid(fluid);
        this.setAmount(amount);
    }

    public PhosphophylliteFluidStack(FluidStack stack, int amount) {
        this(stack, (long)amount);
    }

    public PhosphophylliteFluidStack(FluidStack stack, long amount) {
        super((Fluid)Fluids.field_204546_a, 0, stack.getTag());
        this.setDelegate(this.delegateWrapper);
        this.setFluid(stack.getRawFluid());
        this.setAmount(amount);
    }

    public PhosphophylliteFluidStack(PhosphophylliteFluidStack stack) {
        this((FluidStack)stack, stack.getLongAmount());
    }

    public PhosphophylliteFluidStack(FluidStack stack) {
        this(stack, stack instanceof PhosphophylliteFluidStack ? ((PhosphophylliteFluidStack)stack).getLongAmount() : (long)stack.getAmount());
    }

    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    public static FluidStack loadFromNBT(CompoundNBT nbt) {
        if (nbt == null) {
            return EMPTY;
        }
        if (!nbt.func_150297_b("FluidName", 8)) {
            return EMPTY;
        }
        ResourceLocation fluidName = new ResourceLocation(nbt.func_74779_i("FluidName"));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName);
        if (fluid == null) {
            return EMPTY;
        }
        PhosphophylliteFluidStack stack = new PhosphophylliteFluidStack(fluid, nbt.func_74762_e("Amount"));
        if (nbt.func_74764_b("LongAmount")) {
            stack.amount = nbt.func_74763_f("LongAmount");
        }
        if (nbt.func_150297_b("Tag", 10)) {
            stack.setTag(nbt.func_74775_l("Tag"));
        }
        return stack;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        nbt.func_74778_a("FluidName", this.getFluid().getRegistryName().toString());
        nbt.func_74768_a("Amount", (int)Math.min(this.amount, Integer.MAX_VALUE));
        nbt.func_74772_a("LongAmount", this.amount);
        if (this.getTag() != null) {
            nbt.func_218657_a("Tag", (INBT)this.getTag());
        }
        return nbt;
    }

    public void writeToPacket(PacketBuffer buf) {
        buf.writeRegistryId((IForgeRegistryEntry)this.getFluid());
        buf.func_150787_b(this.getAmount());
        buf.func_150786_a(this.getTag());
    }

    public void writeToLongPacket(PacketBuffer buf) {
        buf.writeRegistryId((IForgeRegistryEntry)this.getFluid());
        buf.func_179254_b((long)this.getAmount());
        buf.func_150786_a(this.getTag());
    }

    public static FluidStack readFromPacket(PacketBuffer buf) {
        Fluid fluid = (Fluid)buf.readRegistryId();
        long amount = buf.func_179260_f();
        CompoundNBT tag = buf.func_150793_b();
        if (fluid == Fluids.field_204541_a) {
            return EMPTY;
        }
        return new PhosphophylliteFluidStack(fluid, amount, tag);
    }

    public boolean isEmpty() {
        return this.amount == 0L;
    }

    public int getAmount() {
        return (int)Math.min(this.amount, Integer.MAX_VALUE);
    }

    public long getLongAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.setAmount((long)amount);
    }

    public void setAmount(long amount) {
        this.amount = amount;
        super.setAmount((int)amount);
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public CompoundNBT getTag() {
        return this.tag;
    }

    public void setTag(CompoundNBT tag) {
        this.tag = tag;
    }

    public CompoundNBT getOrCreateTag() {
        if (this.tag == null) {
            this.setTag(new CompoundNBT());
        }
        return this.tag;
    }

    public CompoundNBT getChildTag(String childName) {
        if (this.tag == null) {
            return null;
        }
        return this.tag.func_74775_l(childName);
    }

    public CompoundNBT getOrCreateChildTag(String childName) {
        this.getOrCreateTag();
        CompoundNBT child = this.tag.func_74775_l(childName);
        if (!this.tag.func_150297_b(childName, 10)) {
            this.tag.func_218657_a(childName, (INBT)child);
        }
        return child;
    }

    public void removeChildTag(String childName) {
        if (this.tag != null) {
            this.tag.func_82580_o(childName);
        }
    }

    public void grow(int amount) {
        this.setAmount(this.amount + (long)amount);
    }

    public void grow(long amount) {
        this.setAmount(this.amount + amount);
    }

    public void shrink(int amount) {
        this.setAmount(this.amount - (long)amount);
    }

    public void shrink(long amount) {
        this.setAmount(this.amount - amount);
    }

    public boolean isFluidStackIdentical(FluidStack other) {
        if (other instanceof PhosphophylliteFluidStack) {
            return this.isFluidEqual(other) && this.amount == ((PhosphophylliteFluidStack)other).getLongAmount();
        }
        return this.isFluidEqual(other) && this.amount == (long)other.getAmount();
    }

    public boolean containsFluid(@Nonnull FluidStack other) {
        if (other instanceof PhosphophylliteFluidStack) {
            return this.isFluidEqual(other) && this.amount >= ((PhosphophylliteFluidStack)other).getLongAmount();
        }
        return this.isFluidEqual(other) && this.amount >= (long)other.getAmount();
    }

    public FluidStack copy() {
        return new PhosphophylliteFluidStack(this);
    }

    static {
        try {
            delegateField = FluidStack.class.getDeclaredField("fluidDelegate");
            delegateField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }
}

