/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.config.ConfigManager;
import net.roguelogix.phosphophyllite.config.PhosphophylliteConfig;
import net.roguelogix.phosphophyllite.parsers.Element;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ConfigSpec {
    final SpecClazzNode masterNode;

    ConfigSpec(Class<?> clazz) {
        this.masterNode = ConfigSpec.buildNodeForClazz(clazz);
    }

    Element trimAndRegenerateTree(Element tree, boolean enableAdvanced) {
        return this.regenerateElementTree(this.trimElementTree(tree), enableAdvanced);
    }

    @Nullable
    Element trimElementTree(Element tree) {
        return this.trimElementForNode(tree, this.masterNode);
    }

    @Nullable
    private Element trimElementForNode(Element element, SpecNode node) {
        if (node instanceof SpecClazzNode) {
            if (element.type != Element.Type.Section) {
                return null;
            }
            SpecClazzNode clazzNode = (SpecClazzNode)node;
            ArrayList<Element> trimmedElements = new ArrayList<Element>();
            for (Element subElement : element.asArray()) {
                Element newElement;
                SpecNode subNode = clazzNode.fieldNodes.get(subElement.name);
                if (subNode == null) {
                    subNode = clazzNode.clazzNodes.get(subElement.name);
                }
                if (subNode == null || (newElement = this.trimElementForNode(subElement, subNode)) == null) continue;
                trimmedElements.add(newElement);
            }
            if (trimmedElements.size() == 0) {
                return null;
            }
            return new Element(Element.Type.Section, node.comment, element.name, trimmedElements.toArray());
        }
        if (node instanceof SpecObjectNode) {
            if (element.type != Element.Type.Section) {
                return null;
            }
            SpecObjectNode objectNode = (SpecObjectNode)node;
            ArrayList<Element> trimmedElements = new ArrayList<Element>();
            for (Element subElement : element.asArray()) {
                Element newElement;
                SpecNode subNode = objectNode.subNodes.get(subElement.name);
                if (subNode == null || (newElement = this.trimElementForNode(subElement, subNode)) == null) continue;
                trimmedElements.add(newElement);
            }
            return new Element(Element.Type.Section, node.comment, element.name, trimmedElements.toArray());
        }
        if (node instanceof SpecMapNode) {
            if (element.type != Element.Type.Section) {
                return null;
            }
            SpecFieldNode subNode = ((SpecMapNode)node).nodeType;
            ArrayList<Element> trimmedElements = new ArrayList<Element>();
            for (Element subElement : element.asArray()) {
                Element newElement = this.trimElementForNode(subElement, subNode);
                if (newElement == null) continue;
                trimmedElements.add(newElement);
            }
            return new Element(Element.Type.Section, node.comment, element.name, trimmedElements.toArray());
        }
        if (node instanceof SpecListNode) {
            if (element.type != Element.Type.Array) {
                return null;
            }
            SpecFieldNode subNode = ((SpecListNode)node).subNodeType;
            ArrayList<Element> trimmedElements = new ArrayList<Element>();
            for (Element subElement : element.asArray()) {
                Element newElement = this.trimElementForNode(subElement, subNode);
                if (newElement == null) continue;
                trimmedElements.add(newElement);
            }
            return new Element(Element.Type.Array, node.comment, element.name, trimmedElements.toArray());
        }
        if (node instanceof SpecStringNode) {
            if (element.type != Element.Type.String && element.type != Element.Type.Number && element.type != Element.Type.Boolean) {
                return null;
            }
            return element;
        }
        if (node instanceof SpecEnumNode) {
            if (element.type != Element.Type.String) {
                return null;
            }
            Enum[] enumVals = (Enum[])((SpecEnumNode)node).enumClass.getEnumConstants();
            String[] enumValStrings = new String[enumVals.length];
            for (int i = 0; i < enumVals.length; ++i) {
                enumValStrings[i] = enumVals[i].toString().toLowerCase(Locale.ENGLISH);
            }
            String nameGiven = element.asString().toLowerCase(Locale.ENGLISH);
            Enum givenVal = null;
            block5: for (int i = 0; i < enumValStrings.length; ++i) {
                if (!nameGiven.equals(enumValStrings[i])) continue;
                if (((SpecEnumNode)node).allowedValues.length == 0) {
                    givenVal = enumVals[i];
                    break;
                }
                for (String allowedValue : ((SpecEnumNode)node).allowedValues) {
                    if (!nameGiven.equals(allowedValue.toLowerCase(Locale.ENGLISH))) continue;
                    givenVal = enumVals[i];
                    break block5;
                }
                break;
            }
            if (givenVal == null) {
                return null;
            }
            return new Element(Element.Type.String, node.comment, element.name, givenVal.toString());
        }
        if (node instanceof SpecNumberNode) {
            if (element.type != Element.Type.Number) {
                return null;
            }
            double val = element.asDouble();
            if (ConfigSpec.isIntegral(((SpecNumberNode)node).field.getType())) {
                long realVal = Math.round(val);
                if ((double)realVal < ((SpecNumberNode)node).lowerBound || (double)realVal > ((SpecNumberNode)node).upperBound || (double)realVal <= ((SpecNumberNode)node).lowerBound && !((SpecNumberNode)node).lowerInclusive || (double)realVal >= ((SpecNumberNode)node).upperBound && !((SpecNumberNode)node).upperInclusive) {
                    if ((double)realVal <= ((SpecNumberNode)node).lowerBound) {
                        realVal = Math.round(((SpecNumberNode)node).lowerBound);
                        if (!((SpecNumberNode)node).lowerInclusive) {
                            ++realVal;
                        }
                    } else if ((double)realVal >= ((SpecNumberNode)node).upperBound) {
                        realVal = Math.round(((SpecNumberNode)node).upperBound);
                        if (!((SpecNumberNode)node).upperInclusive) {
                            --realVal;
                        }
                    }
                }
                val = realVal;
            } else if (val < ((SpecNumberNode)node).lowerBound || val > ((SpecNumberNode)node).upperBound || val <= ((SpecNumberNode)node).lowerBound && !((SpecNumberNode)node).lowerInclusive || val >= ((SpecNumberNode)node).upperBound && !((SpecNumberNode)node).upperInclusive) {
                if (val <= ((SpecNumberNode)node).lowerBound) {
                    val = ((SpecNumberNode)node).lowerBound;
                    if (!((SpecNumberNode)node).lowerInclusive) {
                        val = Math.nextAfter(val, Double.POSITIVE_INFINITY);
                    }
                } else if (val >= ((SpecNumberNode)node).upperBound) {
                    val = ((SpecNumberNode)node).upperBound;
                    if (!((SpecNumberNode)node).upperInclusive) {
                        val = Math.nextAfter(val, Double.NEGATIVE_INFINITY);
                    }
                }
            }
            return new Element(Element.Type.Number, node.comment, element.name, String.valueOf(val));
        }
        if (node instanceof SpecBooleanNode) {
            boolean newVal;
            if (element.type != Element.Type.String && element.type != Element.Type.Number && element.type != Element.Type.Boolean) {
                return null;
            }
            if (element.type == Element.Type.String || element.type == Element.Type.Boolean) {
                String str = element.asString();
                newVal = Boolean.parseBoolean(str);
            } else {
                newVal = element.asDouble() != 0.0;
            }
            return new Element(Element.Type.Boolean, node.comment, element.name, String.valueOf(newVal));
        }
        return null;
    }

    Element regenerateElementTree(@Nullable Element tree, boolean enableAdvanced) {
        try {
            return this.regenerateElementTreeForNode(tree, this.masterNode, null, null, enableAdvanced);
        }
        catch (IllegalAccessException e) {
            ConfigManager.LOGGER.error("Unexpected error caught regenerating config");
            ConfigManager.LOGGER.error(e.toString());
            throw new DefinitionError(e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private Element regenerateElementTreeForNode(@Nullable Element tree, SpecNode node, @Nullable Object object, @Nullable String name, boolean enableAdvanced) throws IllegalAccessException {
        if (tree == null) {
            return this.generateElementForNode(node, object, name, enableAdvanced);
        }
        if (node instanceof SpecClazzNode) {
            if (tree.type != Element.Type.Section) {
                return this.generateElementForNode(node, object, name, enableAdvanced);
            }
            ArrayList<Element> subElements = new ArrayList<Element>();
            Element[] elements = tree.asArray();
            block0: for (Map.Entry<String, SpecFieldNode> entry : ((SpecClazzNode)node).fieldNodes.entrySet()) {
                for (Element element : elements) {
                    if (!entry.getKey().equals(element.name)) continue;
                    subElements.add(this.regenerateElementTreeForNode(element, entry.getValue(), null, entry.getKey(), enableAdvanced));
                    continue block0;
                }
                if (!enableAdvanced && entry.getValue().advanced || entry.getValue().hidden) continue;
                subElements.add(this.regenerateElementTreeForNode(null, entry.getValue(), null, entry.getKey(), enableAdvanced));
            }
            block2: for (Map.Entry<String, SpecNode> entry : ((SpecClazzNode)node).clazzNodes.entrySet()) {
                Element subElement;
                for (Element element : elements) {
                    Element subElement2;
                    if (!entry.getKey().equals(element.name)) continue;
                    if (!enableAdvanced && ((SpecClazzNode)entry.getValue()).advanced || ((SpecClazzNode)entry.getValue()).hidden || (subElement2 = this.regenerateElementTreeForNode(element, entry.getValue(), null, entry.getKey(), enableAdvanced)).asArray().length == 0) continue block2;
                    subElements.add(subElement2);
                    continue block2;
                }
                if (!enableAdvanced && ((SpecClazzNode)entry.getValue()).advanced || ((SpecClazzNode)entry.getValue()).hidden || (subElement = this.regenerateElementTreeForNode(null, entry.getValue(), null, entry.getKey(), enableAdvanced)).asArray().length == 0) continue;
                subElements.add(subElement);
            }
            return new Element(Element.Type.Section, node.comment, name, subElements.toArray());
        }
        if (node instanceof SpecObjectNode) {
            if (tree.type != Element.Type.Section) {
                return this.generateElementForNode(node, object, name, enableAdvanced);
            }
            Object nodeObject = ((SpecObjectNode)node).field.get(object);
            if (nodeObject == null) {
                nodeObject = ConfigSpec.createClassInstance(((SpecObjectNode)node).clazz);
            }
            ArrayList<Element> subElements = new ArrayList<Element>();
            Element[] elements = tree.asArray();
            block4: for (Map.Entry<String, SpecFieldNode> entry : ((SpecObjectNode)node).subNodes.entrySet()) {
                for (Element element : elements) {
                    if (!entry.getKey().equals(element.name)) continue;
                    subElements.add(this.regenerateElementTreeForNode(element, entry.getValue(), nodeObject, entry.getKey(), enableAdvanced));
                    continue block4;
                }
                if (!enableAdvanced && entry.getValue().advanced || entry.getValue().hidden) continue;
                subElements.add(this.regenerateElementTreeForNode(null, entry.getValue(), nodeObject, entry.getKey(), enableAdvanced));
            }
            return new Element(Element.Type.Section, node.comment, name, subElements.toArray());
        }
        if (node instanceof SpecMapNode) {
            if (tree.type != Element.Type.Section) {
                return this.generateElementForNode(node, object, name, enableAdvanced);
            }
            ArrayList<Element> subElements = new ArrayList<Element>();
            Element[] elements = tree.asArray();
            Object defaultObject = ConfigSpec.createClassInstance(((SpecMapNode)node).elementClass);
            Object object2 = ((SpecFieldNode)node).field.get(object);
            Map map = (Map)object2;
            for (Element element : elements) {
                Object elementObject = map.get(element.name);
                if (elementObject == null) {
                    elementObject = defaultObject;
                }
                subElements.add(this.regenerateElementTreeForNode(element, ((SpecMapNode)node).nodeType, elementObject, element.name, enableAdvanced));
            }
            return new Element(Element.Type.Section, node.comment, name, subElements.toArray());
        }
        if (node instanceof SpecListNode) {
            if (tree.type != Element.Type.Array) {
                return this.generateElementForNode(node, object, name, enableAdvanced);
            }
            ArrayList<Element> subElements = new ArrayList<Element>();
            Element[] elements = tree.asArray();
            Object defaultObject = ConfigSpec.createClassInstance(((SpecListNode)node).elementClass);
            Object object3 = ((SpecFieldNode)node).field.get(object);
            List list = (List)object3;
            for (int i = 0; i < elements.length; ++i) {
                Object elementObject = defaultObject;
                if (i < list.size()) {
                    elementObject = list.get(i);
                }
                subElements.add(this.regenerateElementTreeForNode(elements[i], ((SpecListNode)node).subNodeType, elementObject, null, enableAdvanced));
            }
            return new Element(Element.Type.Array, node.comment, name, subElements.toArray());
        }
        if (node instanceof SpecEnumNode) {
            void var9_36;
            if (tree.type != Element.Type.String) {
                return this.generateElementForNode(node, object, name, enableAdvanced);
            }
            Enum[] enumVals = (Enum[])((SpecEnumNode)node).enumClass.getEnumConstants();
            String[] enumValStrings = new String[enumVals.length];
            for (int i = 0; i < enumVals.length; ++i) {
                enumValStrings[i] = enumVals[i].toString().toLowerCase(Locale.ENGLISH);
            }
            String nameGiven = tree.asString().toLowerCase(Locale.ENGLISH);
            Object var9_32 = null;
            block9: for (int i = 0; i < enumValStrings.length; ++i) {
                if (!nameGiven.equals(enumValStrings[i])) continue;
                if (((SpecEnumNode)node).allowedValues.length == 0) {
                    Enum enum_ = enumVals[i];
                    break;
                }
                for (String allowedValue : ((SpecEnumNode)node).allowedValues) {
                    if (!nameGiven.equals(allowedValue.toLowerCase(Locale.ENGLISH))) continue;
                    Enum enum_ = enumVals[i];
                    break block9;
                }
                break;
            }
            if (var9_36 == null) {
                return this.generateElementForNode(node, object, name, enableAdvanced);
            }
            return tree;
        }
        if (node instanceof SpecStringNode) {
            if (tree.type != Element.Type.String && tree.type != Element.Type.Number && tree.type != Element.Type.Boolean) {
                return this.generateElementForNode(node, object, name, enableAdvanced);
            }
            return tree;
        }
        if (node instanceof SpecNumberNode) {
            if (tree.type != Element.Type.Number) {
                return this.generateElementForNode(node, object, name, enableAdvanced);
            }
            double val = tree.asDouble();
            if (ConfigSpec.isIntegral(((SpecNumberNode)node).field.getType())) {
                long realVal = Math.round(val);
                if ((double)realVal < ((SpecNumberNode)node).lowerBound || (double)realVal > ((SpecNumberNode)node).upperBound || (double)realVal <= ((SpecNumberNode)node).lowerBound && !((SpecNumberNode)node).lowerInclusive || (double)realVal >= ((SpecNumberNode)node).upperBound && !((SpecNumberNode)node).upperInclusive) {
                    if ((double)realVal <= ((SpecNumberNode)node).lowerBound) {
                        realVal = Math.round(((SpecNumberNode)node).lowerBound);
                        if (!((SpecNumberNode)node).lowerInclusive) {
                            ++realVal;
                        }
                    } else if ((double)realVal >= ((SpecNumberNode)node).upperBound) {
                        realVal = Math.round(((SpecNumberNode)node).upperBound);
                        if (!((SpecNumberNode)node).upperInclusive) {
                            --realVal;
                        }
                    }
                }
                val = realVal;
            } else if (val < ((SpecNumberNode)node).lowerBound || val > ((SpecNumberNode)node).upperBound || val <= ((SpecNumberNode)node).lowerBound && !((SpecNumberNode)node).lowerInclusive || val >= ((SpecNumberNode)node).upperBound && !((SpecNumberNode)node).upperInclusive) {
                if (val <= ((SpecNumberNode)node).lowerBound) {
                    val = ((SpecNumberNode)node).lowerBound;
                    if (!((SpecNumberNode)node).lowerInclusive) {
                        val = Math.nextAfter(val, Double.POSITIVE_INFINITY);
                    }
                } else if (val >= ((SpecNumberNode)node).upperBound) {
                    val = ((SpecNumberNode)node).upperBound;
                    if (!((SpecNumberNode)node).upperInclusive) {
                        val = Math.nextAfter(val, Double.NEGATIVE_INFINITY);
                    }
                }
            }
            return new Element(Element.Type.Number, node.comment, tree.name, String.valueOf(val));
        }
        if (node instanceof SpecBooleanNode) {
            boolean newVal;
            if (tree.type != Element.Type.String && tree.type != Element.Type.Number && tree.type != Element.Type.Boolean) {
                return this.generateElementForNode(node, object, name, enableAdvanced);
            }
            if (tree.type == Element.Type.String || tree.type == Element.Type.Boolean) {
                String str = tree.asString();
                newVal = Boolean.parseBoolean(str);
            } else {
                newVal = tree.asDouble() != 0.0;
            }
            return new Element(Element.Type.Boolean, node.comment, tree.name, String.valueOf(newVal));
        }
        throw new DefinitionError("Attempting to regenerate element for unknown node type");
    }

    Element generateElementTree(boolean enableAdvanced) {
        try {
            return this.generateElementForNode(this.masterNode, null, null, enableAdvanced);
        }
        catch (IllegalAccessException e) {
            ConfigManager.LOGGER.error("Unexpected error caught reading from config");
            ConfigManager.LOGGER.error(e.toString());
            throw new DefinitionError(e.getMessage());
        }
    }

    private Element generateElementForNode(SpecNode node, @Nullable Object object, @Nullable String name, boolean enableAdvanced) throws IllegalAccessException {
        if (node instanceof SpecClazzNode) {
            ArrayList<Element> subElements = new ArrayList<Element>();
            for (Map.Entry<String, SpecFieldNode> entry : ((SpecClazzNode)node).fieldNodes.entrySet()) {
                if (!enableAdvanced && entry.getValue().advanced || entry.getValue().hidden) continue;
                subElements.add(this.generateElementForNode(entry.getValue(), null, entry.getKey(), enableAdvanced));
            }
            for (Map.Entry<String, SpecNode> entry : ((SpecClazzNode)node).clazzNodes.entrySet()) {
                if (!enableAdvanced && ((SpecClazzNode)entry.getValue()).advanced || ((SpecClazzNode)entry.getValue()).hidden) continue;
                subElements.add(this.generateElementForNode(entry.getValue(), null, entry.getKey(), enableAdvanced));
            }
            return new Element(Element.Type.Section, node.comment, name, subElements.toArray());
        }
        if (node instanceof SpecObjectNode) {
            Object nodeObject = ((SpecObjectNode)node).field.get(object);
            ArrayList<Element> subElements = new ArrayList<Element>();
            for (Map.Entry<String, SpecFieldNode> entry : ((SpecObjectNode)node).subNodes.entrySet()) {
                if (!enableAdvanced && entry.getValue().advanced || entry.getValue().hidden) continue;
                subElements.add(this.generateElementForNode(entry.getValue(), nodeObject, entry.getKey(), enableAdvanced));
            }
            return new Element(Element.Type.Section, node.comment, name, subElements.toArray());
        }
        if (node instanceof SpecMapNode) {
            Object nodeObject = ((SpecFieldNode)node).field.get(object);
            assert (nodeObject instanceof Map);
            Map map = (Map)nodeObject;
            ArrayList<Element> arrayList = new ArrayList<Element>();
            for (Map.Entry entry : map.entrySet()) {
                arrayList.add(this.generateElementForNode(((SpecMapNode)node).nodeType, entry.getValue(), (String)entry.getKey(), enableAdvanced));
            }
            return new Element(Element.Type.Section, node.comment, name, arrayList.toArray());
        }
        if (node instanceof SpecListNode) {
            Object nodeObject = ((SpecFieldNode)node).field.get(object);
            SpecFieldNode subNodeType = ((SpecListNode)node).subNodeType;
            ArrayList<Element> arrayList = new ArrayList<Element>();
            if (nodeObject instanceof List) {
                List list = (List)nodeObject;
                for (Object o : list) {
                    arrayList.add(this.generateElementForNode(subNodeType, o, null, enableAdvanced));
                }
            } else {
                assert (nodeObject.getClass().isArray());
                int length = Array.getLength(nodeObject);
                for (int i = 0; i < length; ++i) {
                    arrayList.add(this.generateElementForNode(subNodeType, Array.get(nodeObject, i), null, enableAdvanced));
                }
            }
            return new Element(Element.Type.Array, node.comment, name, arrayList.toArray());
        }
        if (node instanceof SpecStringNode) {
            String val = ((SpecStringNode)node).field.get(object).toString();
            return new Element(Element.Type.String, node.comment, name, val);
        }
        if (node instanceof SpecEnumNode) {
            String val = ((SpecEnumNode)node).field.get(object).toString();
            return new Element(Element.Type.String, node.comment, name, val);
        }
        if (node instanceof SpecNumberNode) {
            Number num = (Number)((SpecNumberNode)node).field.get(object);
            return new Element(Element.Type.Number, node.comment, name, String.valueOf(num.doubleValue()));
        }
        if (node instanceof SpecBooleanNode) {
            Boolean bool = (Boolean)((SpecBooleanNode)node).field.get(object);
            return new Element(Element.Type.Boolean, node.comment, name, bool.toString());
        }
        throw new DefinitionError("Attempting to generate element for unknown node type");
    }

    void writeElementTree(Element tree) {
        try {
            ConfigSpec.writeElementNode(tree, this.masterNode, null);
        }
        catch (IllegalAccessException e) {
            ConfigManager.LOGGER.error("Unexpected error caught reading from config");
            ConfigManager.LOGGER.error(e.toString());
            throw new DefinitionError(e.getMessage());
        }
    }

    private static void writeElementNode(Element element, SpecNode node, @Nullable Object object) throws IllegalAccessException {
        if (node instanceof SpecClazzNode) {
            Element[] subElements;
            if (element.type != Element.Type.Section) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + (Object)((Object)element.type) + " to a Class");
                return;
            }
            for (Element subElement : subElements = element.asArray()) {
                SpecClazzNode clazzNode = ((SpecClazzNode)node).clazzNodes.get(subElement.name);
                SpecFieldNode fieldNode = ((SpecClazzNode)node).fieldNodes.get(subElement.name);
                if (clazzNode != null) {
                    ConfigSpec.writeElementNode(subElement, clazzNode, null);
                    continue;
                }
                if (fieldNode != null) {
                    ConfigSpec.writeElementNode(subElement, fieldNode, null);
                    continue;
                }
                Phosphophyllite.LOGGER.info("Unknown config option given: " + subElement.name);
            }
            return;
        }
        if (node instanceof SpecObjectNode) {
            Element[] subElements;
            if (element.type != Element.Type.Section) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + (Object)((Object)element.type) + " to an Object");
                return;
            }
            Object nodeObject = ConfigSpec.createClassInstance(((SpecObjectNode)node).clazz);
            for (Element subElement : subElements = element.asArray()) {
                SpecFieldNode subNode = ((SpecObjectNode)node).subNodes.get(subElement.name);
                if (subNode != null) {
                    ConfigSpec.writeElementNode(subElement, subNode, nodeObject);
                    continue;
                }
                Phosphophyllite.LOGGER.info("Unknown config option given: " + element.name);
            }
            ((SpecObjectNode)node).field.set(object, nodeObject);
            return;
        }
        if (node instanceof SpecMapNode) {
            Element[] subElements;
            if (element.type != Element.Type.Section) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + (Object)((Object)element.type) + " to a Map");
                return;
            }
            Map map = (Map)ConfigSpec.createClassInstance(((SpecMapNode)node).field.getType());
            for (Element subElement : subElements = element.asArray()) {
                Object newElementObject = ConfigSpec.createClassInstance(((SpecMapNode)node).elementClass);
                map.put(subElement.name, newElementObject);
                ConfigSpec.writeElementNode(subElement, ((SpecMapNode)node).nodeType, newElementObject);
            }
            ((SpecMapNode)node).field.set(object, map);
            return;
        }
        if (node instanceof SpecListNode) {
            if (element.type != Element.Type.Array) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + (Object)((Object)element.type) + " to an Array");
                return;
            }
            Element[] subElements = element.asArray();
            if (((SpecListNode)node).field.getType().isArray()) {
                Object array = Array.newInstance(((SpecListNode)node).elementClass, subElements.length);
                for (int i = 0; i < subElements.length; ++i) {
                    Object newElementObject = ConfigSpec.createClassInstance(((SpecListNode)node).elementClass);
                    Element subElement = subElements[i];
                    Array.set(array, i, newElementObject);
                    ConfigSpec.writeElementNode(subElement, ((SpecListNode)node).subNodeType, newElementObject);
                }
                ((SpecListNode)node).field.set(object, array);
            } else {
                List list = (List)ConfigSpec.createClassInstance(((SpecListNode)node).field.getType());
                for (Element subElement : subElements) {
                    Object newElementObject = ConfigSpec.createClassInstance(((SpecListNode)node).elementClass);
                    ConfigSpec.writeElementNode(subElement, ((SpecListNode)node).subNodeType, newElementObject);
                    list.add(newElementObject);
                }
                ((SpecListNode)node).field.set(object, list);
            }
            return;
        }
        if (node instanceof SpecStringNode) {
            if (element.type != Element.Type.String && element.type != Element.Type.Number && element.type != Element.Type.Boolean) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + (Object)((Object)element.type) + " to a String");
                return;
            }
            ((SpecStringNode)node).field.set(object, element.asString());
            return;
        }
        if (node instanceof SpecEnumNode) {
            if (element.type != Element.Type.String) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + (Object)((Object)element.type) + " to a Enum");
                return;
            }
            Enum[] enumVals = (Enum[])((SpecEnumNode)node).enumClass.getEnumConstants();
            String[] enumValStrings = new String[enumVals.length];
            for (int i = 0; i < enumVals.length; ++i) {
                enumValStrings[i] = enumVals[i].toString().toLowerCase(Locale.ENGLISH);
            }
            String nameGiven = element.asString().toLowerCase(Locale.ENGLISH);
            Enum givenVal = null;
            block6: for (int i = 0; i < enumValStrings.length; ++i) {
                if (!nameGiven.equals(enumValStrings[i])) continue;
                if (((SpecEnumNode)node).allowedValues.length == 0) {
                    givenVal = enumVals[i];
                    break;
                }
                for (String allowedValue : ((SpecEnumNode)node).allowedValues) {
                    if (!nameGiven.equals(allowedValue.toLowerCase(Locale.ENGLISH))) continue;
                    givenVal = enumVals[i];
                    break block6;
                }
                break;
            }
            if (givenVal != null) {
                ((SpecEnumNode)node).field.set(object, givenVal);
            }
            return;
        }
        if (node instanceof SpecNumberNode) {
            if (element.type != Element.Type.Number) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + (Object)((Object)element.type) + " to a Number");
                return;
            }
            double val = element.asDouble();
            if (ConfigSpec.isIntegral(((SpecNumberNode)node).field.getType())) {
                long realVal = Math.round(val);
                if ((double)realVal < ((SpecNumberNode)node).lowerBound || (double)realVal > ((SpecNumberNode)node).upperBound || (double)realVal <= ((SpecNumberNode)node).lowerBound && !((SpecNumberNode)node).lowerInclusive || (double)realVal >= ((SpecNumberNode)node).upperBound && !((SpecNumberNode)node).upperInclusive) {
                    ConfigManager.LOGGER.warn("Number value " + element.name + " given out of range value " + realVal + ". Valid range is " + (((SpecNumberNode)node).lowerInclusive ? "[" : "(" + (((SpecNumberNode)node).lowerBound == Double.MIN_VALUE ? "" : Double.valueOf(((SpecNumberNode)node).lowerBound))) + "," + (((SpecNumberNode)node).upperBound == Double.MAX_VALUE ? "" : Double.valueOf(((SpecNumberNode)node).upperBound)) + (((SpecNumberNode)node).upperInclusive ? "]" : ")") + ". Clamping to range");
                    if ((double)realVal <= ((SpecNumberNode)node).lowerBound) {
                        realVal = Math.round(((SpecNumberNode)node).lowerBound);
                        if (!((SpecNumberNode)node).lowerInclusive) {
                            ++realVal;
                        }
                    } else if ((double)realVal >= ((SpecNumberNode)node).upperBound) {
                        realVal = Math.round(((SpecNumberNode)node).upperBound);
                        if (!((SpecNumberNode)node).upperInclusive) {
                            --realVal;
                        }
                    }
                }
                val = realVal;
            } else if (val < ((SpecNumberNode)node).lowerBound || val > ((SpecNumberNode)node).upperBound || val <= ((SpecNumberNode)node).lowerBound && !((SpecNumberNode)node).lowerInclusive || val >= ((SpecNumberNode)node).upperBound && !((SpecNumberNode)node).upperInclusive) {
                ConfigManager.LOGGER.warn("Number value " + element.name + " given out of range value " + val + ". Valid range is " + (((SpecNumberNode)node).lowerInclusive ? "[" : "(" + (((SpecNumberNode)node).lowerBound == Double.MIN_VALUE ? "" : Double.valueOf(((SpecNumberNode)node).lowerBound))) + "," + (((SpecNumberNode)node).upperBound == Double.MAX_VALUE ? "" : Double.valueOf(((SpecNumberNode)node).upperBound)) + (((SpecNumberNode)node).upperInclusive ? "]" : ")") + ". Clamping to range");
                if (val <= ((SpecNumberNode)node).lowerBound) {
                    val = ((SpecNumberNode)node).lowerBound;
                    if (!((SpecNumberNode)node).lowerInclusive) {
                        val = Math.nextAfter(val, Double.POSITIVE_INFINITY);
                    }
                } else if (val >= ((SpecNumberNode)node).upperBound) {
                    val = ((SpecNumberNode)node).upperBound;
                    if (!((SpecNumberNode)node).upperInclusive) {
                        val = Math.nextAfter(val, Double.NEGATIVE_INFINITY);
                    }
                }
            }
            ConfigSpec.setNumberField(((SpecNumberNode)node).field, object, val);
            return;
        }
        if (node instanceof SpecBooleanNode) {
            boolean newVal;
            if (element.type != Element.Type.String && element.type != Element.Type.Number && element.type != Element.Type.Boolean) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + (Object)((Object)element.type) + " to a Boolean");
                return;
            }
            if (element.type == Element.Type.String || element.type == Element.Type.Boolean) {
                String str = element.asString();
                newVal = Boolean.parseBoolean(str);
            } else {
                newVal = element.asDouble() != 0.0;
            }
            ((SpecBooleanNode)node).field.setBoolean(object, newVal);
            return;
        }
        ConfigManager.LOGGER.warn("Invalid config structure given");
        ConfigManager.LOGGER.warn("Attempting to write " + (Object)((Object)element.type) + " to an unknown node type");
    }

    void writeDefaults() {
        try {
            ConfigSpec.defaultNode(this.masterNode, null);
        }
        catch (IllegalAccessException e) {
            Phosphophyllite.LOGGER.error("Error caught writing defaults to config");
            Phosphophyllite.LOGGER.error(e.toString());
        }
    }

    private static void defaultNode(SpecNode node, @Nullable Object object) throws IllegalAccessException {
        if (node instanceof SpecClazzNode) {
            for (Map.Entry<String, SpecClazzNode> entry : ((SpecClazzNode)node).clazzNodes.entrySet()) {
                ConfigSpec.defaultNode(entry.getValue(), null);
            }
            for (Map.Entry<String, SpecNode> entry : ((SpecClazzNode)node).fieldNodes.entrySet()) {
                ConfigSpec.defaultNode(entry.getValue(), null);
            }
        } else if (node instanceof SpecObjectNode) {
            if (object == null) {
                Phosphophyllite.LOGGER.error("Error cannot write to null object");
                return;
            }
            Object newObject = ConfigSpec.createClassInstance(((SpecObjectNode)node).clazz);
            for (Map.Entry<String, SpecFieldNode> entry : ((SpecObjectNode)node).subNodes.entrySet()) {
                ConfigSpec.defaultNode(entry.getValue(), newObject);
            }
            ((SpecObjectNode)node).field.set(object, newObject);
        } else if (node instanceof SpecMapNode) {
            SpecMapNode mapNode = (SpecMapNode)node;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Map.Entry<String, SpecFieldNode> entry : mapNode.defaultSubNodes.entrySet()) {
                Object obj = ConfigSpec.createClassInstance(mapNode.elementClass);
                ConfigSpec.defaultNode(entry.getValue(), obj);
                hashMap.put(entry.getKey(), obj);
            }
            mapNode.field.set(object, hashMap);
        } else if (node instanceof SpecListNode) {
            SpecListNode listNode = (SpecListNode)node;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (SpecFieldNode defaultSubNode : listNode.defaultSubNodes) {
                Object obj = ConfigSpec.createClassInstance(listNode.elementClass);
                ConfigSpec.defaultNode(defaultSubNode, obj);
                arrayList.add(obj);
            }
            listNode.field.set(object, arrayList);
        } else if (node instanceof SpecStringNode) {
            ((SpecStringNode)node).field.set(object, ((SpecStringNode)node).defaultString);
        } else if (node instanceof SpecEnumNode) {
            Object enumVal = Enum.valueOf(((SpecEnumNode)node).enumClass, ((SpecEnumNode)node).defaultValue);
            ((SpecEnumNode)node).field.set(object, enumVal);
        } else if (node instanceof SpecNumberNode) {
            ConfigSpec.setNumberField(((SpecNumberNode)node).field, object, ((SpecNumberNode)node).defaultValue);
        } else if (node instanceof SpecBooleanNode) {
            ((SpecBooleanNode)node).field.setBoolean(object, ((SpecBooleanNode)node).defaultValue);
        }
    }

    private static boolean isIntegral(Class<?> numberType) {
        return numberType == Byte.class || numberType == Byte.TYPE || numberType == Short.class || numberType == Short.TYPE || numberType == Integer.class || numberType == Integer.TYPE || numberType == Long.class || numberType == Long.TYPE;
    }

    private static void setNumberField(Field field, @Nullable Object object, double value) throws IllegalAccessException {
        Number newVal = null;
        Class<?> numberType = field.getType();
        if (numberType == Byte.TYPE || numberType == Byte.TYPE) {
            newVal = (byte)value;
        } else if (numberType == Short.TYPE || numberType == Short.TYPE) {
            newVal = (short)value;
        } else if (numberType == Integer.TYPE || numberType == Integer.TYPE) {
            newVal = (int)value;
        } else if (numberType == Long.TYPE || numberType == Long.TYPE) {
            newVal = (long)value;
        } else if (numberType == Float.TYPE || numberType == Float.TYPE) {
            newVal = Float.valueOf((float)value);
        } else if (numberType == Double.TYPE || numberType == Double.TYPE) {
            newVal = value;
        }
        field.set(object, newVal);
    }

    @Nullable
    private static SpecClazzNode buildNodeForClazz(Class<?> clazz) {
        String name;
        if (!clazz.isAnnotationPresent(PhosphophylliteConfig.class)) {
            return null;
        }
        SpecClazzNode node = new SpecClazzNode();
        node.clazz = clazz;
        node.clazzNodes = new HashMap<String, SpecClazzNode>();
        node.fieldNodes = new HashMap<String, SpecFieldNode>();
        for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
            SpecClazzNode subNode = ConfigSpec.buildNodeForClazz(clazz2);
            if (subNode == null) continue;
            name = clazz2.getSimpleName();
            if (node.clazzNodes.containsKey(name)) {
                throw new DefinitionError("Duplicate config name: " + name);
            }
            node.clazzNodes.put(name, subNode);
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
            SpecFieldNode fieldNode;
            if (!Modifier.isStatic(((Field)annotatedElement).getModifiers()) || (fieldNode = ConfigSpec.buildNodeForField((Field)annotatedElement, null)) == null) continue;
            name = ((Field)annotatedElement).getName();
            if (node.clazzNodes.containsKey(name)) {
                throw new DefinitionError("Duplicate config name: " + name);
            }
            if (node.fieldNodes.containsKey(name)) {
                throw new DefinitionError("Duplicate config name: " + name);
            }
            node.fieldNodes.put(name, fieldNode);
        }
        return node;
    }

    private static SpecObjectNode buildNodeForObject(Class<?> clazz, Object object) {
        if (!clazz.isAnnotationPresent(PhosphophylliteConfig.class)) {
            throw new DefinitionError("Attempt to build node for invalid object class");
        }
        SpecObjectNode node = new SpecObjectNode();
        node.clazz = clazz;
        node.subNodes = new HashMap<String, SpecFieldNode>();
        for (Field field : clazz.getDeclaredFields()) {
            SpecFieldNode fieldNode;
            if (Modifier.isStatic(field.getModifiers()) || (fieldNode = ConfigSpec.buildNodeForField(field, object)) == null) continue;
            String name = field.getName();
            if (node.subNodes.containsKey(name)) {
                throw new DefinitionError("Duplicate config name: " + name);
            }
            node.subNodes.put(name, fieldNode);
        }
        return node;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static SpecFieldNode buildNodeForField(Field field, @Nullable Object object) {
        void var6_19;
        Class valueClass;
        int i;
        if (!field.isAnnotationPresent(PhosphophylliteConfig.Value.class)) {
            return null;
        }
        field.setAccessible(true);
        Object fieldObject = null;
        if (Modifier.isStatic(field.getModifiers()) == (object == null)) {
            try {
                fieldObject = field.get(object);
            }
            catch (IllegalAccessException e) {
                Phosphophyllite.LOGGER.warn("Illegal Access attempting to get field");
                Phosphophyllite.LOGGER.warn(e.getMessage());
                return null;
            }
        }
        Class<?> fieldClass = field.getType();
        if (fieldObject == null) {
            try {
                Constructor<?> constructor = fieldClass.getConstructor(new Class[0]);
                constructor.setAccessible(true);
                fieldObject = constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Phosphophyllite.LOGGER.warn(e.getMessage());
                throw new DefinitionError("Unable to create default instance of field object");
            }
        }
        PhosphophylliteConfig.Value fieldAnnotation = field.getAnnotation(PhosphophylliteConfig.Value.class);
        StringBuilder comment = new StringBuilder(fieldAnnotation.comment());
        if (!fieldAnnotation.range().equals("(,)")) {
            if (comment.length() != 0) {
                comment.append('\n');
            }
            comment.append("Valid range: ").append(fieldAnnotation.range());
        }
        if (fieldAnnotation.commentDefaultValue() && !fieldClass.isArray() && !fieldClass.isAnnotationPresent(PhosphophylliteConfig.class)) {
            if (comment.length() != 0) {
                comment.append('\n');
            }
            comment.append("Default: ");
            comment.append(fieldObject.toString());
        }
        if (fieldClass.isEnum()) {
            void var6_10;
            Field[] enumFields;
            String[] stringArray = fieldAnnotation.allowedValues();
            if (stringArray.length == 0) {
                enumFields = fieldClass.getFields();
                String[] stringArray2 = new String[enumFields.length];
                for (i = 0; i < enumFields.length; ++i) {
                    stringArray2[i] = enumFields[i].getName();
                }
            }
            if (comment.length() != 0) {
                comment.append('\n');
            }
            comment.append("Allowed Values: ");
            enumFields = var6_10;
            i = enumFields.length;
            for (int j = 0; j < i; ++j) {
                Field allowedValue = enumFields[j];
                comment.append((String)((Object)allowedValue));
                comment.append(", ");
            }
        }
        Object var6_11 = null;
        if (fieldClass.isArray() || List.class == fieldClass || ArrayList.class == fieldClass) {
            SpecListNode listNode = new SpecListNode();
            listNode.defaultSubNodes = new ArrayList<SpecFieldNode>();
            if (fieldClass.isArray()) {
                listNode.elementClass = fieldClass.getComponentType();
                for (i = 0; i < Array.getLength(fieldObject); ++i) {
                    Object element2 = Array.get(fieldObject, 0);
                    if (element2 == null) continue;
                    listNode.defaultSubNodes.add(ConfigSpec.buildNodeForObject(listNode.elementClass, element2));
                }
            } else {
                ParameterizedType type = (ParameterizedType)field.getGenericType();
                Type[] generics = type.getActualTypeArguments();
                listNode.elementClass = valueClass = (Class)generics[0];
                if (!valueClass.isAnnotationPresent(PhosphophylliteConfig.class)) {
                    throw new RuntimeException("list values must be config objects");
                }
                List list = (List)fieldObject;
                list.forEach(element -> listNode.defaultSubNodes.add(ConfigSpec.buildNodeForObject(listNode.elementClass, element)));
            }
            Object defaultObject = ConfigSpec.createClassInstance(listNode.elementClass);
            listNode.subNodeType = ConfigSpec.buildNodeForObject(listNode.elementClass, defaultObject);
            SpecListNode specListNode = listNode;
        } else if (Map.class == fieldClass || HashMap.class == fieldClass) {
            SpecMapNode mapNode = new SpecMapNode();
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            Type[] generics = type.getActualTypeArguments();
            if (generics[0] != String.class) {
                throw new RuntimeException("map keys must be strings");
            }
            valueClass = (Class)generics[1];
            if (!valueClass.isAnnotationPresent(PhosphophylliteConfig.class)) {
                throw new RuntimeException("map values must be config objects");
            }
            mapNode.elementClass = valueClass;
            mapNode.defaultSubNodes = new HashMap<String, SpecFieldNode>();
            Object defaultObject = ConfigSpec.createClassInstance(mapNode.elementClass);
            mapNode.nodeType = ConfigSpec.buildNodeForObject(mapNode.elementClass, defaultObject);
            Map map = (Map)fieldObject;
            map.forEach((string, element) -> mapNode.defaultSubNodes.put((String)string, ConfigSpec.buildNodeForObject(mapNode.elementClass, element)));
            SpecMapNode specMapNode = mapNode;
        } else if (String.class == fieldClass) {
            SpecStringNode stringNode = new SpecStringNode();
            stringNode.defaultString = (String)fieldObject;
            SpecStringNode specStringNode = stringNode;
        } else if (fieldClass.isEnum()) {
            SpecEnumNode enumNode = new SpecEnumNode();
            enumNode.enumClass = fieldClass;
            enumNode.allowedValues = fieldAnnotation.allowedValues();
            enumNode.defaultValue = null;
            enumNode.defaultValue = fieldObject.toString();
            SpecEnumNode specEnumNode = enumNode;
        } else if (fieldClass.isPrimitive() || Number.class.isAssignableFrom(fieldClass) || Boolean.class == fieldClass) {
            if (fieldClass == Boolean.TYPE || fieldClass == Boolean.class) {
                SpecBooleanNode booleanNode = new SpecBooleanNode();
                booleanNode.defaultValue = false;
                booleanNode.defaultValue = (Boolean)fieldObject;
                SpecBooleanNode specBooleanNode = booleanNode;
            } else {
                boolean higherInclusive;
                boolean lowerInclusive;
                SpecNumberNode numberNode = new SpecNumberNode();
                String range = fieldAnnotation.range();
                if ((range = range.trim()).length() < 3) {
                    throw new DefinitionError("Incomplete range given");
                }
                char lowerInclusiveChar = range.charAt(0);
                char higherInclusiveChar = range.charAt(range.length() - 1);
                switch (lowerInclusiveChar) {
                    case '(': {
                        lowerInclusive = false;
                        break;
                    }
                    case '[': {
                        lowerInclusive = true;
                        break;
                    }
                    default: {
                        throw new DefinitionError("Unknown lower bound inclusivity");
                    }
                }
                switch (higherInclusiveChar) {
                    case ')': {
                        higherInclusive = false;
                        break;
                    }
                    case ']': {
                        higherInclusive = true;
                        break;
                    }
                    default: {
                        throw new DefinitionError("Unknown higher bound inclusivity");
                    }
                }
                range = range.substring(1, range.length() - 1).trim();
                String[] bounds = range.split(",");
                if (bounds.length > 2) {
                    throw new DefinitionError("Range cannot have more than two bounds");
                }
                String lowerBoundStr = "";
                String higherBoundStr = "";
                if (bounds.length == 2) {
                    lowerBoundStr = bounds[0].trim();
                    higherBoundStr = bounds[1].trim();
                } else {
                    if (range.length() == 0) {
                        throw new DefinitionError("Incomplete range given");
                    }
                    if (range.length() != 1) {
                        if (bounds.length != 1) {
                            throw new DefinitionError("Incomplete range given");
                        }
                        if (range.charAt(0) == ',') {
                            higherBoundStr = bounds[0];
                        } else {
                            if (range.charAt(range.length() - 1) != ',') throw new DefinitionError("Incomplete range given");
                            lowerBoundStr = bounds[0];
                        }
                    } else if (range.charAt(0) != ',') {
                        throw new DefinitionError("Incomplete range given");
                    }
                }
                double lowerBound = Double.MIN_VALUE;
                if (lowerBoundStr.length() != 0) {
                    lowerBound = Double.parseDouble(lowerBoundStr);
                }
                double higherBound = Double.MAX_VALUE;
                if (higherBoundStr.length() != 0) {
                    higherBound = Double.parseDouble(higherBoundStr);
                }
                if (lowerBound > higherBound) {
                    throw new DefinitionError("Higher bound must be greater or equal to lower bound");
                }
                numberNode.lowerInclusive = lowerInclusive;
                numberNode.upperInclusive = higherInclusive;
                numberNode.lowerBound = lowerBound;
                numberNode.upperBound = higherBound;
                Number fieldNum = (Number)fieldObject;
                numberNode.defaultValue = 0.0;
                numberNode.defaultValue = fieldNum.doubleValue();
                SpecNumberNode specNumberNode = numberNode;
            }
        } else if (fieldClass.isAnnotationPresent(PhosphophylliteConfig.class)) {
            SpecObjectNode specObjectNode = ConfigSpec.buildNodeForObject(fieldClass, fieldObject);
        }
        if (var6_19 == null) {
            throw new DefinitionError("Cannot build config spec for invalid class");
        }
        var6_19.field = field;
        var6_19.comment = comment.length() == 0 ? null : comment.toString();
        var6_19.advanced = fieldAnnotation.advanced();
        var6_19.hidden = fieldAnnotation.hidden();
        return var6_19;
    }

    private static Object createClassInstance(Class<?> elementClass) {
        try {
            Constructor<?> constructor = elementClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Phosphophyllite.LOGGER.warn(e.getMessage());
            throw new DefinitionError("Unable to create default instance of object");
        }
    }

    private static class SpecBooleanNode
    extends SpecFieldNode {
        boolean defaultValue;

        private SpecBooleanNode() {
        }
    }

    private static class SpecNumberNode
    extends SpecFieldNode {
        boolean integral;
        boolean lowerInclusive;
        double lowerBound;
        boolean upperInclusive;
        double upperBound;
        double defaultValue;

        private SpecNumberNode() {
        }
    }

    private static class SpecEnumNode
    extends SpecFieldNode {
        Class<?> enumClass;
        String defaultValue;
        String[] allowedValues;

        private SpecEnumNode() {
        }
    }

    private static class SpecStringNode
    extends SpecFieldNode {
        String defaultString;

        private SpecStringNode() {
        }
    }

    private static class SpecListNode
    extends SpecFieldNode {
        Class<?> elementClass;
        SpecFieldNode subNodeType;
        List<SpecFieldNode> defaultSubNodes;

        private SpecListNode() {
        }
    }

    private static class SpecMapNode
    extends SpecFieldNode {
        Class<?> elementClass;
        SpecFieldNode nodeType;
        Map<String, SpecFieldNode> defaultSubNodes;

        private SpecMapNode() {
        }
    }

    private static class SpecObjectNode
    extends SpecFieldNode {
        Class<?> clazz;
        Map<String, SpecFieldNode> subNodes;

        private SpecObjectNode() {
        }
    }

    private static class SpecFieldNode
    extends SpecNode {
        Field field;

        private SpecFieldNode() {
        }
    }

    private static class SpecClazzNode
    extends SpecNode {
        Class<?> clazz;
        Map<String, SpecClazzNode> clazzNodes;
        Map<String, SpecFieldNode> fieldNodes;

        private SpecClazzNode() {
        }
    }

    private static abstract class SpecNode {
        String comment;
        boolean advanced = false;
        boolean hidden = false;

        private SpecNode() {
        }
    }

    public static class DefinitionError
    extends RuntimeException {
        public DefinitionError(String message) {
            super(message);
        }
    }
}

