/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashSet;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.roguelogix.phosphophyllite.config.ConfigFormat;
import net.roguelogix.phosphophyllite.config.ConfigSpec;
import net.roguelogix.phosphophyllite.config.PhosphophylliteConfig;
import net.roguelogix.phosphophyllite.parsers.Element;
import net.roguelogix.phosphophyllite.parsers.JSON5;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ConfigManager {
    static final Logger LOGGER = LogManager.getLogger((String)"Phosphophyllite/Config");
    private static final HashSet<ModConfig> modConfigs = new HashSet();

    public static void registerConfig(Class<?> clazz, String modName) {
        PhosphophylliteConfig annotation;
        if (clazz.isAnnotationPresent(PhosphophylliteConfig.class) && !(annotation = clazz.getAnnotation(PhosphophylliteConfig.class)).name().equals("")) {
            modName = annotation.name();
        }
        ModConfig config = new ModConfig(clazz, modName);
        modConfigs.add(config);
        config.load();
    }

    private static class ModConfig {
        private final Class<?> configClazz;
        final PhosphophylliteConfig annotation;
        private final String modName;
        File baseFile;
        File actualFile = null;
        ConfigFormat actualFormat;
        private final ConfigSpec spec;
        private Field enableAdvanced;
        private final HashSet<Method> preLoads = new HashSet();
        private final HashSet<Method> loads = new HashSet();
        private final HashSet<Method> postLoads = new HashSet();

        ModConfig(Class<?> clazz, String name) {
            this.configClazz = clazz;
            this.modName = name;
            this.spec = new ConfigSpec(clazz);
            this.loadReflections();
            this.annotation = clazz.getAnnotation(PhosphophylliteConfig.class);
            this.baseFile = new File("config/" + this.annotation.folder() + "/" + name + "-" + this.annotation.type().toString().toLowerCase());
        }

        boolean enableAdvanced() {
            if (this.enableAdvanced == null) {
                return false;
            }
            try {
                return this.enableAdvanced.getBoolean(null);
            }
            catch (IllegalAccessException ignored) {
                return false;
            }
        }

        void loadReflections() {
            for (Field field : this.configClazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(PhosphophylliteConfig.EnableAdvanced.class)) continue;
                this.enableAdvanced = field;
                this.enableAdvanced.setAccessible(true);
                Class<?> EAClass = this.enableAdvanced.getType();
                if (EAClass != Boolean.TYPE && EAClass != Boolean.class) {
                    throw new ConfigSpec.DefinitionError("Advanced enable flag must be a boolean");
                }
                if (Modifier.isStatic(field.getModifiers())) break;
                throw new ConfigSpec.DefinitionError("Advanced enable flag must be static");
            }
            for (AccessibleObject accessibleObject : this.configClazz.getDeclaredMethods()) {
                if (((Method)accessibleObject).getReturnType() != Void.TYPE || ((Method)accessibleObject).getParameterCount() != 0 || !Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
                if (accessibleObject.isAnnotationPresent(PhosphophylliteConfig.PreLoad.class)) {
                    ((Method)accessibleObject).setAccessible(true);
                    this.preLoads.add((Method)accessibleObject);
                }
                if (accessibleObject.isAnnotationPresent(PhosphophylliteConfig.Load.class)) {
                    ((Method)accessibleObject).setAccessible(true);
                    this.loads.add((Method)accessibleObject);
                }
                if (!accessibleObject.isAnnotationPresent(PhosphophylliteConfig.PostLoad.class)) continue;
                ((Method)accessibleObject).setAccessible(true);
                this.postLoads.add((Method)accessibleObject);
            }
        }

        void runPreLoads() {
            for (Method preLoad : this.preLoads) {
                try {
                    preLoad.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        void runLoads() {
            for (Method load : this.loads) {
                try {
                    load.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        void runPostLoads() {
            for (Method postLoad : this.postLoads) {
                try {
                    postLoad.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        void load() {
            if (this.actualFile == null) {
                this.findFile();
            }
            if (!this.actualFile.exists()) {
                this.generateFile();
                return;
            }
            Element tree = this.readFile();
            this.spec.writeElementTree(tree);
            tree = this.spec.trimAndRegenerateTree(tree, this.enableAdvanced());
            this.writeFile(tree);
        }

        void findFile() {
            File file = null;
            ConfigFormat format = null;
            for (ConfigFormat value : ConfigFormat.values()) {
                File fullFile = new File(this.baseFile + "." + value.toString().toLowerCase());
                if (!fullFile.exists()) continue;
                if (file != null) {
                    if (this.annotation.format() != value) continue;
                    file = fullFile;
                    format = value;
                    continue;
                }
                format = value;
                file = fullFile;
            }
            if (file == null) {
                file = new File(this.baseFile + "." + this.annotation.format().toString().toLowerCase());
                format = this.annotation.format();
            }
            this.actualFile = file;
            this.actualFormat = format;
        }

        void generateFile() {
            this.spec.writeDefaults();
            this.writeFile(this.spec.generateElementTree(false));
        }

        void writeFile(Element tree) {
            String str = null;
            switch (this.annotation.format()) {
                case JSON5: {
                    str = JSON5.parseElement(tree);
                    break;
                }
                case TOML: {
                    throw new RuntimeException("TOML not supported");
                }
            }
            try {
                this.actualFile.getParentFile().mkdirs();
                Files.write(Paths.get(String.valueOf(this.actualFile), new String[0]), str.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        Element readFile() {
            String str;
            try {
                str = new String(Files.readAllBytes(Paths.get(String.valueOf(this.actualFile), new String[0])));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to read config file");
            }
            Element elementTree = null;
            switch (this.actualFormat) {
                case JSON5: {
                    elementTree = JSON5.parseString(str);
                    break;
                }
                case TOML: {
                    throw new RuntimeException("TOML not supported");
                }
            }
            return elementTree;
        }
    }
}

