/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.blocks.whiteholes;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.registry.TileSupplier;

@RegisterTileEntity(name="item_white_hole")
public class ItemWhiteHoleTile
extends TileEntity
implements IItemHandler,
ITickableTileEntity {
    @RegisterTileEntity.Type
    public static TileEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final TileSupplier SUPPLIER;
    Item item = null;

    public ItemWhiteHoleTile() {
        super(TYPE);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public void func_230337_a_(@Nonnull BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b("item")) {
            this.item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.func_74779_i("item")));
        }
        super.func_230337_a_(state, compound);
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        if (this.item != null) {
            compound.func_74778_a("item", Objects.requireNonNull(this.item.getRegistryName()).toString());
        }
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (this.item != null) {
            assert (this.field_145850_b != null);
            for (Direction direction : Direction.values()) {
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
                if (te == null) continue;
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).ifPresent(c -> {
                    for (int i = 0; i < c.getSlots(); ++i) {
                        c.insertItem(i, new ItemStack((IItemProvider)this.item, this.item.func_77639_j()), false);
                    }
                });
            }
        }
    }

    public int getSlots() {
        return 128;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return new ItemStack((IItemProvider)this.item, this.item.func_77639_j());
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return new ItemStack((IItemProvider)this.item, amount);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    static {
        SUPPLIER = ItemWhiteHoleTile::new;
    }
}

