/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.entity.custom.ISpringableEntity;
import dev.murad.shipping.entity.custom.barge.AbstractBargeEntity;
import dev.murad.shipping.entity.custom.tug.AbstractTugEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Train {
    private final Optional<AbstractTugEntity> tug;
    private ISpringableEntity tail;
    private ISpringableEntity head;

    public Train(ISpringableEntity entity) {
        this.head = entity;
        this.tail = entity;
        this.tug = entity instanceof AbstractTugEntity ? Optional.of((AbstractTugEntity)entity) : Optional.empty();
    }

    public Optional<AbstractTugEntity> getTug() {
        return this.tug;
    }

    public ISpringableEntity getTail() {
        return this.tail;
    }

    public void setTail(ISpringableEntity tail) {
        this.tail = tail;
    }

    public ISpringableEntity getHead() {
        return this.head;
    }

    public List<AbstractBargeEntity> getBarges() {
        if (this.head.checkNoLoopsDominated()) {
            this.head.removeDominated();
            this.head.getDominated().map(Pair::getFirst).ifPresent(ISpringableEntity::removeDominant);
            return new ArrayList<AbstractBargeEntity>();
        }
        return this.tug.map(tugEntity -> {
            ArrayList<AbstractBargeEntity> barges = new ArrayList<AbstractBargeEntity>();
            Optional<AbstractBargeEntity> barge = this.getNextBarge((ISpringableEntity)tugEntity);
            while (barge.isPresent()) {
                barges.add(barge.get());
                barge = this.getNextBarge(barge.get());
            }
            return barges;
        }).orElse(new ArrayList());
    }

    public Optional<AbstractBargeEntity> getNextBarge(ISpringableEntity entity) {
        return entity.getDominated().map(Pair::getFirst).map(e -> (AbstractBargeEntity)e);
    }

    public void setHead(ISpringableEntity head) {
        this.head = head;
    }
}

