/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import dev.murad.shipping.entity.custom.ISpringableEntity;
import dev.murad.shipping.entity.custom.SpringEntity;
import dev.murad.shipping.entity.custom.barge.AbstractBargeEntity;
import dev.murad.shipping.entity.custom.tug.TugDummyHitboxEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class EntitySpringAPI {
    private static final BiFunction<Entity, SpringEntity.SpringSide, Vector3d> DEFAULT_ANCHOR_LOCATION = (e, sideArg) -> e.func_213303_ch();
    private static final List<Predicate<Entity>> predicates = new ArrayList<Predicate<Entity>>();
    private static final Map<Class<? extends Entity>, BiFunction<Entity, SpringEntity.SpringSide, Vector3d>> mapping = new HashMap<Class<? extends Entity>, BiFunction<Entity, SpringEntity.SpringSide, Vector3d>>();
    public static final BiFunction<Entity, SpringEntity.SpringSide, Vector3d> DEFAULT_BOAT_ANCHOR = (entity, side) -> {
        float distanceFromCenter = 1.0625f * (side == SpringEntity.SpringSide.DOMINANT ? 1.0f : -1.0f);
        double anchorX = entity.func_226277_ct_() + (double)(MathHelper.func_76134_b((float)((float)((double)(entity.field_70177_z + 90.0f) * Math.PI / 180.0))) * distanceFromCenter);
        double anchorY = entity.func_226278_cu_();
        double anchorZ = entity.func_226281_cx_() + (double)(MathHelper.func_76126_a((float)((float)((double)(entity.field_70177_z + 90.0f) * Math.PI / 180.0))) * distanceFromCenter);
        return new Vector3d(anchorX, anchorY, anchorZ);
    };

    private EntitySpringAPI() {
    }

    public static boolean isValidTarget(Entity target) {
        return target instanceof ISpringableEntity || target instanceof TugDummyHitboxEntity;
    }

    public static void addGenericAnchorMapping(Class<? extends Entity> entity, BiFunction<Entity, SpringEntity.SpringSide, Vector3d> function) {
        mapping.put(entity, function);
    }

    public static <T extends Entity> void addAnchorMapping(Class<? extends T> entity, BiFunction<T, SpringEntity.SpringSide, Vector3d> function) {
        mapping.put(entity, (e, side) -> (Vector3d)function.apply((Object)e, (SpringEntity.SpringSide)((Object)side)));
    }

    public static Vector3d calculateAnchorPosition(Entity entity, SpringEntity.SpringSide side) {
        BiFunction<Entity, SpringEntity.SpringSide, Vector3d> function = mapping.getOrDefault(entity.getClass(), DEFAULT_ANCHOR_LOCATION);
        return function.apply(entity, side);
    }

    static {
        EntitySpringAPI.addGenericAnchorMapping(AbstractBargeEntity.class, DEFAULT_BOAT_ANCHOR);
    }
}

