/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.item;

import dev.murad.shipping.entity.custom.ISpringableEntity;
import dev.murad.shipping.entity.custom.SpringEntity;
import dev.murad.shipping.entity.custom.VesselEntity;
import dev.murad.shipping.entity.custom.tug.TugDummyHitboxEntity;
import dev.murad.shipping.util.Train;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SpringItem
extends Item {
    private TranslationTextComponent springInfo = new TranslationTextComponent("item.littlelogistics.spring.description");

    public SpringItem(Item.Properties properties) {
        super(properties);
    }

    public void onUsedOnEntity(ItemStack stack, PlayerEntity player, World world, Entity target) {
        if (target instanceof TugDummyHitboxEntity) {
            target = ((TugDummyHitboxEntity)((Object)target)).getTug();
        }
        if (world.field_72995_K) {
            return;
        }
        switch (SpringItem.getState(stack)) {
            case WAITING_NEXT: {
                this.createSpringHelper(stack, player, world, (Entity)target);
                break;
            }
            default: {
                this.setDominant(world, stack, (Entity)target);
            }
        }
    }

    private void createSpringHelper(ItemStack stack, PlayerEntity player, World world, Entity target) {
        Entity dominant = this.getDominant(world, stack);
        if (dominant == null) {
            return;
        }
        if (dominant == target) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("item.littlelogistics.spring.notToSelf"), true);
        } else if (dominant instanceof ISpringableEntity) {
            Train firstTrain = ((ISpringableEntity)dominant).getTrain();
            Train secondTrain = ((ISpringableEntity)target).getTrain();
            if (dominant.func_70032_d(target) > 15.0f) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("item.littlelogistics.spring.tooFar"), true);
            } else if (firstTrain.getTug().isPresent() && secondTrain.getTug().isPresent()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("item.littlelogistics.spring.noTwoTugs"), true);
            } else if (secondTrain.equals(firstTrain)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("item.littlelogistics.spring.noLoops"), true);
            } else if (firstTrain.getTug().isPresent()) {
                SpringEntity.createSpring((VesselEntity)firstTrain.getTail(), (VesselEntity)secondTrain.getHead());
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            } else {
                SpringEntity.createSpring((VesselEntity)secondTrain.getTail(), (VesselEntity)firstTrain.getHead());
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            }
        }
        this.resetLinked(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)this.springInfo);
    }

    private void setDominant(World worldIn, ItemStack stack, Entity entity) {
        SpringItem.nbt(stack).func_74768_a("linked", entity.func_145782_y());
    }

    private Entity getDominant(World worldIn, ItemStack stack) {
        int id = SpringItem.nbt(stack).func_74762_e("linked");
        return worldIn.func_73045_a(id);
    }

    private static CompoundNBT nbt(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        return stack.func_77978_p();
    }

    private void resetLinked(ItemStack itemstack) {
        SpringItem.nbt(itemstack).func_82580_o("linked");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        this.resetLinked(playerIn.func_184586_b(handIn));
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public static State getState(ItemStack stack) {
        if (SpringItem.nbt(stack).func_74764_b("linked")) {
            return State.WAITING_NEXT;
        }
        return State.READY;
    }

    public static enum State {
        WAITING_NEXT,
        READY;

    }
}

