/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.murad.shipping.entity.custom.SpringEntity;
import dev.murad.shipping.entity.custom.VesselEntity;
import dev.murad.shipping.entity.models.ChainModel;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.LightType;

public abstract class VesselRenderer<T extends VesselEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation CHAIN_TEXTURE = new ResourceLocation("littlelogistics", "textures/entity/chain.png");
    private static final ChainModel chainModel = new ChainModel();

    public VesselRenderer(EntityRendererManager p_i46179_1_) {
        super(p_i46179_1_);
    }

    public void render(T vesselEntity, float p_225623_2_, float p_225623_3_, MatrixStack matrixStack, IRenderTypeBuffer buffer, int p_225623_6_) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, this.getModelYoffset(), 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - p_225623_2_));
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(this.getModelYrot()));
        this.renderModel(vesselEntity, matrixStack, buffer, p_225623_6_);
        this.getAndRenderChain(vesselEntity, matrixStack, buffer, p_225623_6_);
        matrixStack.func_227865_b_();
        this.getAndRenderLeash(vesselEntity, p_225623_2_, p_225623_3_, matrixStack, buffer, p_225623_6_);
    }

    private void renderModel(T vesselEntity, MatrixStack matrixStack, IRenderTypeBuffer buffer, int p_225623_6_) {
        IVertexBuilder ivertexbuilder = buffer.getBuffer(this.getModel(vesselEntity).func_228282_a_(this.func_110775_a((Entity)vesselEntity)));
        this.getModel(vesselEntity).func_225598_a_(matrixStack, ivertexbuilder, p_225623_6_, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected double getModelYoffset() {
        return 0.275;
    }

    protected float getModelYrot() {
        return 90.0f;
    }

    private void getAndRenderChain(T bargeEntity, MatrixStack matrixStack, IRenderTypeBuffer buffer, int p_225623_6_) {
        if (((VesselEntity)bargeEntity).getDominant().isPresent()) {
            double dist = ((Entity)((VesselEntity)bargeEntity).getDominant().get().getFirst()).func_70032_d(bargeEntity);
            IVertexBuilder ivertexbuilderChain = buffer.getBuffer(chainModel.func_228282_a_(CHAIN_TEXTURE));
            int segments = (int)Math.ceil(dist * 4.0);
            matrixStack.func_227860_a_();
            for (int i = 0; i < segments; ++i) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)i / 4.0, 0.0, 0.0);
                chainModel.func_225598_a_(matrixStack, ivertexbuilderChain, p_225623_6_, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStack.func_227865_b_();
            }
            matrixStack.func_227865_b_();
        }
    }

    private void getAndRenderLeash(T bargeEntity, float p_225623_2_, float p_225623_3_, MatrixStack matrixStack, IRenderTypeBuffer buffer, int p_225623_6_) {
        matrixStack.func_227860_a_();
        Entity entity = bargeEntity.func_110166_bE();
        super.func_225623_a_(bargeEntity, p_225623_2_, p_225623_3_, matrixStack, buffer, p_225623_6_);
        if (entity != null) {
            matrixStack.func_227860_a_();
            this.renderLeash(bargeEntity, p_225623_3_, matrixStack, buffer, entity);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    public boolean shouldRender(T p_225626_1_, ClippingHelper p_225626_2_, double p_225626_3_, double p_225626_5_, double p_225626_7_) {
        if (((VesselEntity)p_225626_1_).getDominant().isPresent()) {
            if (((Entity)((VesselEntity)p_225626_1_).getDominant().get().getFirst()).func_145770_h(p_225626_3_, p_225626_5_, p_225626_7_)) {
                return true;
            }
            if (((SpringEntity)((Object)((VesselEntity)p_225626_1_).getDominant().get().getSecond())).func_145770_h(p_225626_3_, p_225626_5_, p_225626_7_)) {
                return true;
            }
        }
        return super.func_225626_a_(p_225626_1_, p_225626_2_, p_225626_3_, p_225626_5_, p_225626_7_);
    }

    abstract EntityModel getModel(T var1);

    private <E extends Entity> void renderLeash(T p_229118_1_, float p_229118_2_, MatrixStack p_229118_3_, IRenderTypeBuffer p_229118_4_, E p_229118_5_) {
        p_229118_3_.func_227860_a_();
        Vector3d vector3d = p_229118_5_.func_241843_o(p_229118_2_);
        double d0 = (double)(MathHelper.func_219799_g((float)p_229118_2_, (float)((VesselEntity)p_229118_1_).field_70761_aq, (float)((VesselEntity)p_229118_1_).field_70760_ar) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vector3d vector3d1 = p_229118_1_.func_241205_ce_();
        double d1 = Math.cos(d0) * vector3d1.field_72449_c + Math.sin(d0) * vector3d1.field_72450_a;
        double d2 = Math.sin(d0) * vector3d1.field_72449_c - Math.cos(d0) * vector3d1.field_72450_a;
        double d3 = MathHelper.func_219803_d((double)p_229118_2_, (double)((VesselEntity)p_229118_1_).field_70169_q, (double)p_229118_1_.func_226277_ct_()) + d1;
        double d4 = MathHelper.func_219803_d((double)p_229118_2_, (double)((VesselEntity)p_229118_1_).field_70167_r, (double)p_229118_1_.func_226278_cu_()) + vector3d1.field_72448_b;
        double d5 = MathHelper.func_219803_d((double)p_229118_2_, (double)((VesselEntity)p_229118_1_).field_70166_s, (double)p_229118_1_.func_226281_cx_()) + d2;
        p_229118_3_.func_227861_a_(d1, vector3d1.field_72448_b, d2);
        float f = (float)(vector3d.field_72450_a - d3);
        float f1 = (float)(vector3d.field_72448_b - d4);
        float f2 = (float)(vector3d.field_72449_c - d5);
        IVertexBuilder ivertexbuilder = p_229118_4_.getBuffer(RenderType.func_228649_h_());
        Matrix4f matrix4f = p_229118_3_.func_227866_c_().func_227870_a_();
        float f4 = MathHelper.func_226165_i_((float)(f * f + f2 * f2)) * 0.025f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = new BlockPos(p_229118_1_.func_174824_e(p_229118_2_));
        BlockPos blockpos1 = new BlockPos(p_229118_5_.func_174824_e(p_229118_2_));
        int i = this.func_225624_a_((Entity)p_229118_1_, blockpos);
        int k = ((VesselEntity)p_229118_1_).field_70170_p.func_226658_a_(LightType.SKY, blockpos);
        int l = ((VesselEntity)p_229118_1_).field_70170_p.func_226658_a_(LightType.SKY, blockpos1);
        MobRenderer.func_229119_a_((IVertexBuilder)ivertexbuilder, (Matrix4f)matrix4f, (float)f, (float)f1, (float)f2, (int)i, (int)i, (int)k, (int)l, (float)0.025f, (float)0.025f, (float)f5, (float)f6);
        MobRenderer.func_229119_a_((IVertexBuilder)ivertexbuilder, (Matrix4f)matrix4f, (float)f, (float)f1, (float)f2, (int)i, (int)i, (int)k, (int)l, (float)0.025f, (float)0.0f, (float)f5, (float)f6);
        p_229118_3_.func_227865_b_();
    }
}

