/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.tug;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.block.dock.TugDockTileEntity;
import dev.murad.shipping.block.guide_rail.TugGuideRailBlock;
import dev.murad.shipping.entity.accessor.DataAccessor;
import dev.murad.shipping.entity.custom.ISpringableEntity;
import dev.murad.shipping.entity.custom.SpringEntity;
import dev.murad.shipping.entity.custom.VesselEntity;
import dev.murad.shipping.entity.custom.tug.TugDummyHitboxEntity;
import dev.murad.shipping.entity.navigation.TugPathNavigator;
import dev.murad.shipping.item.TugRouteItem;
import dev.murad.shipping.setup.ModBlocks;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.setup.ModSounds;
import dev.murad.shipping.util.Train;
import dev.murad.shipping.util.TugRoute;
import dev.murad.shipping.util.TugRouteNode;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractTugEntity
extends VesselEntity
implements ISpringableEntity,
IInventory,
ISidedInventory {
    protected final ItemStackHandler itemHandler = this.createHandler();
    protected final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    protected boolean contentsChanged = false;
    protected boolean docked = false;
    private int dockCheckCooldown = 0;
    private boolean independentMotion = false;
    private int pathfindCooldown = 0;
    private static final DataParameter<Boolean> INDEPENDENT_MOTION = EntityDataManager.func_187226_a(AbstractTugEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private TugDummyHitboxEntity extraHitbox = null;
    private TugRoute path;
    private int nextStop;

    @Override
    public boolean allowDockInterface() {
        return this.isDocked();
    }

    public AbstractTugEntity(EntityType<? extends WaterMobEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
        this.train = new Train(this);
        this.path = new TugRoute();
    }

    public AbstractTugEntity(EntityType type, World worldIn, double x, double y, double z) {
        this((EntityType<? extends WaterMobEntity>)type, worldIn);
        this.func_70107_b(x, y, z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public void func_110160_i(boolean p_110160_1_, boolean p_110160_2_) {
        this.field_70699_by.func_188554_j();
        super.func_110160_i(p_110160_1_, p_110160_2_);
    }

    public abstract DataAccessor getDataAccessor();

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean func_96092_aw() {
        return true;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1 + this.getNonRouteItemSlots()){

            protected void onContentsChanged(int slot) {
                AbstractTugEntity.this.contentsChanged = true;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return stack.func_77973_b() == ModItems.TUG_ROUTE.get();
                    }
                }
                return AbstractTugEntity.this.isTugSlotItemValid(slot, stack);
            }

            public int getSlotLimit(int slot) {
                switch (slot) {
                    case 0: {
                        return 1;
                    }
                }
                return AbstractTugEntity.this.getTugSlotLimit(slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    protected abstract int getNonRouteItemSlots();

    protected boolean isTugSlotItemValid(int slot, @Nonnull ItemStack stack) {
        return false;
    }

    protected int getTugSlotLimit(int slot) {
        return 0;
    }

    public TugDummyHitboxEntity getDummyHitbox() {
        return this.extraHitbox;
    }

    protected abstract INamedContainerProvider createContainerProvider();

    @Override
    public void func_70037_a(CompoundNBT compound) {
        this.itemHandler.deserializeNBT(compound.func_74775_l("inv"));
        this.nextStop = compound.func_74764_b("next_stop") ? compound.func_74762_e("next_stop") : 0;
        this.contentsChanged = true;
        this.extraHitbox = null;
        super.func_70037_a(compound);
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("inv", (INBT)this.itemHandler.serializeNBT());
        compound.func_74768_a("next_stop", this.nextStop);
        super.func_213281_b(compound);
    }

    private void tickRouteCheck() {
        if (this.contentsChanged) {
            ItemStack stack = this.itemHandler.getStackInSlot(0);
            this.setPath(TugRouteItem.getRoute(stack));
            this.contentsChanged = false;
        }
        if (this.nextStop >= this.path.size()) {
            this.nextStop = 0;
        }
    }

    protected abstract boolean tickFuel();

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return VesselEntity.setCustomAttributes().func_233815_a_(Attributes.field_233819_b_, 200.0);
    }

    protected void onDock() {
        this.func_184185_a((SoundEvent)ModSounds.TUG_DOCKING.get(), 0.6f, 1.0f);
    }

    protected void onUndock() {
        this.func_184185_a((SoundEvent)ModSounds.TUG_UNDOCKING.get(), 0.6f, 1.5f);
    }

    private List<Direction> getSideDirections() {
        return this.func_174811_aO() == Direction.NORTH || this.func_174811_aO() == Direction.SOUTH ? Arrays.asList(Direction.EAST, Direction.WEST) : Arrays.asList(Direction.NORTH, Direction.SOUTH);
    }

    private void tickCheckDock() {
        int x = (int)Math.floor(this.func_226277_ct_());
        int y = (int)Math.floor(this.func_226278_cu_());
        int z = (int)Math.floor(this.func_226281_cx_());
        if (this.docked && this.dockCheckCooldown > 0) {
            --this.dockCheckCooldown;
            this.func_213317_d(Vector3d.field_186680_a);
            this.func_225653_b_((double)x + 0.5, this.func_226278_cu_(), (double)z + 0.5);
            return;
        }
        boolean shouldDock = this.getSideDirections().stream().map(curr -> Optional.ofNullable(this.field_70170_p.func_175625_s(new BlockPos(x + curr.func_82601_c(), y, z + curr.func_82599_e()))).filter(entity -> entity instanceof TugDockTileEntity).map(entity -> (TugDockTileEntity)((Object)((Object)entity))).map(dock -> dock.holdVessel(this, (Direction)curr)).orElse(false)).reduce(false, (acc, curr) -> acc != false || curr != false);
        boolean changedDock = !this.docked && shouldDock;
        boolean changedUndock = this.docked && !shouldDock;
        this.docked = shouldDock;
        if (this.docked) {
            this.dockCheckCooldown = 20;
            this.func_213317_d(Vector3d.field_186680_a);
            this.func_225653_b_((double)x + 0.5, this.func_226278_cu_(), (double)z + 0.5);
        } else {
            this.dockCheckCooldown = 0;
        }
        if (changedDock) {
            this.onDock();
        }
        if (changedUndock) {
            this.onUndock();
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void makeSmoke() {
        World world = this.field_70170_p;
        if (world != null) {
            BlockPos blockpos = this.func_226268_ag_().func_177984_a().func_177984_a();
            Random random = world.field_73012_v;
            if ((double)random.nextFloat() < (Double)ShippingConfig.Client.TUG_SMOKE_MODIFIER.get()) {
                for (int i = 0; i < random.nextInt(2) + 2; ++i) {
                    AbstractTugEntity.makeParticles(world, blockpos, true, false);
                }
            }
        }
    }

    public static void makeParticles(World p_220098_0_, BlockPos p_220098_1_, boolean p_220098_2_, boolean p_220098_3_) {
        Random random = p_220098_0_.func_201674_k();
        Supplier<Boolean> h = () -> random.nextDouble() < 0.5;
        BasicParticleType basicparticletype = p_220098_2_ ? ParticleTypes.field_218418_af : ParticleTypes.field_218417_ae;
        double xdrift = (double)(h.get() != false ? 1 : -1) * random.nextDouble() * 2.0;
        double zdrift = (double)(h.get() != false ? 1 : -1) * random.nextDouble() * 2.0;
        p_220098_0_.func_217404_b((IParticleData)basicparticletype, true, (double)p_220098_1_.func_177958_n() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)p_220098_1_.func_177956_o() + random.nextDouble() + random.nextDouble(), (double)p_220098_1_.func_177952_p() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.007 * xdrift, 0.05, 0.007 * zdrift);
    }

    protected PathNavigator func_175447_b(World p_175447_1_) {
        return new TugPathNavigator((MobEntity)this, p_175447_1_);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!player.field_70170_p.func_201670_d()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.createContainerProvider(), this.getDataAccessor()::write);
        }
        return ActionResultType.CONSUME;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.field_70170_p.field_72995_K && INDEPENDENT_MOTION.equals(key)) {
            this.independentMotion = (Boolean)this.field_70180_af.func_187225_a(INDEPENDENT_MOTION);
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MovementGoal());
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.extraHitbox == null || !this.extraHitbox.func_70089_S()) {
                this.extraHitbox = new TugDummyHitboxEntity(this);
                this.field_70170_p.func_217376_c((Entity)this.extraHitbox);
            }
            this.extraHitbox.updatePosition();
        }
        if (this.field_70170_p.field_72995_K && this.independentMotion) {
            this.makeSmoke();
        }
        super.func_70071_h_();
    }

    private void followGuideRail() {
        List<BlockState> belowList = Arrays.asList(this.field_70170_p.func_180495_p(this.func_226268_ag_().func_177977_b()), this.field_70170_p.func_180495_p(this.func_226268_ag_().func_177977_b().func_177977_b()));
        BlockState water = this.field_70170_p.func_180495_p(this.func_226268_ag_());
        for (BlockState below : belowList) {
            if (!below.func_177230_c().func_235332_a_((Block)ModBlocks.GUIDE_RAIL_TUG.get()) || !water.func_203425_a(Blocks.field_150355_j)) continue;
            Direction arrows = TugGuideRailBlock.getArrowsDirection(below);
            this.field_70177_z = arrows.func_185119_l();
            double modifier = 0.03;
            this.func_213317_d(this.func_213322_ci().func_178787_e(new Vector3d((double)arrows.func_82601_c() * modifier, 0.0, (double)arrows.func_82599_e() * modifier)));
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    private void followPath() {
        --this.pathfindCooldown;
        if (!this.path.isEmpty() && !this.docked && this.tickFuel()) {
            TugRouteNode stop = (TugRouteNode)this.path.get(this.nextStop);
            if (this.field_70699_by.func_75505_d() == null || this.field_70699_by.func_75505_d().func_75879_b()) {
                if (this.pathfindCooldown < 0) {
                    this.field_70699_by.func_75492_a(stop.getX(), this.func_226278_cu_(), stop.getZ(), 0.3);
                    this.pathfindCooldown = 20;
                } else {
                    return;
                }
            }
            double distance = Math.abs(Math.hypot(this.func_226277_ct_() - (stop.getX() + 0.5), this.func_226281_cx_() - (stop.getZ() + 0.5)));
            this.independentMotion = true;
            this.field_70180_af.func_187227_b(INDEPENDENT_MOTION, (Object)true);
            if (distance < 0.6) {
                this.incrementStop();
            }
        } else {
            this.field_70180_af.func_187227_b(INDEPENDENT_MOTION, (Object)false);
            this.field_70699_by.func_75499_g();
            if (this.path.isEmpty()) {
                this.nextStop = 0;
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INDEPENDENT_MOTION, (Object)false);
    }

    public void setPath(TugRoute path) {
        if (!this.path.isEmpty() && !this.path.equals(path)) {
            this.nextStop = 0;
        }
        this.path = path;
    }

    private void incrementStop() {
        if (this.path.size() == 1) {
            this.nextStop = 0;
        } else if (!this.path.isEmpty()) {
            this.nextStop = (this.nextStop + 1) % this.path.size();
        }
    }

    @Override
    public void setDominated(ISpringableEntity entity, SpringEntity spring) {
        this.dominated = Optional.of(new Pair((Object)entity, (Object)spring));
    }

    @Override
    public void setDominant(ISpringableEntity entity, SpringEntity spring) {
    }

    @Override
    public void removeDominated() {
        this.dominated = Optional.empty();
        this.train.setTail(this);
    }

    @Override
    public void removeDominant() {
    }

    @Override
    public void setTrain(Train train) {
        this.train = train;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.func_199703_a((IItemProvider)this.getDropItem());
            this.func_70106_y();
            return true;
        }
        return true;
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this);
        }
        this.handleSpringableKill();
        super.func_70106_y();
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return this.itemHandler.getStackInSlot(p_70301_1_);
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public void func_70296_d() {
        this.contentsChanged = true;
    }

    public boolean func_70300_a(PlayerEntity p_70300_1_) {
        if (this.field_70128_L) {
            return false;
        }
        return !(p_70300_1_.func_70068_e((Entity)this) > 64.0);
    }

    public void func_174888_l() {
    }

    public boolean func_180461_b(int p_180461_1_, ItemStack p_180461_2_, Direction p_180461_3_) {
        return false;
    }

    public int[] func_180463_a(Direction p_180463_1_) {
        return IntStream.range(1, this.func_70302_i_()).toArray();
    }

    public boolean func_180462_a(int p_180462_1_, ItemStack p_180462_2_, @Nullable Direction p_180462_3_) {
        return this.isDocked();
    }

    public int func_70302_i_() {
        return 1 + this.getNonRouteItemSlots();
    }

    public boolean isDocked() {
        return this.docked;
    }

    public boolean func_184652_a(PlayerEntity p_184652_1_) {
        return true;
    }

    class MovementGoal
    extends Goal {
        MovementGoal() {
        }

        public boolean func_75250_a() {
            return AbstractTugEntity.this.path != null;
        }

        public void func_75246_d() {
            if (!AbstractTugEntity.this.field_70170_p.field_72995_K) {
                AbstractTugEntity.this.tickRouteCheck();
                AbstractTugEntity.this.tickCheckDock();
                AbstractTugEntity.this.followPath();
                AbstractTugEntity.this.followGuideRail();
            }
        }
    }
}

