/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.entity.custom.ISpringableEntity;
import dev.murad.shipping.entity.custom.SpringEntity;
import dev.murad.shipping.util.Train;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class VesselEntity
extends WaterMobEntity
implements ISpringableEntity {
    private float invFriction;
    private int stuckCounter = 0;
    private double waterLevel;
    private float landFriction;
    private BoatEntity.Status status;
    private BoatEntity.Status oldStatus;
    private double lastYd;
    protected Optional<Pair<ISpringableEntity, SpringEntity>> dominated = Optional.empty();
    protected Optional<Pair<ISpringableEntity, SpringEntity>> dominant = Optional.empty();
    protected Train train;

    protected VesselEntity(EntityType<? extends WaterMobEntity> type, World world) {
        super(type, world);
        this.resetSpeedAttributes();
        this.setSpeedAttributes((Double)ShippingConfig.Server.TUG_BASE_SPEED.get());
    }

    public boolean func_70067_L() {
        return true;
    }

    public abstract boolean allowDockInterface();

    @Override
    public boolean hasWaterOnSides() {
        return this.field_70170_p.func_180495_p(this.func_226268_ag_().func_177972_a(this.func_174811_aO().func_176746_e())).func_177230_c().equals(Blocks.field_150355_j) && this.field_70170_p.func_180495_p(this.func_226268_ag_().func_177972_a(this.func_174811_aO().func_176735_f())).func_177230_c().equals(Blocks.field_150355_j) && this.field_70170_p.func_180495_p(this.func_226268_ag_().func_177984_a().func_177972_a(this.func_174811_aO().func_176746_e())).func_177230_c().equals(Blocks.field_150350_a) && this.field_70170_p.func_180495_p(this.func_226268_ag_().func_177984_a().func_177972_a(this.func_174811_aO().func_176735_f())).func_177230_c().equals(Blocks.field_150350_a);
    }

    public BlockPos getBlockPos() {
        return this.func_226268_ag_();
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            this.tickSpringAliveCheck();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.oldStatus = this.status;
            this.status = this.getStatus();
            this.floatBoat();
            this.unDrown();
        }
        super.func_70071_h_();
    }

    private void unDrown() {
        if (this.field_70170_p.func_180495_p(this.func_226268_ag_().func_177984_a()).func_177230_c().equals(Blocks.field_150355_j)) {
            this.func_213317_d(this.func_213322_ci().func_178787_e(new Vector3d(0.0, 0.1, 0.0)));
        }
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.0).func_233815_a_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.0);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.resetSpeedAttributes();
    }

    private void resetSpeedAttributes() {
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(0.0);
    }

    private void setSpeedAttributes(double speed) {
        this.func_110148_a(Attributes.field_233821_d_).func_233767_b_(new AttributeModifier("movementspeed_mult", speed, AttributeModifier.Operation.ADDITION));
        this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_233767_b_(new AttributeModifier("swimspeed_mult", speed, AttributeModifier.Operation.ADDITION));
    }

    protected void func_209207_l(int p_209207_1_) {
        this.func_70050_g(300);
    }

    public abstract Item getDropItem();

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)this.getDropItem());
    }

    @Override
    public Optional<Pair<ISpringableEntity, SpringEntity>> getDominated() {
        return this.dominated;
    }

    @Override
    public Optional<Pair<ISpringableEntity, SpringEntity>> getDominant() {
        return this.dominant;
    }

    @Override
    public Train getTrain() {
        return this.train;
    }

    public void func_70623_bb() {
    }

    private void floatBoat() {
        double d0 = -0.04f;
        double d1 = this.func_189652_ae() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.invFriction = 0.05f;
        if (this.oldStatus == BoatEntity.Status.IN_AIR && this.status != BoatEntity.Status.IN_AIR && this.status != BoatEntity.Status.ON_LAND) {
            this.waterLevel = this.func_226283_e_(1.0);
            this.func_70107_b(this.func_226277_ct_(), (double)(this.getWaterLevelAbove() - this.func_213302_cg()) + 0.101, this.func_226281_cx_());
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = BoatEntity.Status.IN_WATER;
        } else {
            if (this.status == BoatEntity.Status.IN_WATER) {
                d2 = (this.waterLevel - this.func_226278_cu_()) / (double)this.func_213302_cg();
                this.invFriction = 0.9f;
            } else if (this.status == BoatEntity.Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.invFriction = 0.9f;
            } else if (this.status == BoatEntity.Status.UNDER_WATER) {
                d2 = 0.01f;
                this.invFriction = 0.45f;
            } else if (this.status == BoatEntity.Status.IN_AIR) {
                this.invFriction = 0.9f;
            } else if (this.status == BoatEntity.Status.ON_LAND) {
                this.invFriction = this.landFriction;
                if (this.func_184179_bs() instanceof PlayerEntity) {
                    this.landFriction /= 2.0f;
                }
            }
            Vector3d vector3d = this.func_213322_ci();
            this.func_213293_j(vector3d.field_72450_a * (double)this.invFriction, vector3d.field_72448_b + d1, vector3d.field_72449_c * (double)this.invFriction);
            if (d2 > 0.0) {
                Vector3d vector3d1 = this.func_213322_ci();
                this.func_213293_j(vector3d1.field_72450_a, (vector3d1.field_72448_b + d2 * 0.10153846016296973) * 0.75, vector3d1.field_72449_c);
            }
        }
    }

    public float getWaterLevelAbove() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.lastYd));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(l1, k1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                        f = Math.max(f, fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutable.func_177956_o() + f;
        }
        return l + 1;
    }

    private BoatEntity.Status getStatus() {
        BoatEntity.Status boatentity$status = this.isUnderwater();
        if (boatentity$status != null) {
            this.waterLevel = this.func_174813_aQ().field_72337_e;
            return boatentity$status;
        }
        if (this.checkInWater()) {
            return BoatEntity.Status.IN_WATER;
        }
        float f = this.getGroundFriction();
        if (f > 0.0f) {
            this.landFriction = f;
            return BoatEntity.Status.ON_LAND;
        }
        return BoatEntity.Status.IN_AIR;
    }

    public float getGroundFriction() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b - 0.001, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        int i = MathHelper.func_76128_c((double)axisalignedbb1.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)axisalignedbb1.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)axisalignedbb1.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)axisalignedbb1.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)axisalignedbb1.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)axisalignedbb1.field_72334_f) + 1;
        VoxelShape voxelshape = VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutable.func_181079_c(l1, k2, i2);
                    BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
                    if (blockstate.func_177230_c() instanceof LilyPadBlock || !VoxelShapes.func_197879_c((VoxelShape)blockstate.func_196952_d((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable).func_197751_a((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
                    f += blockstate.getSlipperiness((IWorldReader)this.field_70170_p, (BlockPos)blockpos$mutable, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                    float f = (float)l1 + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= axisalignedbb.field_72338_b < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private BoatEntity.Status isUnderwater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) || !(d0 < (double)((float)blockpos$mutable.func_177956_o() + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable)))) continue;
                    if (!fluidstate.func_206889_d()) {
                        return BoatEntity.Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? BoatEntity.Status.UNDER_WATER : null;
    }

    protected void func_180466_bG(ITag<Fluid> p_180466_1_) {
        if (this.func_70661_as().func_212238_t()) {
            super.func_180466_bG(p_180466_1_);
        } else {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.3, 0.0));
        }
    }

    public boolean func_180431_b(DamageSource p_180431_1_) {
        return p_180431_1_.equals(DamageSource.field_76368_d) || super.func_180431_b(p_180431_1_);
    }

    public void func_145775_I() {
        super.func_145775_I();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70613_aW() || this.func_184186_bw()) {
            double d0 = 0.08;
            ModifiableAttributeInstance gravity = this.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            boolean flag = this.func_213322_ci().field_72448_b <= 0.0;
            d0 = gravity.func_111126_e();
            FluidState fluidstate = this.field_70170_p.func_204610_c(this.func_233580_cy_());
            if (this.func_70090_H() && this.func_241208_cS_() && !this.func_230285_a_(fluidstate.func_206886_c())) {
                double d8 = this.func_226278_cu_();
                float f5 = this.func_70051_ag() ? 0.9f : this.func_189749_co();
                float f6 = 0.02f;
                float f7 = 0.0f;
                if (f7 > 3.0f) {
                    f7 = 3.0f;
                }
                if (!this.field_70122_E) {
                    f7 *= 0.5f;
                }
                if (f7 > 0.0f) {
                    f5 += (0.54600006f - f5) * f7 / 3.0f;
                    f6 += (this.func_70689_ay() - f6) * f7 / 3.0f;
                }
                if (this.func_70644_a(Effects.field_206827_D)) {
                    f5 = 0.96f;
                }
                this.func_213309_a(f6 *= (float)this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e(), p_213352_1_);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                Vector3d vector3d6 = this.func_213322_ci();
                if (this.field_70123_F && this.func_70617_f_()) {
                    vector3d6 = new Vector3d(vector3d6.field_72450_a, 0.2, vector3d6.field_72449_c);
                }
                this.func_213317_d(vector3d6.func_216372_d((double)f5, (double)0.8f, (double)f5));
                Vector3d vector3d2 = this.func_233626_a_(d0, flag, this.func_213322_ci());
                this.func_213317_d(vector3d2);
                if (this.field_70123_F) {
                    if (this.stuckCounter > 10) {
                        Direction direction = this.func_174811_aO();
                        BlockPos front = this.func_226268_ag_().func_177972_a(direction).func_177984_a();
                        BlockPos left = front.func_177972_a(direction.func_176746_e());
                        BlockPos right = front.func_177972_a(direction.func_176735_f());
                        for (BlockPos pos : Arrays.asList(front, left, right)) {
                            BlockState state = this.field_70170_p.func_180495_p(pos);
                            if (!state.func_203425_a(Blocks.field_196651_dG)) continue;
                            this.field_70170_p.func_175655_b(pos, true);
                        }
                        this.stuckCounter = 0;
                    } else {
                        ++this.stuckCounter;
                    }
                }
            } else if (this.func_180799_ab() && this.func_241208_cS_() && !this.func_230285_a_(fluidstate.func_206886_c())) {
                double d7 = this.func_226278_cu_();
                this.func_213309_a(0.02f, p_213352_1_);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                if (this.func_233571_b_((ITag)FluidTags.field_206960_b) <= this.func_233579_cu_()) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, (double)0.8f, 0.5));
                    Vector3d vector3d3 = this.func_233626_a_(d0, flag, this.func_213322_ci());
                    this.func_213317_d(vector3d3);
                } else {
                    this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
                }
                if (!this.func_189652_ae()) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -d0 / 4.0, 0.0));
                }
                Vector3d vector3d4 = this.func_213322_ci();
                if (this.field_70123_F && this.func_70038_c(vector3d4.field_72450_a, vector3d4.field_72448_b + (double)0.6f - this.func_226278_cu_() + d7, vector3d4.field_72449_c)) {
                    this.func_213293_j(vector3d4.field_72450_a, 0.3f, vector3d4.field_72449_c);
                }
            } else if (this.func_184613_cA()) {
                double d10;
                double d6;
                float f2;
                Vector3d vector3d = this.func_213322_ci();
                if (vector3d.field_72448_b > -0.5) {
                    this.field_70143_R = 1.0f;
                }
                Vector3d vector3d1 = this.func_70040_Z();
                float f = this.field_70125_A * ((float)Math.PI / 180);
                double d1 = Math.sqrt(vector3d1.field_72450_a * vector3d1.field_72450_a + vector3d1.field_72449_c * vector3d1.field_72449_c);
                double d3 = Math.sqrt(VesselEntity.func_213296_b((Vector3d)vector3d));
                double d4 = vector3d1.func_72433_c();
                float f1 = MathHelper.func_76134_b((float)f);
                f1 = (float)((double)f1 * (double)f1 * Math.min(1.0, d4 / 0.4));
                vector3d = this.func_213322_ci().func_72441_c(0.0, d0 * (-1.0 + (double)f1 * 0.75), 0.0);
                if (vector3d.field_72448_b < 0.0 && d1 > 0.0) {
                    double d5 = vector3d.field_72448_b * -0.1 * (double)f1;
                    vector3d = vector3d.func_72441_c(vector3d1.field_72450_a * d5 / d1, d5, vector3d1.field_72449_c * d5 / d1);
                }
                if (f < 0.0f && d1 > 0.0) {
                    double d9 = d3 * (double)(-MathHelper.func_76126_a((float)f)) * 0.04;
                    vector3d = vector3d.func_72441_c(-vector3d1.field_72450_a * d9 / d1, d9 * 3.2, -vector3d1.field_72449_c * d9 / d1);
                }
                if (d1 > 0.0) {
                    vector3d = vector3d.func_72441_c((vector3d1.field_72450_a / d1 * d3 - vector3d.field_72450_a) * 0.1, 0.0, (vector3d1.field_72449_c / d1 * d3 - vector3d.field_72449_c) * 0.1);
                }
                this.func_213317_d(vector3d.func_216372_d((double)0.99f, (double)0.98f, (double)0.99f));
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                if (this.field_70123_F && !this.field_70170_p.field_72995_K && (f2 = (float)((d6 = d3 - (d10 = Math.sqrt(VesselEntity.func_213296_b((Vector3d)this.func_213322_ci())))) * 10.0 - 3.0)) > 0.0f) {
                    this.func_184185_a(this.func_184588_d((int)f2), 1.0f, 1.0f);
                    this.func_70097_a(DamageSource.field_188406_j, f2);
                }
                if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
                    this.func_70052_a(7, false);
                }
            } else {
                BlockPos blockpos = this.func_226270_aj_();
                float f3 = this.field_70170_p.func_180495_p(this.func_226270_aj_()).getSlipperiness((IWorldReader)this.field_70170_p, this.func_226270_aj_(), (Entity)this);
                float f4 = this.field_70122_E ? f3 * 0.91f : 0.91f;
                Vector3d vector3d5 = this.func_233633_a_(p_213352_1_, f3);
                double d2 = vector3d5.field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    d2 += (0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1) - vector3d5.field_72448_b) * 0.2;
                    this.field_70143_R = 0.0f;
                } else if (this.field_70170_p.field_72995_K && !this.field_70170_p.func_175667_e(blockpos)) {
                    d2 = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
                } else if (!this.func_189652_ae()) {
                    d2 -= d0;
                }
                this.func_213293_j(vector3d5.field_72450_a * (double)f4, d2 * (double)0.98f, vector3d5.field_72449_c * (double)f4);
            }
        }
        this.func_233629_a_((LivingEntity)this, false);
    }
}

