/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom;

import dev.murad.shipping.entity.custom.VesselEntity;
import dev.murad.shipping.entity.custom.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.EntitySpringAPI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class SpringEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public static final DataParameter<Integer> DOMINANT_ID = EntityDataManager.func_187226_a(SpringEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DOMINATED_ID = EntityDataManager.func_187226_a(SpringEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    @Nullable
    private CompoundNBT dominantNBT;
    @Nullable
    private CompoundNBT dominatedNBT;
    @Nullable
    private VesselEntity dominant;
    @Nullable
    private VesselEntity dominated;

    public VesselEntity getDominant() {
        return this.dominant;
    }

    public void setDominant(VesselEntity dominant) {
        if (this.dominated != null && dominant != null) {
            dominant.setDominated(this.dominated, this);
            this.dominated.setDominant(dominant, this);
        }
        this.dominant = dominant;
    }

    public void setDominated(VesselEntity dominated) {
        if (dominated != null && this.dominant != null) {
            this.dominant.setDominated(dominated, this);
            dominated.setDominant(this.dominant, this);
        }
        this.dominated = dominated;
    }

    public Entity getDominated() {
        return this.dominant;
    }

    public SpringEntity(EntityType<? extends Entity> type, World worldIn) {
        super(type, worldIn);
        this.func_189654_d(true);
        this.field_70145_X = true;
    }

    public SpringEntity(@Nonnull VesselEntity dominant, @Nonnull VesselEntity dominatedEntity) {
        super((EntityType)ModEntityTypes.SPRING.get(), dominant.func_130014_f_());
        this.setDominant(dominant);
        this.setDominated(dominatedEntity);
        this.func_70107_b((dominant.func_226277_ct_() + this.dominated.func_226277_ct_()) / 2.0, (dominant.func_226278_cu_() + this.dominated.func_226278_cu_()) / 2.0, (dominant.func_226281_cx_() + this.dominated.func_226281_cx_()) / 2.0);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DOMINANT_ID, (Object)-1);
        this.func_184212_Q().func_187214_a(DOMINATED_ID, (Object)-1);
    }

    public static Vector3d calculateAnchorPosition(VesselEntity entity, SpringSide side) {
        return EntitySpringAPI.calculateAnchorPosition((Entity)entity, side);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.field_70170_p.field_72995_K) {
            VesselEntity potential;
            if (DOMINANT_ID.equals(key) && (potential = (VesselEntity)this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(DOMINANT_ID)).intValue())) != null) {
                this.setDominant(potential);
            }
            if (DOMINATED_ID.equals(key) && (potential = (VesselEntity)this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(DOMINATED_ID)).intValue())) != null) {
                this.setDominated(potential);
            }
        }
    }

    public Direction func_174811_aO() {
        return this.dominated.func_174811_aO();
    }

    public void func_70030_z() {
        this.func_213293_j(0.0, 0.0, 0.0);
        super.func_70030_z();
        if (this.tryLoadAndCalculate()) {
            return;
        }
        this.syncClient();
    }

    private void syncClient() {
        if (this.dominant != null && this.dominated != null) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_187227_b(DOMINANT_ID, (Object)this.dominant.func_145782_y());
                this.field_70180_af.func_187227_b(DOMINATED_ID, (Object)this.dominated.func_145782_y());
            }
        } else {
            if (this.dominant == null) {
                this.func_184206_a(DOMINANT_ID);
            }
            if (this.dominated == null) {
                this.func_184206_a(DOMINATED_ID);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.dominant != null && !this.dominant.func_70089_S()) {
                this.func_184206_a(DOMINANT_ID);
            }
            if (this.dominated != null && !this.dominated.func_70089_S()) {
                this.func_184206_a(DOMINATED_ID);
            }
        }
    }

    private boolean tryLoadAndCalculate() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.dominant != null && this.dominated != null) {
                if (this.dominated.func_70032_d((Entity)this.dominant) > 20.0f) {
                    this.dominated.removeDominant();
                    this.func_174812_G();
                    return true;
                }
                if (!this.dominant.func_70089_S() || !this.dominated.func_70089_S()) {
                    this.func_174812_G();
                    return true;
                }
                this.func_70107_b((this.dominant.func_226277_ct_() + this.dominated.func_226277_ct_()) / 2.0, (this.dominant.func_226278_cu_() + this.dominated.func_226278_cu_()) / 2.0, (this.dominant.func_226281_cx_() + this.dominated.func_226281_cx_()) / 2.0);
                double distSq = this.dominant.func_70068_e((Entity)this.dominated);
                double maxDstSq = this.dominant.getTrain().getTug().map(tug -> tug.isDocked() ? 1.0 : 1.2).orElse(1.2);
                if (distSq > maxDstSq) {
                    Vector3d frontAnchor = SpringEntity.calculateAnchorPosition(this.dominant, SpringSide.DOMINATED);
                    Vector3d backAnchor = SpringEntity.calculateAnchorPosition(this.dominated, SpringSide.DOMINANT);
                    double dist = Math.sqrt(distSq);
                    double dx = (frontAnchor.field_72450_a - backAnchor.field_72450_a) / dist;
                    double dy = (frontAnchor.field_72448_b - backAnchor.field_72448_b) / dist;
                    double dz = (frontAnchor.field_72449_c - backAnchor.field_72449_c) / dist;
                    double alpha = 0.5;
                    float targetYaw = this.computeTargetYaw(Float.valueOf(this.dominated.field_70177_z), frontAnchor, backAnchor);
                    this.field_70177_z = this.dominated.field_70177_z = (float)((0.5 * (double)this.dominated.field_70177_z + (double)targetYaw * 0.5) % 360.0);
                    double k = this.dominant instanceof AbstractTugEntity ? 0.2 : 0.13;
                    double l0 = maxDstSq;
                    this.dominated.func_213293_j(k * (dist - l0) * dx, k * (dist - l0) * dy, k * (dist - l0) * dz);
                    this.dominated.func_145775_I();
                }
            } else {
                if (this.dominantNBT != null && this.dominatedNBT != null) {
                    this.tryToLoadFromNBT(this.dominantNBT).ifPresent(e -> {
                        this.setDominant((VesselEntity)e);
                        this.field_70180_af.func_187227_b(DOMINANT_ID, (Object)e.func_145782_y());
                    });
                    this.tryToLoadFromNBT(this.dominatedNBT).ifPresent(e -> {
                        this.setDominated((VesselEntity)e);
                        this.field_70180_af.func_187227_b(DOMINATED_ID, (Object)e.func_145782_y());
                    });
                }
                this.updateClient();
            }
        }
        return false;
    }

    private void updateClient() {
        if (this.field_70170_p.field_72995_K) {
            Entity potential_dominated;
            Entity potential;
            if (this.dominant == null && (potential = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(DOMINANT_ID)).intValue())) != null) {
                this.setDominant((VesselEntity)potential);
            }
            if (this.dominated == null && (potential_dominated = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(DOMINATED_ID)).intValue())) != null) {
                this.setDominated((VesselEntity)potential_dominated);
            }
        }
    }

    private float computeTargetYaw(Float currentYaw, Vector3d anchorPos, Vector3d otherAnchorPos) {
        float idealYaw = (float)(Math.atan2(otherAnchorPos.field_72450_a - anchorPos.field_72450_a, -(otherAnchorPos.field_72449_c - anchorPos.field_72449_c)) * 57.29577951308232);
        float closestDistance = Float.POSITIVE_INFINITY;
        float closest = idealYaw;
        for (int sign : Arrays.asList(-1, 0, 1)) {
            float potentialYaw = idealYaw + (float)sign * 360.0f;
            float distance = Math.abs(potentialYaw - currentYaw.floatValue());
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closest = potentialYaw;
        }
        return closest;
    }

    private Optional<VesselEntity> tryToLoadFromNBT(CompoundNBT compound) {
        try {
            BlockPos.Mutable pos = new BlockPos.Mutable();
            pos.func_181079_c(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z"));
            String uuid = compound.func_74779_i("UUID");
            AxisAlignedBB searchBox = new AxisAlignedBB((double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() - 2), (double)(pos.func_177952_p() - 2), (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 2));
            List entities = this.field_70170_p.func_175674_a((Entity)this, searchBox, e -> e.func_189512_bd().equals(uuid));
            return entities.stream().findFirst().map(e -> (VesselEntity)e);
        }
        catch (Exception e2) {
            return Optional.empty();
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.dominantNBT = compound.func_74775_l(SpringSide.DOMINANT.name());
        this.dominatedNBT = compound.func_74775_l(SpringSide.DOMINATED.name());
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.dominant != null && this.dominated != null) {
            this.writeNBT(SpringSide.DOMINANT, (Entity)this.dominant, compound);
            this.writeNBT(SpringSide.DOMINATED, (Entity)this.dominated, compound);
        } else {
            if (this.dominantNBT != null) {
                compound.func_218657_a(SpringSide.DOMINANT.name(), (INBT)this.dominantNBT);
            }
            if (this.dominatedNBT != null) {
                compound.func_218657_a(SpringSide.DOMINATED.name(), (INBT)this.dominatedNBT);
            }
        }
    }

    private void writeNBT(SpringSide side, Entity entity, CompoundNBT globalCompound) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("X", (int)Math.floor(entity.func_226277_ct_()));
        compound.func_74768_a("Y", (int)Math.floor(entity.func_226278_cu_()));
        compound.func_74768_a("Z", (int)Math.floor(entity.func_226281_cx_()));
        compound.func_74778_a("UUID", entity.func_110124_au().toString());
        globalCompound.func_218657_a(side.name(), (INBT)compound);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        if (this.dominated != null && this.dominant != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.dominant.func_145782_y());
            buffer.writeInt(this.dominated.func_145782_y());
            CompoundNBT dominatedNBT = new CompoundNBT();
            this.writeNBT(SpringSide.DOMINATED, (Entity)this.dominated, dominatedNBT);
            CompoundNBT dominantNBT = new CompoundNBT();
            this.writeNBT(SpringSide.DOMINANT, (Entity)this.dominant, dominantNBT);
            buffer.func_150786_a(dominantNBT);
            buffer.func_150786_a(dominatedNBT);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public void readSpawnData(PacketBuffer additionalData) {
        if (additionalData.readBoolean()) {
            int frontID = additionalData.readInt();
            int backID = additionalData.readInt();
            this.setDominant((VesselEntity)this.field_70170_p.func_73045_a(frontID));
            this.setDominated((VesselEntity)this.field_70170_p.func_73045_a(backID));
            this.dominantNBT = additionalData.func_150793_b();
            this.dominatedNBT = additionalData.func_150793_b();
        }
    }

    public static void createSpring(VesselEntity dominantEntity, VesselEntity dominatedEntity) {
        SpringEntity link = new SpringEntity(dominantEntity, dominatedEntity);
        World world = dominantEntity.func_130014_f_();
        world.func_217376_c((Entity)link);
    }

    public AxisAlignedBB func_184177_bl() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        return super.func_184199_a(player, vec, hand);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_174812_G() {
        super.func_70106_y();
        if (this.dominant != null) {
            this.dominant.removeDominated();
        }
        if (!this.field_70170_p.field_72995_K) {
            InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_(), (ItemStack)new ItemStack((IItemProvider)ModItems.SPRING.get()));
        }
    }

    public static enum SpringSide {
        DOMINANT,
        DOMINATED;

    }
}

