/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.entity.custom.SpringEntity;
import dev.murad.shipping.util.Train;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;

public interface ISpringableEntity {
    public Optional<Pair<ISpringableEntity, SpringEntity>> getDominated();

    public Optional<Pair<ISpringableEntity, SpringEntity>> getDominant();

    public void setDominated(ISpringableEntity var1, SpringEntity var2);

    public void setDominant(ISpringableEntity var1, SpringEntity var2);

    public void removeDominated();

    public void removeDominant();

    public Train getTrain();

    public void setTrain(Train var1);

    public boolean hasWaterOnSides();

    default public void handleSpringableKill() {
        this.getDominated().map(Pair::getFirst).ifPresent(ISpringableEntity::removeDominant);
        this.getDominant().map(Pair::getFirst).ifPresent(ISpringableEntity::removeDominated);
    }

    default public boolean checkNoLoopsDominated() {
        return this.checkNoLoopsHelper(this, entity -> entity.getDominated().map(Pair::getFirst), new HashSet<ISpringableEntity>());
    }

    default public boolean checkNoLoopsDominant() {
        return this.checkNoLoopsHelper(this, entity -> entity.getDominant().map(Pair::getFirst), new HashSet<ISpringableEntity>());
    }

    default public boolean checkNoLoopsHelper(ISpringableEntity entity, Function<ISpringableEntity, Optional<ISpringableEntity>> next, Set<ISpringableEntity> set) {
        if (set.contains(entity)) {
            return true;
        }
        set.add(entity);
        Optional<ISpringableEntity> nextEntity = next.apply(entity);
        return nextEntity.map(e -> this.checkNoLoopsHelper((ISpringableEntity)e, next, set)).orElse(false);
    }

    default public <U> Stream<U> applyWithAll(Function<ISpringableEntity, U> function) {
        return this.getTrain().getHead().applyWithDominated(function);
    }

    default public <U> Stream<U> applyWithDominant(Function<ISpringableEntity, U> function) {
        Stream ofThis = Stream.of(function.apply(this));
        return this.checkNoLoopsDominant() ? ofThis : this.getDominant().map(dom -> Stream.concat(ofThis, ((ISpringableEntity)dom.getFirst()).applyWithDominant(function))).orElse(ofThis);
    }

    default public <U> Stream<U> applyWithDominated(Function<ISpringableEntity, U> function) {
        Stream ofThis = Stream.of(function.apply(this));
        return this.checkNoLoopsDominated() ? ofThis : this.getDominated().map(dom -> Stream.concat(ofThis, ((ISpringableEntity)dom.getFirst()).applyWithDominated(function))).orElse(ofThis);
    }

    default public void tickSpringAliveCheck() {
        this.getDominant().map(Pair::getSecond).map(Entity::func_70089_S).ifPresent(alive -> {
            if (!alive.booleanValue()) {
                this.removeDominant();
            }
        });
        this.getDominated().map(Pair::getSecond).map(Entity::func_70089_S).ifPresent(alive -> {
            if (!alive.booleanValue()) {
                this.removeDominated();
            }
        });
    }
}

