/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.accessor;

import dev.murad.shipping.entity.accessor.DataAccessor;
import dev.murad.shipping.entity.accessor.SupplierIntArray;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import net.minecraft.util.IIntArray;

public class EnergyTugDataAccessor
extends DataAccessor {
    private static final int SHORT_MASK = 65535;

    public EnergyTugDataAccessor(IIntArray data) {
        super(data);
    }

    public int getEnergy() {
        int lo = this.data.func_221476_a(1) & 0xFFFF;
        int hi = this.data.func_221476_a(2) & 0xFFFF;
        return lo | hi << 16;
    }

    public int getCapacity() {
        int lo = this.data.func_221476_a(3) & 0xFFFF;
        int hi = this.data.func_221476_a(4) & 0xFFFF;
        return lo | hi << 16;
    }

    public boolean isLit() {
        return this.data.func_221476_a(5) == 1;
    }

    public static class Builder {
        SupplierIntArray arr = new SupplierIntArray(6);

        public Builder(int uuid) {
            this.arr.func_221477_a(0, uuid);
        }

        public Builder withEnergy(IntSupplier energy) {
            this.arr.setSupplier(1, () -> energy.getAsInt() & 0xFFFF);
            this.arr.setSupplier(2, () -> energy.getAsInt() >> 16 & 0xFFFF);
            return this;
        }

        public Builder withCapacity(IntSupplier capacity) {
            this.arr.setSupplier(3, () -> capacity.getAsInt() & 0xFFFF);
            this.arr.setSupplier(4, () -> capacity.getAsInt() >> 16 & 0xFFFF);
            return this;
        }

        public Builder withLit(BooleanSupplier lit) {
            this.arr.setSupplier(5, () -> lit.getAsBoolean() ? 1 : -1);
            return this;
        }

        public EnergyTugDataAccessor build() {
            return new EnergyTugDataAccessor(this.arr);
        }
    }
}

