/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.fluid;

import dev.murad.shipping.block.IVesselLoader;
import dev.murad.shipping.block.fluid.FluidHopperBlock;
import dev.murad.shipping.entity.custom.VesselEntity;
import dev.murad.shipping.setup.ModTileEntitiesTypes;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidHopperTileEntity
extends TileEntity
implements ITickableTileEntity,
IVesselLoader {
    public static final int CAPACITY = 10000;
    private int cooldownTime = 0;
    protected FluidTank tank = new FluidTank(10000){

        protected void onContentsChanged() {
            BlockState state = FluidHopperTileEntity.this.field_145850_b.func_180495_p(FluidHopperTileEntity.this.field_174879_c);
            FluidHopperTileEntity.this.field_145850_b.func_184138_a(FluidHopperTileEntity.this.field_174879_c, state, state, 3);
            FluidHopperTileEntity.this.func_70296_d();
        }
    };
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public FluidHopperTileEntity() {
        super((TileEntityType)ModTileEntitiesTypes.FLUID_HOPPER.get());
    }

    private TranslationTextComponent getFluidDisplay() {
        Fluid fluid = this.tank.getFluid().getFluid();
        return fluid.equals(Fluids.field_204541_a) ? new TranslationTextComponent("block.littlelogistics.fluid_hopper.capacity_empty", new Object[]{this.tank.getCapacity()}) : new TranslationTextComponent("block.littlelogistics.fluid_hopper.capacity", new Object[]{this.tank.getFluid().getDisplayName().getString(), this.tank.getFluidAmount(), this.tank.getCapacity()});
    }

    public boolean use(PlayerEntity player, Hand hand) {
        boolean result = FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)this.tank);
        player.func_146105_b((ITextComponent)this.getFluidDisplay(), false);
        return result;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.getTank().readFromNBT(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        this.getTank().writeToNBT(tag);
        return tag;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(null, packet.func_148857_g());
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.cooldownTime;
            if (this.cooldownTime <= 0) {
                this.cooldownTime = Boolean.logicalOr(this.tryExportFluid(), this.tryImportFluid()) ? 0 : 10;
            }
        }
    }

    private Optional<IFluidHandler> getExternalFluidHandler(BlockPos pos) {
        return Optional.ofNullable(this.field_145850_b.func_175625_s(pos)).map(tile -> tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)).flatMap(LazyOptional::resolve).map(Optional::of).orElseGet(() -> IVesselLoader.getEntityCapability(pos, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.field_145850_b));
    }

    private boolean tryImportFluid() {
        return this.getExternalFluidHandler(this.func_174877_v().func_177984_a()).map(iFluidHandler -> !FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)iFluidHandler, (int)50, (boolean)true).isEmpty()).orElse(false);
    }

    private boolean tryExportFluid() {
        return this.getExternalFluidHandler(this.func_174877_v().func_177972_a((Direction)this.func_195044_w().func_177229_b((Property)FluidHopperBlock.FACING))).map(iFluidHandler -> !FluidUtil.tryFluidTransfer((IFluidHandler)iFluidHandler, (IFluidHandler)this.tank, (int)50, (boolean)true).isEmpty()).orElse(false);
    }

    @Override
    public boolean holdVessel(VesselEntity vessel, IVesselLoader.Mode mode) {
        return vessel.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(iFluidHandler -> {
            switch (mode) {
                case IMPORT: {
                    return !FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)iFluidHandler, (int)1, (boolean)false).isEmpty();
                }
                case EXPORT: {
                    return !FluidUtil.tryFluidTransfer((IFluidHandler)iFluidHandler, (IFluidHandler)this.tank, (int)1, (boolean)false).isEmpty();
                }
            }
            return false;
        }).orElse(false);
    }
}

