/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.sounds.CCubesSounds;
import chanceCubes.tileentities.TileGiantCube;
import chanceCubes.util.RewardsUtil;
import net.minecraft.block.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GiantCubeUtil {
    public static boolean checkMultiBlockForm(BlockPos pos, World world, boolean build) {
        if (((Boolean)CCubesSettings.disableGiantCC.get()).booleanValue()) {
            return false;
        }
        BlockPos bottomLeft = GiantCubeUtil.findBottomCorner(pos, world);
        int cx = bottomLeft.func_177958_n();
        int cy = bottomLeft.func_177956_o();
        int cz = bottomLeft.func_177952_p();
        int i = 0;
        for (int x = cx; x < cx + 3; ++x) {
            for (int y = cy; y < cy + 3; ++y) {
                for (int z = cz; z < cz + 3; ++z) {
                    if (!world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().equals((Object)CCubesBlocks.CHANCE_CUBE)) continue;
                    ++i;
                }
            }
        }
        if (build) {
            if (i > 26) {
                GiantCubeUtil.setupStructure(new BlockPos(cx, cy, cz), world, true);
                return true;
            }
            return false;
        }
        return i > 26;
    }

    public static void setupStructure(BlockPos pos, World world, boolean areCoordsCorrect) {
        if (((Boolean)CCubesSettings.disableGiantCC.get()).booleanValue()) {
            return;
        }
        int cx = pos.func_177958_n();
        int cy = pos.func_177956_o();
        int cz = pos.func_177952_p();
        if (!areCoordsCorrect) {
            BlockPos bottomLeft = GiantCubeUtil.findBottomCorner(pos, world);
            cx = bottomLeft.func_177958_n();
            cy = bottomLeft.func_177956_o();
            cz = bottomLeft.func_177952_p();
        }
        int i = 0;
        for (int x = cx; x < cx + 3; ++x) {
            for (int z = cz; z < cz + 3; ++z) {
                for (int y = cy; y < cy + 3; ++y) {
                    boolean master;
                    RewardsUtil.placeBlock(CCubesBlocks.GIANT_CUBE.func_176223_P(), world, new BlockPos(x, y, z), ++i == 27 ? 3 : 2, world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().equals((Object)CCubesBlocks.CHANCE_CUBE));
                    TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
                    boolean bl = master = x == cx + 1 && y == cy + 1 && z == cz + 1;
                    if (!(tile instanceof TileGiantCube)) continue;
                    ((TileGiantCube)tile).setMasterCoords(cx + 1, cy + 1, cz + 1);
                    ((TileGiantCube)tile).setHasMaster(true);
                    ((TileGiantCube)tile).setIsMaster(master);
                }
            }
        }
        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), CCubesSounds.GIANT_CUBE_SPAWN, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public static BlockPos findBottomCorner(BlockPos pos, World world) {
        int cx = pos.func_177958_n();
        int cy = pos.func_177956_o();
        int cz = pos.func_177952_p();
        while (world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c().equals((Object)CCubesBlocks.CHANCE_CUBE)) {
            pos = pos.func_177982_a(0, -1, 0);
            --cy;
        }
        while (world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c().equals((Object)CCubesBlocks.CHANCE_CUBE)) {
            pos = pos.func_177982_a(-1, 0, 0);
            --cx;
        }
        while (world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_177230_c().equals((Object)CCubesBlocks.CHANCE_CUBE)) {
            pos = pos.func_177982_a(0, 0, -1);
            --cz;
        }
        return new BlockPos(cx, cy, cz);
    }

    public static void resetStructure(BlockPos pos, World world) {
        for (int x = pos.func_177958_n() - 1; x < pos.func_177958_n() + 2; ++x) {
            for (int y = pos.func_177956_o() - 1; y < pos.func_177956_o() + 2; ++y) {
                for (int z = pos.func_177952_p() - 1; z < pos.func_177952_p() + 2; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    TileEntity tile = world.func_175625_s(blockPos);
                    if (!(tile instanceof TileGiantCube)) continue;
                    ((TileGiantCube)tile).reset();
                    world.func_175713_t(blockPos);
                    world.func_175656_a(blockPos, CCubesBlocks.CHANCE_CUBE.func_176223_P());
                }
            }
        }
    }

    public static void removeStructure(BlockPos pos, World world) {
        for (int x = pos.func_177958_n() - 1; x < pos.func_177958_n() + 2; ++x) {
            for (int y = pos.func_177956_o() - 1; y < pos.func_177956_o() + 2; ++y) {
                for (int z = pos.func_177952_p() - 1; z < pos.func_177952_p() + 2; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    TileEntity tile = world.func_175625_s(blockPos);
                    if (!(tile instanceof TileGiantCube)) continue;
                    ((TileGiantCube)tile).reset();
                    world.func_175713_t(blockPos);
                    world.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }
}

