/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardsUtil;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BeaconArenaReward
extends BaseCustomReward {
    private BlockState[] whitelist = new BlockState[]{Blocks.field_150343_Z.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150348_b.func_176223_P(), Blocks.field_150440_ba.func_176223_P(), Blocks.field_150342_X.func_176223_P(), Blocks.field_150435_aG.func_176223_P(), RewardsUtil.getRandomWool(), Blocks.field_196584_bK.func_176223_P(), Blocks.field_196553_aF.func_176223_P(), Blocks.field_150426_aN.func_176223_P(), Blocks.field_150424_aL.func_176223_P()};

    public BeaconArenaReward() {
        super("chancecubes:beacon_arena", 0);
    }

    @Override
    public void trigger(ServerWorld world, BlockPos pos, PlayerEntity player, JsonObject settings) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        this.spawnWall(blocks);
        this.spawnSmallBeacon(blocks, new BlockPos(17, 0, 17), Blocks.field_150340_R);
        this.spawnSmallBeacon(blocks, new BlockPos(-17, 0, 17), Blocks.field_150484_ah);
        this.spawnSmallBeacon(blocks, new BlockPos(-17, 0, -17), Blocks.field_150475_bE);
        this.spawnSmallBeacon(blocks, new BlockPos(17, 0, -17), Blocks.field_150339_S);
        this.spawnBigBeacon(blocks);
        this.editFloor(blocks);
        for (OffsetBlock b : blocks) {
            b.spawnInWorld((World)world, pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
        }
    }

    public void spawnSmallBeacon(List<OffsetBlock> blocks, BlockPos at, Block b) {
        int delay = 0;
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                blocks.add(new OffsetBlock(at.func_177958_n() + x, at.func_177956_o(), at.func_177952_p() + z, b, false, delay));
                ++delay;
            }
        }
        blocks.add(new OffsetBlock(at.func_177958_n(), at.func_177956_o() + 1, at.func_177952_p(), Blocks.field_150461_bJ, false, delay).setCausesBlockUpdate(true));
    }

    public void spawnBigBeacon(List<OffsetBlock> blocks) {
        int delay = 0;
        for (int y = 0; y < 2; ++y) {
            for (int x = -2; x < 3; ++x) {
                for (int z = -2; z < 3; ++z) {
                    if (y == 1 && (x <= -2 || x >= 2 || z <= -2 || z >= 2)) continue;
                    blocks.add(new OffsetBlock(x, y, z, Blocks.field_150339_S, false, delay));
                    ++delay;
                }
            }
        }
        blocks.add(new OffsetBlock(0, 2, 0, Blocks.field_150461_bJ, false, delay).setCausesBlockUpdate(true));
    }

    public void spawnWall(List<OffsetBlock> blocks) {
        ArrayList<BlockPos> usedPositions = new ArrayList<BlockPos>();
        for (int degree = 0; degree < 360; ++degree) {
            int z;
            double arcVal = Math.toRadians(degree);
            int x = (int)(28.0 * Math.cos(arcVal));
            BlockPos temp = new BlockPos(x, 0, z = (int)(28.0 * Math.sin(arcVal)));
            if (usedPositions.contains(temp)) continue;
            usedPositions.add(temp);
        }
        int delay = 0;
        for (BlockPos pos : usedPositions) {
            blocks.add(new OffsetBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Blocks.field_150359_w, false, delay));
            blocks.add(new OffsetBlock(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p(), Blocks.field_150359_w, false, delay + 1));
            blocks.add(new OffsetBlock(pos.func_177958_n(), pos.func_177956_o() + 2, pos.func_177952_p(), Blocks.field_150359_w, false, delay + 2));
            ++delay;
        }
    }

    public void editFloor(List<OffsetBlock> blocks) {
        int delay = 0;
        ArrayList<BlockPos> usedPositions = new ArrayList<BlockPos>();
        for (int radius = 0; radius < 28; ++radius) {
            for (int degree = 0; degree < 360; ++degree) {
                int z;
                double arcVal = Math.toRadians(degree);
                int x = (int)((double)radius * Math.cos(arcVal));
                BlockPos temp = new BlockPos(x, 0, z = (int)((double)radius * Math.sin(arcVal)));
                if (usedPositions.contains(temp)) continue;
                usedPositions.add(temp);
            }
        }
        for (BlockPos pos : usedPositions) {
            BlockState state = this.whitelist[RewardsUtil.rand.nextInt(this.whitelist.length)];
            blocks.add(new OffsetBlock(pos.func_177958_n(), -1, pos.func_177952_p(), state, false, delay / 8));
            ++delay;
        }
    }
}

