/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LootBoxReward
extends BaseCustomReward {
    private static final String COMMON_LORE = "{\"text\":\"Common\",\"color\":\"white\",\"bold\":true}";
    private static final String UNCOMMON_LORE = "{\"text\":\"Uncommon\",\"color\":\"green\",\"bold\":true}";
    private static final String RARE_LORE = "{\"text\":\"Rare\",\"color\":\"blue\",\"bold\":true}";
    private static final String LEGENDARY_LORE = "{\"text\":\"Legendary\",\"color\":\"red\",\"bold\":true}";
    private static final String EPIC_LORE = "{\"text\":\"Epic\",\"color\":\"dark_purple\",\"bold\":true}";
    private static final String SHINY_LORE = "{\"text\":\"SHINY!\",\"color\":\"aqua\",\"italic\":true}";
    public static final List<ItemStack> COMMON = new ArrayList<ItemStack>();
    public static final List<ItemStack> UNCOMMON = new ArrayList<ItemStack>();
    public static final List<ItemStack> RARE = new ArrayList<ItemStack>();
    public static final List<ItemStack> LEGENDARY = new ArrayList<ItemStack>();
    public static final List<ItemStack> EPIC = new ArrayList<ItemStack>();

    public LootBoxReward() {
        super("chancecubes:loot_box", 35);
    }

    @Override
    public void trigger(final ServerWorld world, final BlockPos pos, PlayerEntity player, JsonObject settings) {
        world.func_175656_a(pos, Blocks.field_150357_h.func_176223_P());
        Scheduler.scheduleTask(new Task("CC_Loot_Box_Animation", -1, 1){
            int tick;
            double y;
            double inc;
            {
                super(name, delay, updateTick);
                this.tick = 0;
                this.y = 0.0;
                this.inc = 0.023;
            }

            @Override
            public void callback() {
                RewardsUtil.sendMessageToNearPlayers((World)world, pos, 25, "Open the Chance Cubes Loot Box to get some collectibles!");
                world.func_175656_a(pos, Blocks.field_150486_ae.func_176223_P());
                TileEntity te = world.func_175625_s(pos);
                if (!(te instanceof ChestTileEntity)) {
                    return;
                }
                ChestTileEntity chest = (ChestTileEntity)te;
                for (int i = 0; i < 10; ++i) {
                    chest.func_70299_a(i, LootBoxReward.this.getCollectible());
                }
            }

            @Override
            public void update() {
                if (this.tick < 250) {
                    this.y += this.inc;
                    if (this.y > 1.0 || this.y < 0.0) {
                        this.inc *= -1.0;
                    }
                    double xOff = Math.cos((float)this.tick / 3.0f);
                    double yOff = Math.sin((float)this.tick / 3.0f);
                    world.func_195598_a((IParticleData)ParticleTypes.field_197617_j, (double)pos.func_177958_n() + xOff + 0.5, (double)pos.func_177956_o() + this.y, (double)pos.func_177952_p() + yOff + 0.5, 3, 0.0, 0.0, 0.0, 1.0);
                    world.func_195598_a((IParticleData)ParticleTypes.field_197617_j, (double)pos.func_177958_n() - xOff + 0.5, (double)pos.func_177956_o() + this.y, (double)pos.func_177952_p() - yOff + 0.5, 3, 0.0, 0.0, 0.0, 1.0);
                }
                if (this.tick == 250) {
                    for (int i = 0; i < 100; ++i) {
                        world.func_195598_a((IParticleData)ParticleTypes.field_197616_i, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.95, (double)pos.func_177952_p() + 0.5, 3, 0.0, 0.0, 0.0, 1.0);
                    }
                }
                if (this.tick > 250) {
                    this.callback();
                    Scheduler.removeTask(this);
                }
                ++this.tick;
            }
        });
    }

    public ItemStack getCollectible() {
        int rarity = RewardsUtil.rand.nextInt(100);
        ItemStack stack = rarity < 50 ? COMMON.get(RewardsUtil.rand.nextInt(COMMON.size())).func_77946_l() : (rarity < 80 ? UNCOMMON.get(RewardsUtil.rand.nextInt(UNCOMMON.size())).func_77946_l() : (rarity < 93 ? RARE.get(RewardsUtil.rand.nextInt(RARE.size())).func_77946_l() : (rarity < 99 ? LEGENDARY.get(RewardsUtil.rand.nextInt(LEGENDARY.size())).func_77946_l() : EPIC.get(RewardsUtil.rand.nextInt(EPIC.size())).func_77946_l())));
        if (RewardsUtil.rand.nextInt(100) == 42) {
            ListNBT loreList;
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
                stack.func_77982_d(nbt);
            }
            ListNBT enchantList = new ListNBT();
            nbt.func_218657_a("Enchantments", (INBT)enchantList);
            enchantList.add((Object)new CompoundNBT());
            CompoundNBT display = (CompoundNBT)nbt.func_74781_a("display");
            if (display == null) {
                display = new CompoundNBT();
                nbt.func_218657_a("display", (INBT)display);
            }
            if ((loreList = (ListNBT)display.func_74781_a("Lore")) == null) {
                loreList = new ListNBT();
                display.func_218657_a("Lore", (INBT)loreList);
            }
            loreList.add((Object)StringNBT.func_229705_a_((String)SHINY_LORE));
        }
        return stack;
    }

    private static ItemStack addItem(List<ItemStack> list, Item item, String lore) {
        ItemStack stack = new ItemStack((IItemProvider)item, 1);
        stack.func_77982_d(LootBoxReward.getLoreNBT(lore));
        list.add(stack);
        return stack;
    }

    public static CompoundNBT getLoreNBT(String ... lore) {
        CompoundNBT nbt = new CompoundNBT();
        CompoundNBT display = new CompoundNBT();
        nbt.func_218657_a("display", (INBT)display);
        ListNBT loreList = new ListNBT();
        display.func_218657_a("Lore", (INBT)loreList);
        for (String l : lore) {
            loreList.add((Object)StringNBT.func_229705_a_((String)l));
        }
        return nbt;
    }

    static {
        LootBoxReward.addItem(COMMON, Items.field_151027_R, COMMON_LORE);
        LootBoxReward.addItem(COMMON, Items.field_151044_h, COMMON_LORE);
        LootBoxReward.addItem(COMMON, Items.field_151055_y, COMMON_LORE);
        LootBoxReward.addItem(COMMON, Items.field_151118_aC, COMMON_LORE);
        LootBoxReward.addItem(COMMON, Items.field_151008_G, COMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.field_151040_l, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.field_151034_e, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.field_151033_d, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.field_151032_g, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.field_151007_F, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.field_151015_O, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.field_151103_aS, UNCOMMON_LORE);
        LootBoxReward.addItem(RARE, Items.field_151045_i, RARE_LORE);
        LootBoxReward.addItem(RARE, Items.field_151020_U, RARE_LORE);
        LootBoxReward.addItem(RARE, Items.field_151029_X, RARE_LORE);
        LootBoxReward.addItem(RARE, Items.field_151113_aN, RARE_LORE);
        LootBoxReward.addItem(RARE, Items.field_191525_da, RARE_LORE);
        LootBoxReward.addItem(LEGENDARY, Items.field_203179_ao, LEGENDARY_LORE);
        LootBoxReward.addItem(LEGENDARY, Items.field_234765_lu_, LEGENDARY_LORE);
        LootBoxReward.addItem(LEGENDARY, Items.field_151163_ad, LEGENDARY_LORE);
        LootBoxReward.addItem(LEGENDARY, Items.field_151073_bk, LEGENDARY_LORE);
        LootBoxReward.addItem(EPIC, Items.field_185166_h, EPIC_LORE);
        LootBoxReward.addItem(EPIC, Items.field_151119_aD, EPIC_LORE);
    }
}

