/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class JarGuessReward
extends BaseCustomReward {
    private Map<PlayerEntity, PlayerGuessing> inGuess = new HashMap<PlayerEntity, PlayerGuessing>();

    public JarGuessReward() {
        super("chancecubes:jar_guess", 25);
    }

    @Override
    public void trigger(ServerWorld world, BlockPos pos, final PlayerEntity player, JsonObject settings) {
        if (this.inGuess.containsKey(player)) {
            return;
        }
        if (!RewardsUtil.isPlayerOnline(player)) {
            return;
        }
        int amount = world.field_73012_v.nextInt(50) + 60;
        RewardBlockCache blockCache = new RewardBlockCache((World)world, pos, player.func_233580_cy_());
        for (int x = -3; x < 4; ++x) {
            for (int z = -3; z < 4; ++z) {
                for (int y = 0; y < 7; ++y) {
                    if (x == -3 || x == 3 || z == -3 || z == 3 || y == 0 || y == 6) {
                        blockCache.cacheBlock(new BlockPos(x, y, z), Blocks.field_150359_w.func_176223_P());
                        continue;
                    }
                    blockCache.cacheBlock(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        PlayerGuessing guessing = new PlayerGuessing(amount, blockCache);
        int batsSpawned = 0;
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 2; y < 5; ++y) {
                    for (int i = 0; i < 4; ++i) {
                        if (batsSpawned >= amount) continue;
                        BlockPos pos2 = pos.func_177963_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                        BatEntity bat = (BatEntity)EntityType.field_200791_e.func_200721_a((World)world);
                        bat.func_70012_b((double)pos2.func_177958_n(), (double)pos2.func_177956_o(), (double)pos2.func_177952_p(), 0.0f, 0.0f);
                        world.func_217376_c((Entity)bat);
                        guessing.bats.add(bat);
                        ++batsSpawned;
                    }
                }
            }
        }
        RewardsUtil.sendMessageToPlayer(player, "How many bats are in UrjnaswX Jar?");
        RewardsUtil.sendMessageToPlayer(player, "You have 30 seconds to answer!");
        RewardsUtil.sendMessageToPlayer(player, "Guess right and you get 20 Emeralds!");
        RewardsUtil.sendMessageToPlayer(player, "But you lose 1 emerald per bat you are off!");
        this.inGuess.put(player, guessing);
        Scheduler.scheduleTask(new Task("Jar Guess", 600, 20){

            @Override
            public void callback() {
                JarGuessReward.this.timeUp(player, -1);
            }

            @Override
            public void update() {
                if (!JarGuessReward.this.inGuess.containsKey(player)) {
                    Scheduler.removeTask(this);
                }
                if (this.delayLeft % 20 == 0) {
                    this.showTimeLeft(player, STitlePacket.Type.ACTIONBAR);
                }
            }
        });
    }

    private void timeUp(PlayerEntity player, int guessed) {
        if (!this.inGuess.containsKey(player)) {
            return;
        }
        int answer = this.inGuess.get((Object)player).answer;
        if (guessed != -1) {
            RewardsUtil.sendMessageToPlayer(player, "The Correct answer was " + answer);
            RewardsUtil.sendMessageToPlayer(player, "You were off by " + Math.abs(answer - guessed));
            int winAmount = Math.max(0, 20 - Math.abs(answer - guessed));
            RewardsUtil.sendMessageToPlayer(player, "You won " + winAmount + " Emeralds!");
            player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151166_bC, winAmount));
        } else {
            RewardsUtil.sendMessageToPlayer(player, "Times up! The answer was " + answer);
        }
        for (BatEntity batEntity : this.inGuess.get((Object)player).bats) {
            batEntity.func_70106_y();
        }
        this.inGuess.get((Object)player).blockCache.restoreBlocks((Entity)player);
        this.inGuess.remove(player);
    }

    @SubscribeEvent
    public void onMessage(ServerChatEvent event) {
        ServerPlayerEntity player = event.getPlayer();
        if (this.inGuess.containsKey(player)) {
            String answer = event.getMessage();
            if (answer.matches("[0-9]+")) {
                this.timeUp((PlayerEntity)player, Integer.parseInt(answer));
                event.setCanceled(true);
            } else {
                RewardsUtil.sendMessageToPlayer((PlayerEntity)player, answer + " is not a accepted number!");
            }
        }
    }

    private static class PlayerGuessing {
        public int answer;
        public RewardBlockCache blockCache;
        public List<BatEntity> bats = new ArrayList<BatEntity>();

        public PlayerGuessing(int answer, RewardBlockCache blockCache) {
            this.answer = answer;
            this.blockCache = blockCache;
        }
    }
}

