/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.CCubesCore;
import chanceCubes.rewards.defaultRewards.BossBaseReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.Level;

public class BossWitchReward
extends BossBaseReward {
    private List<String> entities = Arrays.asList("creeper", "skeleton", "blaze", "enderman", "endermite", "zombie_pigman", "silverfish", "slime", "spider", "zombie");

    public BossWitchReward() {
        super("evil_witch");
    }

    @Override
    public LivingEntity initBoss(final ServerWorld world, BlockPos pos, final PlayerEntity player, JsonObject settings, final BossBaseReward.BattleWrapper battleWrapper) {
        final WitchEntity witch = (WitchEntity)EntityType.field_200759_ay.func_200721_a((World)world);
        witch.func_200203_b((ITextComponent)new StringTextComponent("Evil Witch"));
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151024_Q);
        stack.func_77966_a(Enchantments.field_185297_d, 5);
        witch.func_184201_a(EquipmentSlotType.HEAD, stack);
        witch.func_184642_a(EquipmentSlotType.HEAD, 0.0f);
        stack = new ItemStack((IItemProvider)Items.field_151027_R);
        stack.func_77966_a(Enchantments.field_185297_d, 5);
        witch.func_184201_a(EquipmentSlotType.CHEST, stack);
        witch.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
        stack = new ItemStack((IItemProvider)Items.field_151026_S);
        stack.func_77966_a(Enchantments.field_185297_d, 5);
        witch.func_184201_a(EquipmentSlotType.LEGS, stack);
        witch.func_184642_a(EquipmentSlotType.LEGS, 0.0f);
        stack = new ItemStack((IItemProvider)Items.field_151021_T);
        stack.func_77966_a(Enchantments.field_185297_d, 5);
        witch.func_184201_a(EquipmentSlotType.FEET, stack);
        witch.func_184642_a(EquipmentSlotType.FEET, 0.0f);
        this.spawnMinoins(pos, world, battleWrapper);
        Scheduler.scheduleTask(new Task("witch_abilities", -1, 20){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                if (!witch.func_70089_S()) {
                    Scheduler.removeTask(this);
                    return;
                }
                if (RewardsUtil.rand.nextInt(15) == 4) {
                    BossWitchReward.this.spawnMinoins(witch.func_233580_cy_(), world, battleWrapper);
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    BossWitchReward.this.lightningStrike(player.func_233580_cy_(), world);
                }
                if (RewardsUtil.rand.nextInt(5) == 4) {
                    BossWitchReward.this.throwPotion(witch, player.func_233580_cy_(), world);
                }
            }
        });
        return witch;
    }

    private void lightningStrike(BlockPos playerPos, ServerWorld world) {
        LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a((World)world);
        lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)playerPos));
        lightningboltentity.func_233623_a_(false);
        world.func_217376_c((Entity)lightningboltentity);
    }

    private void throwPotion(WitchEntity witch, BlockPos playerPos, ServerWorld world) {
        PotionEntity pot = new PotionEntity((World)world, (LivingEntity)witch);
        pot.func_213884_b(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)RewardsUtil.getRandomPotionType()));
        double d0 = (double)playerPos.func_177956_o() + 0.5;
        double d1 = (double)playerPos.func_177958_n() - witch.func_226277_ct_();
        double d2 = d0 - pot.func_226278_cu_();
        double d3 = (double)playerPos.func_177952_p() - witch.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        pot.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        world.func_217376_c((Entity)pot);
    }

    private void spawnMinoins(BlockPos pos, ServerWorld world, BossBaseReward.BattleWrapper battleWrapper) {
        for (Direction facing : Direction.values()) {
            if (facing == Direction.UP || facing == Direction.DOWN) continue;
            try {
                Optional entType = EntityType.func_220327_a((String)this.entities.get(RewardsUtil.rand.nextInt(this.entities.size())));
                Entity ent = entType.isPresent() ? ((EntityType)entType.get()).func_200721_a((World)world) : EntityType.field_200797_k.func_200721_a((World)world);
                BlockPos adjPos = pos.func_177972_a(facing);
                ent.func_70107_b((double)adjPos.func_177958_n(), (double)adjPos.func_177956_o(), (double)adjPos.func_177952_p());
                world.func_217376_c(ent);
                this.trackSubEntities(battleWrapper, ent);
            }
            catch (Exception e) {
                CCubesCore.logger.log(Level.ERROR, "Uh oh! Something went wrong and the minions could not be spawned! Please report this to the mod dev!");
                return;
            }
        }
    }

    @Override
    public void onBossFightEnd(ServerWorld world, BlockPos pos, PlayerEntity player) {
    }
}

