/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.IEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.block.EnderAlternatorBlock;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.EnderCrafterContainer;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EnderCrafterTileEntity
extends BaseInventoryTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(10, this::onContentsChanged);
    private final BaseItemStackHandler recipeInventory = new BaseItemStackHandler(9);
    private IEnderCrafterRecipe recipe;
    private int progress;
    private int progressReq;
    private boolean isGridChanged = true;

    public EnderCrafterTileEntity() {
        super((TileEntityType)ModTileEntities.ENDER_CRAFTER.get());
        this.inventory.setOutputSlots(new int[]{9});
        this.inventory.setSlotValidator(this::canInsertStack);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.progress = tag.func_74762_e("Progress");
        this.progressReq = tag.func_74762_e("ProgressReq");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("Progress", this.progress);
        tag.func_74768_a("ProgressReq", this.progressReq);
        return tag;
    }

    public void func_73660_a() {
        boolean mark = false;
        World world = this.func_145831_w();
        if (world != null) {
            this.updateRecipeInventory();
            IInventory recipeInventory = this.recipeInventory.toIInventory();
            if (this.isGridChanged && (this.recipe == null || !this.recipe.func_77569_a(recipeInventory, world))) {
                this.recipe = world.func_199532_z().func_215371_a(RecipeTypes.ENDER_CRAFTER, recipeInventory, world).orElse(null);
                this.isGridChanged = false;
            }
            if (!world.func_201670_d()) {
                if (this.recipe != null) {
                    ItemStack output;
                    ItemStack result = this.recipe.func_77572_b(recipeInventory);
                    if (StackHelper.canCombineStacks((ItemStack)result, (ItemStack)(output = this.inventory.getStackInSlot(9)))) {
                        List<BlockPos> alternators = this.getAlternatorPositions();
                        int alternatorCount = alternators.size();
                        if (alternatorCount > 0) {
                            this.progress(alternatorCount, this.recipe.getCraftingTime());
                            for (BlockPos pos : alternators) {
                                if (!world.func_175623_d(pos.func_177984_a())) continue;
                                this.spawnParticles(ParticleTypes.field_197599_J, pos, 1.0, 1);
                            }
                            if (this.progress >= this.progressReq) {
                                for (int i = 0; i < this.inventory.getSlots() - 1; ++i) {
                                    this.inventory.extractItemSuper(i, 1, false);
                                }
                                this.updateResult(result);
                                this.progress = 0;
                            }
                            mark = true;
                        }
                    } else if (this.progress > 0 || this.progressReq > 0) {
                        this.progress = 0;
                        this.progressReq = 0;
                        mark = true;
                    }
                } else if (this.progress > 0 || this.progressReq > 0) {
                    this.progress = 0;
                    this.progressReq = 0;
                    mark = true;
                }
            }
            if (mark) {
                this.markDirtyAndDispatch();
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return Localizable.of((String)"container.extendedcrafting.ender_crafter").build();
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return EnderCrafterContainer.create(windowId, playerInventory, arg_0 -> ((EnderCrafterTileEntity)this).isUsableByPlayer(arg_0), this.inventory, (IIntArray)new IntArray(0), this.func_174877_v());
    }

    protected boolean canInsertStack(int slot, ItemStack stack) {
        return false;
    }

    private void updateResult(ItemStack stack) {
        ItemStack result = this.inventory.getStackInSlot(9);
        if (result.func_190926_b()) {
            this.inventory.setStackInSlot(9, stack);
        } else {
            this.inventory.setStackInSlot(9, StackHelper.grow((ItemStack)result, (int)stack.func_190916_E()));
        }
    }

    private void updateRecipeInventory() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            this.recipeInventory.setStackInSlot(i, stack);
        }
    }

    private List<BlockPos> getAlternatorPositions() {
        ArrayList<BlockPos> alternators = new ArrayList<BlockPos>();
        World world = this.func_145831_w();
        if (world != null) {
            BlockPos pos = this.func_174877_v();
            BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-3, -3, -3), (BlockPos)pos.func_177982_a(3, 3, 3)).forEach(aoePos -> {
                Block block = world.func_180495_p(aoePos).func_177230_c();
                if (block instanceof EnderAlternatorBlock) {
                    alternators.add(aoePos.func_185334_h());
                }
            });
        }
        return alternators;
    }

    private void progress(int alternators, int timeRequired) {
        ++this.progress;
        int timeReq = 20 * timeRequired;
        double effectiveness = (Double)ModConfigs.ENDER_CRAFTER_ALTERNATOR_EFFECTIVENESS.get();
        this.progressReq = (int)Math.max((double)timeReq - (double)timeReq * (effectiveness * (double)alternators), 20.0);
    }

    private <T extends IParticleData> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.func_145831_w() == null || this.func_145831_w().func_201670_d()) {
            return;
        }
        ServerWorld world = (ServerWorld)this.func_145831_w();
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + yOffset;
        double z = (double)pos.func_177952_p() + 0.5;
        world.func_195598_a(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    private void onContentsChanged() {
        this.isGridChanged = true;
        this.markDirtyAndDispatch();
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressRequired() {
        return this.progressReq;
    }

    public IEnderCrafterRecipe getActiveRecipe() {
        return this.recipe;
    }
}

