/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.energy.BaseEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.CraftingCoreContainer;
import com.blakebr0.extendedcrafting.crafting.recipe.CombinationRecipe;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import com.blakebr0.extendedcrafting.tileentity.PedestalTileEntity;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.IItemHandler;

public class CraftingCoreTileEntity
extends BaseInventoryTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(1, () -> ((CraftingCoreTileEntity)this).markDirtyAndDispatch());
    private final BaseEnergyStorage energy = new BaseEnergyStorage(((Integer)ModConfigs.CRAFTING_CORE_POWER_CAPACITY.get()).intValue());
    private final BaseItemStackHandler recipeInventory = new BaseItemStackHandler(49);
    private CombinationRecipe recipe;
    private int progress;
    private int oldEnergy;
    private int pedestalCount;
    private boolean haveItemsChanged = true;

    public CraftingCoreTileEntity() {
        super((TileEntityType)ModTileEntities.CRAFTING_CORE.get());
        this.inventory.setDefaultSlotLimit(1);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.progress = tag.func_74762_e("Progress");
        this.energy.setEnergy(tag.func_74762_e("Energy"));
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("Progress", this.progress);
        tag.func_74768_a("Energy", this.energy.getEnergyStored());
        return tag;
    }

    public void func_73660_a() {
        boolean mark = false;
        Map<BlockPos, ItemStack> pedestalsWithItems = this.getPedestalsWithItems();
        World world = this.func_145831_w();
        if (world != null) {
            ItemStack[] stacks = pedestalsWithItems.values().toArray(new ItemStack[0]);
            this.updateRecipeInventory(stacks);
            if (this.haveItemsChanged && (this.recipe == null || !this.recipe.matches((IItemHandler)this.recipeInventory))) {
                this.recipe = world.func_199532_z().func_215371_a(RecipeTypes.COMBINATION, this.recipeInventory.toIInventory(), world).orElse(null);
            }
            if (!world.func_201670_d()) {
                if (this.recipe != null) {
                    if (this.energy.getEnergyStored() > 0) {
                        boolean done = this.process(this.recipe);
                        if (done) {
                            for (BlockPos pedestalPos : pedestalsWithItems.keySet()) {
                                TileEntity tile = world.func_175625_s(pedestalPos);
                                if (!(tile instanceof PedestalTileEntity)) continue;
                                PedestalTileEntity pedestal = (PedestalTileEntity)tile;
                                BaseItemStackHandler inventory = pedestal.getInventory();
                                inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)inventory.getStackInSlot(0), (int)1, (boolean)true));
                                pedestal.markDirtyAndDispatch();
                                this.spawnParticles(ParticleTypes.field_197601_L, pedestalPos, 1.1, 20);
                            }
                            this.spawnParticles(ParticleTypes.field_197624_q, this.func_174877_v(), 1.1, 50);
                            this.inventory.setStackInSlot(0, this.recipe.getCraftingResult((IItemHandler)this.recipeInventory));
                            this.progress = 0;
                            mark = true;
                        } else {
                            this.spawnParticles(ParticleTypes.field_197625_r, this.func_174877_v(), 1.15, 2);
                            if (this.shouldSpawnItemParticles()) {
                                for (BlockPos pedestalPos : pedestalsWithItems.keySet()) {
                                    TileEntity tile = world.func_175625_s(pedestalPos);
                                    if (!(tile instanceof PedestalTileEntity)) continue;
                                    PedestalTileEntity pedestal = (PedestalTileEntity)tile;
                                    BaseItemStackHandler inventory = pedestal.getInventory();
                                    ItemStack stack = inventory.getStackInSlot(0);
                                    this.spawnItemParticles(pedestalPos, stack);
                                }
                            }
                        }
                    }
                } else {
                    this.progress = 0;
                }
            }
        }
        if (this.oldEnergy != this.energy.getEnergyStored()) {
            this.oldEnergy = this.energy.getEnergyStored();
            if (!mark) {
                mark = true;
            }
        }
        if (mark) {
            this.markDirtyAndDispatch();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.func_145837_r() && cap == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(cap, LazyOptional.of(this::getEnergy));
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return Localizable.of((String)"container.extendedcrafting.crafting_core").build();
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return CraftingCoreContainer.create(windowId, playerInventory, arg_0 -> ((CraftingCoreTileEntity)this).isUsableByPlayer(arg_0), (IIntArray)new IntArray(0), this.func_174877_v());
    }

    public BaseEnergyStorage getEnergy() {
        return this.energy;
    }

    public CombinationRecipe getActiveRecipe() {
        return this.recipe;
    }

    public boolean hasRecipe() {
        return this.recipe != null;
    }

    public int getEnergyRequired() {
        return this.hasRecipe() ? this.recipe.getPowerCost() : 0;
    }

    public int getEnergyRate() {
        return this.hasRecipe() ? this.recipe.getPowerRate() : 0;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getPedestalCount() {
        return this.pedestalCount;
    }

    private void updateRecipeInventory(ItemStack[] items) {
        int i;
        boolean haveItemsChanged;
        boolean bl = haveItemsChanged = this.recipeInventory.getSlots() != items.length + 1 || !CraftingCoreTileEntity.areStacksEqual(this.recipeInventory.getStackInSlot(0), this.inventory.getStackInSlot(0));
        if (!haveItemsChanged) {
            for (i = 0; i < items.length; ++i) {
                if (CraftingCoreTileEntity.areStacksEqual(this.recipeInventory.getStackInSlot(i + 1), items[i])) continue;
                haveItemsChanged = true;
                break;
            }
        }
        this.haveItemsChanged = haveItemsChanged;
        if (!haveItemsChanged) {
            return;
        }
        this.recipeInventory.setSize(items.length + 1);
        this.recipeInventory.setStackInSlot(0, this.inventory.getStackInSlot(0));
        for (i = 0; i < items.length; ++i) {
            this.recipeInventory.setStackInSlot(i + 1, items[i]);
        }
    }

    private boolean process(CombinationRecipe recipe) {
        int extract = recipe.getPowerRate();
        int difference = recipe.getPowerCost() - this.progress;
        if (difference < recipe.getPowerRate()) {
            extract = difference;
        }
        int extracted = this.energy.extractEnergy(extract, false);
        this.progress += extracted;
        return this.progress >= recipe.getPowerCost();
    }

    public Map<BlockPos, ItemStack> getPedestalsWithItems() {
        HashMap<BlockPos, ItemStack> pedestals = new HashMap<BlockPos, ItemStack>();
        World world = this.func_145831_w();
        int pedestalCount = 0;
        if (world != null) {
            BlockPos pos = this.func_174877_v();
            Iterator positions = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-3, 0, -3), (BlockPos)pos.func_177982_a(3, 0, 3)).iterator();
            while (positions.hasNext()) {
                BlockPos aoePos = (BlockPos)positions.next();
                TileEntity tile = world.func_175625_s(aoePos);
                if (!(tile instanceof PedestalTileEntity)) continue;
                PedestalTileEntity pedestal = (PedestalTileEntity)tile;
                ItemStack stack = pedestal.getInventory().getStackInSlot(0);
                ++pedestalCount;
                if (stack.func_190926_b()) continue;
                pedestals.put(aoePos.func_185334_h(), stack);
            }
        }
        this.pedestalCount = pedestalCount;
        return pedestals;
    }

    private <T extends IParticleData> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.func_145831_w() == null || this.func_145831_w().func_201670_d()) {
            return;
        }
        ServerWorld world = (ServerWorld)this.func_145831_w();
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + yOffset;
        double z = (double)pos.func_177952_p() + 0.5;
        world.func_195598_a(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    private void spawnItemParticles(BlockPos pedestalPos, ItemStack stack) {
        if (this.func_145831_w() == null || this.func_145831_w().func_201670_d()) {
            return;
        }
        ServerWorld world = (ServerWorld)this.func_145831_w();
        BlockPos pos = this.func_174877_v();
        double x = (double)pedestalPos.func_177958_n() + world.func_201674_k().nextDouble() * 0.2 + 0.4;
        double y = (double)pedestalPos.func_177956_o() + world.func_201674_k().nextDouble() * 0.2 + 1.4;
        double z = (double)pedestalPos.func_177952_p() + world.func_201674_k().nextDouble() * 0.2 + 0.4;
        double velX = pos.func_177958_n() - pedestalPos.func_177958_n();
        double velY = 0.25;
        double velZ = pos.func_177952_p() - pedestalPos.func_177952_p();
        world.func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), x, y, z, 0, velX, velY, velZ, 0.18);
    }

    private boolean shouldSpawnItemParticles() {
        int powerRate;
        int endingPower;
        int powerCost = this.recipe.getPowerCost();
        return this.progress > powerCost - (endingPower = (powerRate = this.recipe.getPowerRate()) * 40);
    }

    private static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b() && stack2.func_190926_b()) {
            return true;
        }
        return !stack1.func_190926_b() && stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }
}

