/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.energy.BaseEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.CompressorContainer;
import com.blakebr0.extendedcrafting.crafting.recipe.CompressorRecipe;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class CompressorTileEntity
extends BaseInventoryTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private final BaseItemStackHandler inventory;
    private final BaseItemStackHandler recipeInventory;
    private final BaseEnergyStorage energy;
    private final LazyOptional<IEnergyStorage> capability = LazyOptional.of(this::getEnergy);
    private CompressorRecipe recipe;
    private ItemStack materialStack = ItemStack.field_190927_a;
    private int materialCount;
    private int progress;
    private boolean ejecting = false;
    private int oldEnergy;
    private boolean inputLimit = true;

    public CompressorTileEntity() {
        super((TileEntityType)ModTileEntities.COMPRESSOR.get());
        this.inventory = new BaseItemStackHandler(3);
        this.recipeInventory = new BaseItemStackHandler(2);
        this.energy = new BaseEnergyStorage(((Integer)ModConfigs.COMPRESSOR_POWER_CAPACITY.get()).intValue());
        this.inventory.setSlotValidator(this::canInsertStack);
        this.inventory.setOutputSlots(new int[]{0});
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.materialCount = tag.func_74762_e("MaterialCount");
        this.materialStack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("MaterialStack"));
        this.progress = tag.func_74762_e("Progress");
        this.ejecting = tag.func_74767_n("Ejecting");
        this.energy.setEnergy(tag.func_74762_e("Energy"));
        this.inputLimit = tag.func_74767_n("InputLimit");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("MaterialCount", this.materialCount);
        tag.func_218657_a("MaterialStack", (INBT)this.materialStack.serializeNBT());
        tag.func_74768_a("Progress", this.progress);
        tag.func_74757_a("Ejecting", this.ejecting);
        tag.func_74768_a("Energy", this.energy.getEnergyStored());
        tag.func_74757_a("InputLimit", this.inputLimit);
        return tag;
    }

    public void func_73660_a() {
        boolean mark = false;
        World world = this.func_145831_w();
        if (world != null) {
            ItemStack output = this.inventory.getStackInSlot(0);
            ItemStack input = this.inventory.getStackInSlot(1);
            ItemStack catalyst = this.inventory.getStackInSlot(2);
            this.recipeInventory.setStackInSlot(0, this.materialStack);
            this.recipeInventory.setStackInSlot(1, catalyst);
            if (this.recipe == null || !this.recipe.matches((IItemHandler)this.recipeInventory)) {
                this.recipe = world.func_199532_z().func_215371_a(RecipeTypes.COMPRESSOR, this.recipeInventory.toIInventory(), world).orElse(null);
            }
            if (!world.func_201670_d()) {
                int addCount;
                if (!input.func_190926_b()) {
                    if (this.materialStack.func_190926_b() || this.materialCount <= 0) {
                        this.materialStack = input.func_77946_l();
                        mark = true;
                    }
                    if ((!this.inputLimit || this.recipe != null && this.materialCount < this.recipe.getInputCount()) && StackHelper.areStacksEqual((ItemStack)input, (ItemStack)this.materialStack)) {
                        int consumeAmount = input.func_190916_E();
                        if (this.inputLimit) {
                            consumeAmount = Math.min(consumeAmount, this.recipe.getInputCount() - this.materialCount);
                        }
                        input.func_190918_g(consumeAmount);
                        this.materialCount += consumeAmount;
                        mark = true;
                    }
                }
                if (this.recipe != null && this.getEnergy().getEnergyStored() > 0 && this.materialCount >= this.recipe.getInputCount()) {
                    if (this.progress >= this.recipe.getPowerCost()) {
                        ItemStack result = this.recipe.getCraftingResult((IItemHandler)this.inventory);
                        if (StackHelper.canCombineStacks((ItemStack)result, (ItemStack)output)) {
                            this.updateResult(result);
                            this.progress = 0;
                            this.materialCount -= this.recipe.getInputCount();
                            if (this.materialCount <= 0) {
                                this.materialStack = ItemStack.field_190927_a;
                            }
                        }
                    } else {
                        this.process(this.recipe);
                        mark = true;
                    }
                }
                if (this.ejecting && this.materialCount > 0 && !this.materialStack.func_190926_b() && (output.func_190926_b() || StackHelper.areStacksEqual((ItemStack)this.materialStack, (ItemStack)output)) && (addCount = Math.min(this.materialCount, this.materialStack.func_77976_d() - output.func_190916_E())) > 0) {
                    ItemStack toAdd = StackHelper.withSize((ItemStack)this.materialStack, (int)addCount, (boolean)false);
                    this.updateResult(toAdd);
                    this.materialCount -= addCount;
                    if (this.materialCount < 1) {
                        this.materialStack = ItemStack.field_190927_a;
                        this.ejecting = false;
                    }
                    if (this.progress > 0) {
                        this.progress = 0;
                    }
                    if (!mark) {
                        mark = true;
                    }
                }
            }
            if (this.oldEnergy != this.energy.getEnergyStored()) {
                this.oldEnergy = this.energy.getEnergyStored();
                if (!mark) {
                    mark = true;
                }
            }
            if (mark) {
                this.markDirtyAndDispatch();
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.func_145837_r() && cap == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(cap, this.capability);
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return Localizable.of((String)"container.extendedcrafting.compressor").build();
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return CompressorContainer.create(windowId, playerInventory, arg_0 -> ((CompressorTileEntity)this).isUsableByPlayer(arg_0), this.inventory, (IIntArray)new IntArray(0), this.func_174877_v());
    }

    public BaseEnergyStorage getEnergy() {
        return this.energy;
    }

    public ItemStack getMaterialStack() {
        return this.materialStack;
    }

    public boolean hasMaterialStack() {
        return !this.materialStack.func_190926_b();
    }

    public int getMaterialCount() {
        return this.materialCount;
    }

    public boolean isEjecting() {
        return this.ejecting;
    }

    public void toggleEjecting() {
        if (this.materialCount > 0) {
            this.ejecting = !this.ejecting;
            this.markDirtyAndDispatch();
        }
    }

    public boolean isLimitingInput() {
        return this.inputLimit;
    }

    public void toggleInputLimit() {
        this.inputLimit = !this.inputLimit;
        this.markDirtyAndDispatch();
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean hasRecipe() {
        return this.recipe != null;
    }

    public CompressorRecipe getActiveRecipe() {
        return this.recipe;
    }

    public int getEnergyRequired() {
        if (this.hasRecipe()) {
            return this.recipe.getPowerCost();
        }
        return 0;
    }

    public int getMaterialsRequired() {
        if (this.hasRecipe()) {
            return this.recipe.getInputCount();
        }
        return 0;
    }

    private void process(CompressorRecipe recipe) {
        int extract = recipe.getPowerRate();
        int difference = recipe.getPowerCost() - this.progress;
        if (difference < extract) {
            extract = difference;
        }
        int extracted = this.energy.extractEnergy(extract, false);
        this.progress += extracted;
    }

    private void updateResult(ItemStack stack) {
        ItemStack result = this.inventory.getStackInSlot(0);
        if (result.func_190926_b()) {
            this.inventory.setStackInSlot(0, stack);
        } else {
            this.inventory.setStackInSlot(0, StackHelper.grow((ItemStack)result, (int)stack.func_190916_E()));
        }
    }

    private boolean canInsertStack(int slot, ItemStack stack) {
        return slot == 1;
    }
}

