/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.energy.BaseEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.AdvancedAutoTableContainer;
import com.blakebr0.extendedcrafting.container.BasicAutoTableContainer;
import com.blakebr0.extendedcrafting.container.EliteAutoTableContainer;
import com.blakebr0.extendedcrafting.container.UltimateAutoTableContainer;
import com.blakebr0.extendedcrafting.container.inventory.ExtendedCraftingInventory;
import com.blakebr0.extendedcrafting.crafting.TableRecipeStorage;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class AutoTableTileEntity
extends BaseInventoryTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private static final Container EMPTY_CONTAINER = new Container(null, -1){

        public boolean func_75145_c(PlayerEntity player) {
            return false;
        }
    };
    private WrappedRecipe recipe;
    private int progress;
    private boolean running = true;
    private int oldEnergy;
    private boolean isGridChanged = true;

    public AutoTableTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("Progress", this.progress);
        tag.func_74757_a("Running", this.running);
        tag.func_74768_a("Energy", this.getEnergy().getEnergyStored());
        tag.func_197643_a(this.getRecipeStorage().serializeNBT());
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.progress = tag.func_74762_e("Progress");
        this.running = tag.func_74767_n("Running");
        this.getEnergy().setEnergy(tag.func_74762_e("Energy"));
        this.getRecipeStorage().deserializeNBT(tag);
    }

    public void func_73660_a() {
        boolean mark = false;
        World world = this.func_145831_w();
        BaseEnergyStorage energy = this.getEnergy();
        if (world != null) {
            int selected;
            if (this.running) {
                this.updateRecipeInventory();
                IInventory recipeInventory = this.getRecipeInventory().toIInventory();
                if (this.isGridChanged && (this.recipe == null || !this.recipe.matches(recipeInventory, world))) {
                    ITableRecipe recipe = world.func_199532_z().func_215371_a(RecipeTypes.TABLE, recipeInventory, world).orElse(null);
                    WrappedRecipe wrappedRecipe = this.recipe = recipe != null ? new WrappedRecipe(recipe) : null;
                    if (this.recipe == null && ((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue() && this instanceof Basic) {
                        ExtendedCraftingInventory craftingInventory = new ExtendedCraftingInventory(EMPTY_CONTAINER, this.getRecipeInventory(), 3);
                        ICraftingRecipe vanilla = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftingInventory, world).orElse(null);
                        this.recipe = vanilla != null ? new WrappedRecipe(vanilla, craftingInventory) : null;
                    }
                    this.isGridChanged = false;
                }
                if (!world.func_201670_d()) {
                    if (this.recipe != null) {
                        BaseItemStackHandler inventory = this.getInventory();
                        ItemStack result = this.recipe.getCraftingResult(recipeInventory);
                        int outputSlot = inventory.getSlots() - 1;
                        ItemStack output = inventory.getStackInSlot(outputSlot);
                        int powerRate = (Integer)ModConfigs.AUTO_TABLE_POWER_RATE.get();
                        if (StackHelper.canCombineStacks((ItemStack)result, (ItemStack)output) && energy.getEnergyStored() >= powerRate) {
                            ++this.progress;
                            energy.extractEnergy(powerRate, false);
                            if (this.progress >= this.getProgressRequired()) {
                                NonNullList<ItemStack> remaining = this.recipe.getRemainingItems(recipeInventory);
                                for (int i = 0; i < recipeInventory.func_70302_i_(); ++i) {
                                    if (!((ItemStack)remaining.get(i)).func_190926_b()) {
                                        inventory.setStackInSlot(i, (ItemStack)remaining.get(i));
                                        continue;
                                    }
                                    inventory.extractItemSuper(i, 1, false);
                                }
                                this.updateResult(result, outputSlot);
                                this.progress = 0;
                                this.isGridChanged = true;
                            }
                            mark = true;
                        }
                    } else if (this.progress > 0) {
                        this.progress = 0;
                        mark = true;
                    }
                }
            } else if (this.progress > 0) {
                this.progress = 0;
                mark = true;
            }
            int insertPowerRate = (Integer)ModConfigs.AUTO_TABLE_INSERT_POWER_RATE.get();
            if (!world.func_201670_d() && this.getEnergy().getEnergyStored() >= insertPowerRate && (selected = this.getRecipeStorage().getSelected()) != -1) {
                this.getAboveInventory().ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        boolean inserted;
                        ItemStack stack = handler.getStackInSlot(i);
                        if (stack.func_190926_b() || handler.extractItem(i, 1, true).func_190926_b() || !(inserted = this.tryInsertItemIntoGrid(stack))) continue;
                        handler.extractItem(i, 1, false);
                        break;
                    }
                });
            }
        }
        if (this.oldEnergy != energy.getEnergyStored()) {
            this.oldEnergy = energy.getEnergyStored();
            if (!mark) {
                mark = true;
            }
        }
        if (mark) {
            this.markDirtyAndDispatch();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.func_145837_r() && cap == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(cap, LazyOptional.of(this::getEnergy));
        }
        return super.getCapability(cap, side);
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void toggleRunning() {
        this.running = !this.running;
        this.markDirtyAndDispatch();
    }

    public void selectRecipe(int index) {
        this.getRecipeStorage().setSelected(index);
        this.markDirtyAndDispatch();
    }

    public void saveRecipe(int index) {
        World world = this.func_145831_w();
        if (world == null) {
            return;
        }
        this.updateRecipeInventory();
        BaseItemStackHandler recipeInventory = this.getRecipeInventory();
        IInventory recipeIInventory = recipeInventory.toIInventory();
        BaseItemStackHandler newRecipeInventory = new BaseItemStackHandler(recipeInventory.getSlots());
        for (int i = 0; i < recipeInventory.getSlots(); ++i) {
            newRecipeInventory.setStackInSlot(i, recipeInventory.getStackInSlot(i).func_77946_l());
        }
        ItemStack result = ItemStack.field_190927_a;
        ITableRecipe recipe = world.func_199532_z().func_215371_a(RecipeTypes.TABLE, recipeIInventory, world).orElse(null);
        if (recipe != null) {
            result = recipe.func_77572_b(recipeIInventory);
        } else {
            ExtendedCraftingInventory craftingInventory = new ExtendedCraftingInventory(EMPTY_CONTAINER, recipeInventory, 3);
            ICraftingRecipe vanilla = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftingInventory, world).orElse(null);
            if (vanilla != null) {
                result = vanilla.func_77572_b((IInventory)craftingInventory);
            }
        }
        this.getRecipeStorage().setRecipe(index, newRecipeInventory, result);
        this.markDirtyAndDispatch();
    }

    public void deleteRecipe(int index) {
        this.getRecipeStorage().unsetRecipe(index);
        this.markDirtyAndDispatch();
    }

    public abstract int getProgressRequired();

    public abstract BaseItemStackHandler getRecipeInventory();

    public abstract TableRecipeStorage getRecipeStorage();

    public abstract BaseEnergyStorage getEnergy();

    protected boolean canInsertStack(int slot, ItemStack stack) {
        return false;
    }

    protected void onContentsChanged() {
        this.isGridChanged = true;
        this.markDirtyAndDispatch();
    }

    private void updateRecipeInventory() {
        BaseItemStackHandler inventory = this.getInventory();
        this.getRecipeInventory().setSize(inventory.getSlots() - 1);
        for (int i = 0; i < inventory.getSlots() - 1; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            this.getRecipeInventory().setStackInSlot(i, stack);
        }
    }

    private void updateResult(ItemStack stack, int slot) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack result = inventory.getStackInSlot(inventory.getSlots() - 1);
        if (result.func_190926_b()) {
            inventory.setStackInSlot(slot, stack);
        } else {
            inventory.setStackInSlot(slot, StackHelper.grow((ItemStack)result, (int)stack.func_190916_E()));
        }
    }

    private void addStackToSlot(ItemStack stack, int slot) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack stackInSlot = inventory.getStackInSlot(slot);
        if (stackInSlot.func_190926_b()) {
            inventory.setStackInSlot(slot, stack);
        } else {
            inventory.setStackInSlot(slot, StackHelper.grow((ItemStack)stackInSlot, (int)stack.func_190916_E()));
        }
    }

    private LazyOptional<IItemHandler> getAboveInventory() {
        TileEntity tile;
        World world = this.func_145831_w();
        BlockPos pos = this.func_174877_v().func_177984_a();
        if (world != null && (tile = world.func_175625_s(pos)) != null) {
            return tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN);
        }
        return LazyOptional.empty();
    }

    private boolean tryInsertItemIntoGrid(ItemStack input) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack stackToPut = ItemStack.field_190927_a;
        BaseItemStackHandler recipe = this.getRecipeStorage().getSelectedRecipe();
        int slotToPut = -1;
        boolean isGridChanged = false;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack slot = inventory.getStackInSlot(i);
            ItemStack recipeStack = recipe.getStackInSlot(i);
            if (!slot.func_190926_b() && !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)slot) || !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)recipeStack) || !slot.func_190926_b() && slot.func_190916_E() >= slot.func_77976_d()) continue;
            if (slot.func_190926_b()) {
                slotToPut = i;
                isGridChanged = true;
                break;
            }
            if (!stackToPut.func_190926_b() && slot.func_190916_E() >= stackToPut.func_190916_E()) continue;
            slotToPut = i;
            stackToPut = slot;
        }
        this.isGridChanged |= isGridChanged;
        if (slotToPut > -1) {
            int insertPowerRate = (Integer)ModConfigs.AUTO_TABLE_INSERT_POWER_RATE.get();
            ItemStack toInsert = StackHelper.withSize((ItemStack)input, (int)1, (boolean)false);
            this.addStackToSlot(toInsert, slotToPut);
            this.getEnergy().extractEnergy(insertPowerRate, false);
            return true;
        }
        return false;
    }

    public static class Ultimate
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = new BaseItemStackHandler(82, this::onContentsChanged);
        private final BaseItemStackHandler recipeInventory = new BaseItemStackHandler(81);
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(82);
        private final BaseEnergyStorage energy = new BaseEnergyStorage((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get() * 8);

        public Ultimate() {
            super((TileEntityType)ModTileEntities.ULTIMATE_AUTO_TABLE.get());
            this.inventory.setOutputSlots(new int[]{81});
            this.inventory.setSlotValidator((x$0, x$1) -> super.canInsertStack((int)x$0, (ItemStack)x$1));
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public ITextComponent func_145748_c_() {
            return Localizable.of((String)"container.extendedcrafting.ultimate_table").build();
        }

        public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
            return UltimateAutoTableContainer.create(windowId, playerInventory, arg_0 -> ((Ultimate)this).isUsableByPlayer(arg_0), this.inventory, (IIntArray)new IntArray(0), this.func_174877_v());
        }

        @Override
        public int getProgressRequired() {
            return 80;
        }

        @Override
        public BaseItemStackHandler getRecipeInventory() {
            return this.recipeInventory;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public BaseEnergyStorage getEnergy() {
            return this.energy;
        }
    }

    public static class Elite
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = new BaseItemStackHandler(50, this::onContentsChanged);
        private final BaseItemStackHandler recipeInventory = new BaseItemStackHandler(49);
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(50);
        private final BaseEnergyStorage energy = new BaseEnergyStorage((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get() * 4);

        public Elite() {
            super((TileEntityType)ModTileEntities.ELITE_AUTO_TABLE.get());
            this.inventory.setOutputSlots(new int[]{49});
            this.inventory.setSlotValidator((x$0, x$1) -> super.canInsertStack((int)x$0, (ItemStack)x$1));
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public ITextComponent func_145748_c_() {
            return Localizable.of((String)"container.extendedcrafting.elite_table").build();
        }

        public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
            return EliteAutoTableContainer.create(windowId, playerInventory, arg_0 -> ((Elite)this).isUsableByPlayer(arg_0), this.inventory, (IIntArray)new IntArray(0), this.func_174877_v());
        }

        @Override
        public int getProgressRequired() {
            return 60;
        }

        @Override
        public BaseItemStackHandler getRecipeInventory() {
            return this.recipeInventory;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public BaseEnergyStorage getEnergy() {
            return this.energy;
        }
    }

    public static class Advanced
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = new BaseItemStackHandler(26, this::onContentsChanged);
        private final BaseItemStackHandler recipeInventory = new BaseItemStackHandler(25);
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(26);
        private final BaseEnergyStorage energy = new BaseEnergyStorage((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get() * 2);

        public Advanced() {
            super((TileEntityType)ModTileEntities.ADVANCED_AUTO_TABLE.get());
            this.inventory.setOutputSlots(new int[]{25});
            this.inventory.setSlotValidator((x$0, x$1) -> super.canInsertStack((int)x$0, (ItemStack)x$1));
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public ITextComponent func_145748_c_() {
            return Localizable.of((String)"container.extendedcrafting.advanced_table").build();
        }

        public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
            return AdvancedAutoTableContainer.create(windowId, playerInventory, arg_0 -> ((Advanced)this).isUsableByPlayer(arg_0), this.inventory, (IIntArray)new IntArray(0), this.func_174877_v());
        }

        @Override
        public int getProgressRequired() {
            return 40;
        }

        @Override
        public BaseItemStackHandler getRecipeInventory() {
            return this.recipeInventory;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public BaseEnergyStorage getEnergy() {
            return this.energy;
        }
    }

    public static class Basic
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = new BaseItemStackHandler(10, this::onContentsChanged);
        private final BaseItemStackHandler recipeInventory = new BaseItemStackHandler(9);
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(10);
        private final BaseEnergyStorage energy = new BaseEnergyStorage(((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get()).intValue());

        public Basic() {
            super((TileEntityType)ModTileEntities.BASIC_AUTO_TABLE.get());
            this.inventory.setOutputSlots(new int[]{9});
            this.inventory.setSlotValidator((x$0, x$1) -> super.canInsertStack((int)x$0, (ItemStack)x$1));
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public ITextComponent func_145748_c_() {
            return Localizable.of((String)"container.extendedcrafting.basic_table").build();
        }

        public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
            return BasicAutoTableContainer.create(windowId, playerInventory, arg_0 -> ((Basic)this).isUsableByPlayer(arg_0), this.inventory, (IIntArray)new IntArray(0), this.func_174877_v());
        }

        @Override
        public int getProgressRequired() {
            return 20;
        }

        @Override
        public BaseItemStackHandler getRecipeInventory() {
            return this.recipeInventory;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public BaseEnergyStorage getEnergy() {
            return this.energy;
        }
    }

    public static class WrappedRecipe {
        private final Function<IInventory, ItemStack> resultFunc;
        private final BiFunction<IInventory, World, Boolean> matchesFunc;
        private final Function<IInventory, NonNullList<ItemStack>> remainingItemsFunc;

        public WrappedRecipe(ICraftingRecipe recipe, CraftingInventory craftingInventory) {
            this.resultFunc = inventory -> recipe.func_77572_b((IInventory)craftingInventory);
            this.matchesFunc = (inventory, world) -> recipe.func_77569_a((IInventory)craftingInventory, world);
            this.remainingItemsFunc = inventory -> recipe.func_179532_b((IInventory)craftingInventory);
        }

        public WrappedRecipe(ITableRecipe recipe) {
            this.resultFunc = arg_0 -> ((ITableRecipe)recipe).func_77572_b(arg_0);
            this.matchesFunc = (arg_0, arg_1) -> ((ITableRecipe)recipe).func_77569_a(arg_0, arg_1);
            this.remainingItemsFunc = arg_0 -> ((ITableRecipe)recipe).func_179532_b(arg_0);
        }

        public ItemStack getCraftingResult(IInventory inventory) {
            return this.resultFunc.apply(inventory);
        }

        public boolean matches(IInventory inventory, World world) {
            return this.matchesFunc.apply(inventory, world);
        }

        public NonNullList<ItemStack> getRemainingItems(IInventory inventory) {
            return this.remainingItemsFunc.apply(inventory);
        }
    }
}

