/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.singularity;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModItems;
import com.blakebr0.extendedcrafting.singularity.Singularity;
import com.blakebr0.extendedcrafting.singularity.SingularityRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public final class SingularityUtils {
    public static Singularity loadFromJson(ResourceLocation id, JsonObject json) {
        String name = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
        JsonArray colors = JSONUtils.func_151214_t((JsonObject)json, (String)"colors");
        int materialCount = JSONUtils.func_151208_a((JsonObject)json, (String)"materialCount", (int)((Integer)ModConfigs.SINGULARITY_MATERIALS_REQUIRED.get()));
        int overlayColor = Integer.parseInt(colors.get(0).getAsString(), 16);
        int underlayColor = Integer.parseInt(colors.get(1).getAsString(), 16);
        boolean inUltimateSingularity = JSONUtils.func_151209_a((JsonObject)json, (String)"inUltimateSingularity", (boolean)true);
        if (!json.has("ingredient")) {
            return new Singularity(id, name, new int[]{overlayColor, underlayColor}, Ingredient.field_193370_a, materialCount, inUltimateSingularity);
        }
        JsonObject ing = JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        if (ing.has("tag")) {
            String tag = ing.get("tag").getAsString();
            return new Singularity(id, name, new int[]{overlayColor, underlayColor}, tag, materialCount, inUltimateSingularity);
        }
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json.get("ingredient"));
        return new Singularity(id, name, new int[]{overlayColor, underlayColor}, ingredient, materialCount, inUltimateSingularity);
    }

    public static JsonObject writeToJson(Singularity singularity) {
        JsonElement ingredient;
        JsonObject json = new JsonObject();
        json.addProperty("name", singularity.getName());
        JsonArray colors = new JsonArray();
        colors.add(Integer.toString(singularity.getOverlayColor(), 16));
        colors.add(Integer.toString(singularity.getUnderlayColor(), 16));
        json.add("colors", (JsonElement)colors);
        if (singularity.getTag() != null) {
            JsonObject obj = new JsonObject();
            obj.addProperty("tag", singularity.getTag());
            ingredient = obj;
        } else {
            ingredient = singularity.getIngredient().func_200304_c();
        }
        json.add("ingredient", ingredient);
        return json;
    }

    public static CompoundNBT makeTag(Singularity singularity) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("Id", singularity.getId().toString());
        return nbt;
    }

    public static ItemStack getItemForSingularity(Singularity singularity) {
        CompoundNBT nbt = SingularityUtils.makeTag(singularity);
        ItemStack stack = new ItemStack((IItemProvider)ModItems.SINGULARITY.get());
        stack.func_77982_d(nbt);
        return stack;
    }

    public static Singularity getSingularity(ItemStack stack) {
        String id = NBTHelper.getString((ItemStack)stack, (String)"Id");
        if (!id.isEmpty()) {
            return SingularityRegistry.getInstance().getSingularityById(ResourceLocation.func_208304_a((String)id));
        }
        return null;
    }
}

