/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.singularity;

import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.network.NetworkHandler;
import com.blakebr0.extendedcrafting.network.message.SyncSingularitiesMessage;
import com.blakebr0.extendedcrafting.singularity.Singularity;
import com.blakebr0.extendedcrafting.singularity.SingularityUtils;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SingularityRegistry {
    private static final Logger LOGGER = LogManager.getLogger((String)"Extended Crafting");
    private static final SingularityRegistry INSTANCE = new SingularityRegistry();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<ResourceLocation, Singularity> singularities = new LinkedHashMap<ResourceLocation, Singularity>();

    @SubscribeEvent
    public void onDatapackSync(OnDatapackSyncEvent event) {
        SyncSingularitiesMessage message = new SyncSingularitiesMessage(this.getSingularities());
        ServerPlayerEntity player = event.getPlayer();
        if (player != null) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
        } else {
            NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)message);
        }
    }

    public void onResourceManagerReload(IResourceManager manager) {
        this.loadSingularities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSingularities() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        File dir = FMLPaths.CONFIGDIR.get().resolve("extendedcrafting/singularities/").toFile();
        if (!dir.exists() && dir.mkdirs()) {
            for (Singularity singularity : SingularityRegistry.defaults()) {
                JsonObject json = SingularityUtils.writeToJson(singularity);
                FileWriter writer = null;
                try {
                    File file = new File(dir, singularity.getId().func_110623_a() + ".json");
                    writer = new FileWriter(file);
                    GSON.toJson((JsonElement)json, (Appendable)writer);
                    writer.close();
                    IOUtils.closeQuietly((Writer)writer);
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while generating default singularities", (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly(writer);
                }
            }
        }
        if (!dir.mkdirs() && dir.isDirectory()) {
            this.loadFiles(dir);
        }
        stopwatch.stop();
        LOGGER.info("Loaded {} singularity type(s) in {} ms", (Object)this.singularities.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public List<Singularity> getSingularities() {
        return Lists.newArrayList(this.singularities.values());
    }

    public Singularity getSingularityById(ResourceLocation id) {
        return this.singularities.get(id);
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_150787_b(this.singularities.size());
        this.singularities.forEach((id, singularity) -> singularity.write(buffer));
    }

    public List<Singularity> readFromBuffer(PacketBuffer buffer) {
        ArrayList<Singularity> singularities = new ArrayList<Singularity>();
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            Singularity singularity = Singularity.read(buffer);
            singularities.add(singularity);
        }
        return singularities;
    }

    public void loadSingularities(SyncSingularitiesMessage message) {
        Map<ResourceLocation, Singularity> singularities = message.getSingularities().stream().collect(Collectors.toMap(Singularity::getId, s -> s));
        this.singularities.clear();
        this.singularities.putAll(singularities);
        LOGGER.info("Loaded {} singularities from the server", (Object)singularities.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFiles(File dir) {
        File[] files = dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            InputStreamReader reader = null;
            Singularity singularity = null;
            try {
                JsonParser parser = new JsonParser();
                reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
                String name = file.getName().replace(".json", "");
                singularity = SingularityUtils.loadFromJson(new ResourceLocation("extendedcrafting", name), json);
                reader.close();
                IOUtils.closeQuietly((Reader)reader);
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while loading singularities", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
            if (singularity == null) continue;
            ResourceLocation id = singularity.getId();
            this.singularities.put(id, singularity);
        }
    }

    public static SingularityRegistry getInstance() {
        return INSTANCE;
    }

    private static List<Singularity> defaults() {
        int count = (Integer)ModConfigs.SINGULARITY_MATERIALS_REQUIRED.get();
        return Lists.newArrayList((Object[])new Singularity[]{new Singularity(new ResourceLocation("extendedcrafting", "coal"), "singularity.extendedcrafting.coal", new int[]{0x323232, 0x101015}, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151044_h}), count, true), new Singularity(new ResourceLocation("extendedcrafting", "iron"), "singularity.extendedcrafting.iron", new int[]{0xD8D8D8, 0xA8A8A8}, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j}), count, true), new Singularity(new ResourceLocation("extendedcrafting", "lapis_lazuli"), "singularity.extendedcrafting.lapis_lazuli", new int[]{5931746, 3432131}, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196128_bn}), count, true), new Singularity(new ResourceLocation("extendedcrafting", "redstone"), "singularity.extendedcrafting.redstone", new int[]{11144961, 0x720000}, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), count, true), new Singularity(new ResourceLocation("extendedcrafting", "glowstone"), "singularity.extendedcrafting.glowstone", new int[]{16759902, 11825472}, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151114_aO}), count, true), new Singularity(new ResourceLocation("extendedcrafting", "diamond"), "singularity.extendedcrafting.diamond", new int[]{4910553, 2147765}, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151045_i}), count, true), new Singularity(new ResourceLocation("extendedcrafting", "emerald"), "singularity.extendedcrafting.emerald", new int[]{4322180, 43564}, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151166_bC}), count, true), new Singularity(new ResourceLocation("extendedcrafting", "aluminum"), "singularity.extendedcrafting.aluminum", new int[]{0xCACCDA, 0xCACCDA}, "forge:ingots/aluminum", count, true), new Singularity(new ResourceLocation("extendedcrafting", "copper"), "singularity.extendedcrafting.copper", new int[]{13529601, 13529601}, "forge:ingots/copper", count, true), new Singularity(new ResourceLocation("extendedcrafting", "tin"), "singularity.extendedcrafting.tin", new int[]{7770277, 7770277}, "forge:ingots/tin", count, true), new Singularity(new ResourceLocation("extendedcrafting", "bronze"), "singularity.extendedcrafting.bronze", new int[]{11040068, 11040068}, "forge:ingots/bronze", count, true), new Singularity(new ResourceLocation("extendedcrafting", "silver"), "singularity.extendedcrafting.silver", new int[]{8628914, 8628914}, "forge:ingots/silver", count, true), new Singularity(new ResourceLocation("extendedcrafting", "lead"), "singularity.extendedcrafting.lead", new int[]{4738919, 4738919}, "forge:ingots/lead", count, true), new Singularity(new ResourceLocation("extendedcrafting", "steel"), "singularity.extendedcrafting.steel", new int[]{0x565656, 0x565656}, "forge:ingots/steel", count, true), new Singularity(new ResourceLocation("extendedcrafting", "nickel"), "singularity.extendedcrafting.nickel", new int[]{12498050, 12498050}, "forge:ingots/nickel", count, true), new Singularity(new ResourceLocation("extendedcrafting", "electrum"), "singularity.extendedcrafting.electrum", new int[]{10981685, 10981685}, "forge:ingots/electrum", count, true), new Singularity(new ResourceLocation("extendedcrafting", "invar"), "singularity.extendedcrafting.invar", new int[]{9608599, 9608599}, "forge:ingots/invar", count, true), new Singularity(new ResourceLocation("extendedcrafting", "uranium"), "singularity.extendedcrafting.uranium", new int[]{4620301, 4620301}, "forge:ingots/uranium", count, true), new Singularity(new ResourceLocation("extendedcrafting", "platinum"), "singularity.extendedcrafting.platinum", new int[]{7334639, 7334639}, "forge:ingots/platinum", count, true)});
    }
}

