/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.singularity;

import com.blakebr0.cucumber.util.Localizable;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class Singularity {
    private final ResourceLocation id;
    private final String name;
    private final int[] colors;
    private final String tag;
    private final int ingredientCount;
    private final boolean inUltimateSingularity;
    private Ingredient ingredient;

    public Singularity(ResourceLocation id, String name, int[] colors, Ingredient ingredient, int ingredientCount, boolean inUltimateSingularity) {
        this.id = id;
        this.name = name;
        this.colors = colors;
        this.ingredient = ingredient;
        this.tag = null;
        this.ingredientCount = ingredientCount;
        this.inUltimateSingularity = inUltimateSingularity;
    }

    public Singularity(ResourceLocation id, String name, int[] colors, String tag, int ingredientCount, boolean inUltimateSingularity) {
        this.id = id;
        this.name = name;
        this.colors = colors;
        this.ingredient = Ingredient.field_193370_a;
        this.tag = tag;
        this.ingredientCount = ingredientCount;
        this.inUltimateSingularity = inUltimateSingularity;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getOverlayColor() {
        return this.colors[0];
    }

    public int getUnderlayColor() {
        return this.colors[1];
    }

    public String getTag() {
        return this.tag;
    }

    public Ingredient getIngredient() {
        ITag tag;
        if (this.tag != null && this.ingredient == Ingredient.field_193370_a && (tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation(this.tag))) != null) {
            this.ingredient = Ingredient.func_199805_a((ITag)tag);
        }
        return this.ingredient;
    }

    public int getIngredientCount() {
        return this.ingredientCount;
    }

    public ITextComponent getDisplayName() {
        return Localizable.of((String)this.name).build();
    }

    public boolean isInUltimateSingularity() {
        return this.inUltimateSingularity;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.id);
        buffer.func_180714_a(this.name);
        buffer.func_186875_a(this.colors);
        buffer.writeBoolean(this.tag != null);
        if (this.tag != null) {
            buffer.func_180714_a(this.tag);
        } else {
            this.ingredient.func_199564_a(buffer);
        }
        buffer.func_150787_b(this.ingredientCount);
        buffer.writeBoolean(this.inUltimateSingularity);
    }

    public static Singularity read(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        String name = buffer.func_218666_n();
        int[] colors = buffer.func_186863_b();
        boolean isTagIngredient = buffer.readBoolean();
        String tag = null;
        Ingredient ingredient = Ingredient.field_193370_a;
        if (isTagIngredient) {
            tag = buffer.func_218666_n();
        } else {
            ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        }
        int ingredientCount = buffer.func_150792_a();
        boolean isInUltimateSingularity = buffer.readBoolean();
        if (isTagIngredient) {
            return new Singularity(id, name, colors, tag, ingredientCount, isInUltimateSingularity);
        }
        return new Singularity(id, name, colors, ingredient, ingredientCount, isInUltimateSingularity);
    }
}

