/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.item;

import com.blakebr0.cucumber.iface.IColored;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.singularity.Singularity;
import com.blakebr0.extendedcrafting.singularity.SingularityRegistry;
import com.blakebr0.extendedcrafting.singularity.SingularityUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SingularityItem
extends BaseItem
implements IEnableable,
IColored {
    public SingularityItem(Function<Item.Properties, Item.Properties> properties) {
        super(properties.compose(p -> p.func_208103_a(Rarity.UNCOMMON)));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.isEnabled() && this.func_194125_a(group)) {
            SingularityRegistry.getInstance().getSingularities().forEach(singularity -> items.add((Object)SingularityUtils.getItemForSingularity(singularity)));
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        Singularity singularity = SingularityUtils.getSingularity(stack);
        if (singularity == null) {
            return Localizable.of((String)this.func_77667_c(stack)).args(new Object[]{"NULL"}).build();
        }
        return Localizable.of((String)this.func_77667_c(stack)).args(new Object[]{singularity.getDisplayName()}).build();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        Singularity singularity = SingularityUtils.getSingularity(stack);
        if (singularity != null) {
            String modid = singularity.getId().func_110624_b();
            if (!modid.equals("extendedcrafting")) {
                tooltip.add(ModTooltips.getAddedByTooltip(modid));
            }
            if (flag.func_194127_a()) {
                tooltip.add((ITextComponent)ModTooltips.SINGULARITY_ID.args(new Object[]{singularity.getId()}).color(TextFormatting.DARK_GRAY).build());
            }
        }
    }

    public boolean isEnabled() {
        return (Boolean)ModConfigs.ENABLE_SINGULARITIES.get();
    }

    public int getColor(int i, ItemStack stack) {
        Singularity singularity = SingularityUtils.getSingularity(stack);
        if (singularity == null) {
            return -1;
        }
        return i == 0 ? singularity.getUnderlayColor() : (i == 1 ? singularity.getOverlayColor() : -1);
    }
}

