/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.item;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.compat.crafttweaker.CraftTweakerUtils;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.tileentity.AdvancedTableTileEntity;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import com.blakebr0.extendedcrafting.tileentity.BasicTableTileEntity;
import com.blakebr0.extendedcrafting.tileentity.CraftingCoreTileEntity;
import com.blakebr0.extendedcrafting.tileentity.EliteTableTileEntity;
import com.blakebr0.extendedcrafting.tileentity.EnderCrafterTileEntity;
import com.blakebr0.extendedcrafting.tileentity.UltimateTableTileEntity;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;

public class RecipeMakerItem
extends BaseItem
implements IEnableable {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String NEW_LINE = System.lineSeparator() + "\t";
    private static final char[] KEYS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ123456789".toCharArray();

    public RecipeMakerItem(Function<Item.Properties, Item.Properties> properties) {
        super(properties.compose(p -> p.func_200917_a(1)));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.isEnabled() && this.func_194125_a(group)) {
            ItemStack stack1 = new ItemStack((IItemProvider)this);
            NBTHelper.setBoolean((ItemStack)stack1, (String)"Shapeless", (boolean)false);
            NBTHelper.setString((ItemStack)stack1, (String)"Type", (String)"Datapack");
            ItemStack stack2 = new ItemStack((IItemProvider)this);
            NBTHelper.setBoolean((ItemStack)stack2, (String)"Shapeless", (boolean)false);
            NBTHelper.setString((ItemStack)stack2, (String)"Type", (String)"CraftTweaker");
            items.add((Object)stack1);
            items.add((Object)stack2);
        }
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        World world = context.func_195991_k();
        if (player == null || !player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return ActionResultType.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (RecipeMakerItem.isTable(tile)) {
            if (world.func_201670_d()) {
                String type = NBTHelper.getString((ItemStack)stack, (String)"Type");
                BaseItemStackHandler inventory = ((BaseInventoryTileEntity)tile).getInventory();
                if ("CraftTweaker".equals(type)) {
                    type = tile instanceof EnderCrafterTileEntity ? "EnderCrafting" : "TableCrafting";
                    String string = RecipeMakerItem.isShapeless(stack) ? RecipeMakerItem.makeShapelessCraftTweakerTableRecipe((IItemHandler)inventory, type) : RecipeMakerItem.makeShapedCraftTweakerTableRecipe((IItemHandler)inventory, type);
                    RecipeMakerItem.setClipboard(string);
                } else {
                    String string;
                    type = tile instanceof EnderCrafterTileEntity ? "EnderCrafting" : "TableCrafting";
                    String string2 = string = RecipeMakerItem.isShapeless(stack) ? RecipeMakerItem.makeShapelessDatapackTableRecipe((IItemHandler)inventory, type) : RecipeMakerItem.makeShapedDatapackTableRecipe((IItemHandler)inventory, type);
                    if ("TOO MANY ITEMS".equals(string)) {
                        player.func_145747_a((ITextComponent)Localizable.of((String)"message.extendedcrafting.max_unique_items_exceeded").args(new Object[]{KEYS.length}).build(), Util.field_240973_b_);
                        return ActionResultType.SUCCESS;
                    }
                    RecipeMakerItem.setClipboard(string);
                }
                player.func_145747_a((ITextComponent)Localizable.of((String)"message.extendedcrafting.copied_recipe").build(), Util.field_240973_b_);
                if (((Boolean)ModConfigs.RECIPE_MAKER_USE_NBT.get()).booleanValue() && !ModList.get().isLoaded("crafttweaker")) {
                    player.func_145747_a((ITextComponent)Localizable.of((String)"message.extendedcrafting.nbt_requires_crafttweaker").build(), Util.field_240973_b_);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (tile instanceof CraftingCoreTileEntity) {
            if (world.func_201670_d()) {
                String type = NBTHelper.getString((ItemStack)stack, (String)"Type");
                CraftingCoreTileEntity core = (CraftingCoreTileEntity)tile;
                String string = "CraftTweaker".equals(type) ? RecipeMakerItem.makeCraftTweakerCombinationRecipe(core) : RecipeMakerItem.makeDatapackCombinationRecipe(core);
                RecipeMakerItem.setClipboard(string);
                player.func_145747_a((ITextComponent)Localizable.of((String)"message.extendedcrafting.copied_recipe").build(), Util.field_240973_b_);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (player.func_213453_ef()) {
            ItemStack stack = player.func_184586_b(hand);
            NBTHelper.flipBoolean((ItemStack)stack, (String)"Shapeless");
            if (world.func_201670_d()) {
                player.func_145747_a((ITextComponent)Localizable.of((String)"message.extendedcrafting.changed_mode").args(new Object[]{RecipeMakerItem.getModeString(stack)}).build(), Util.field_240973_b_);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)ModTooltips.TYPE.args(new Object[]{NBTHelper.getString((ItemStack)stack, (String)"Type")}).build());
        tooltip.add((ITextComponent)ModTooltips.MODE.args(new Object[]{RecipeMakerItem.getModeString(stack)}).build());
    }

    public boolean isEnabled() {
        return (Boolean)ModConfigs.ENABLE_RECIPE_MAKER.get();
    }

    private static void setClipboard(String string) {
        Minecraft.func_71410_x().field_195559_v.func_197960_a(string);
    }

    private static String makeShapedCraftTweakerTableRecipe(IItemHandler inventory, String type) {
        StringBuilder string = new StringBuilder();
        UUID uuid = UUID.randomUUID();
        string.append("mods.extendedcrafting.").append(type).append(".addShaped(\"").append(uuid).append("\", ");
        if ("TableCrafting".equals(type)) {
            string.append("0, ");
        }
        string.append("<>, [").append(NEW_LINE);
        int slots = RecipeMakerItem.getGridSlots(inventory);
        int sr = (int)Math.sqrt(slots);
        for (int i = 0; i < slots; ++i) {
            ResourceLocation tagId;
            if (i == 0 || i % sr == 0) {
                string.append("[");
            }
            ItemStack stack = inventory.getStackInSlot(i);
            String item = "";
            if (!stack.func_190926_b() && ((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && (tagId = (ResourceLocation)stack.func_77973_b().getTags().stream().findFirst().orElse(null)) != null) {
                item = "tag:items:" + tagId;
            }
            if (item.isEmpty()) {
                ResourceLocation id = stack.func_77973_b().getRegistryName();
                item = id == null ? "item:minecraft:air" : "item:" + id;
            }
            string.append("<").append(item).append(">");
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_NBT.get()).booleanValue() && !stack.func_190926_b() && stack.func_77942_o() && !item.startsWith("tag") && ModList.get().isLoaded("crafttweaker")) {
                INBT nbt = stack.serializeNBT().func_74781_a("tag");
                String tag = CraftTweakerUtils.writeTag(nbt);
                string.append(".withTag(").append(tag).append(")");
            }
            if ((i + 1) % sr != 0) {
                string.append(", ");
            }
            if (i + 1 != sr && (i + 1) % sr != 0) continue;
            string.append("]");
            if (i + 1 < slots) {
                string.append(", ");
                string.append(NEW_LINE);
                continue;
            }
            string.append(System.lineSeparator());
        }
        string.append("]);");
        return string.toString();
    }

    private static String makeShapelessCraftTweakerTableRecipe(IItemHandler inventory, String type) {
        StringBuilder string = new StringBuilder();
        UUID uuid = UUID.randomUUID();
        string.append("mods.extendedcrafting.").append(type).append(".addShapeless(\"").append(uuid).append("\", ");
        if ("TableCrafting".equals(type)) {
            string.append("0, ");
        }
        string.append("<>, [").append(NEW_LINE);
        ArrayList<Integer> slotsWithItems = new ArrayList<Integer>();
        int slots = RecipeMakerItem.getGridSlots(inventory);
        int lastSlot = 0;
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            slotsWithItems.add(i);
            lastSlot = i;
        }
        Iterator iterator = slotsWithItems.iterator();
        while (iterator.hasNext()) {
            ResourceLocation id;
            int i = (Integer)iterator.next();
            ItemStack stack = inventory.getStackInSlot(i);
            ResourceLocation tagId = stack.func_77973_b().getTags().stream().findFirst().orElse(null);
            String item = (Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get() != false && tagId != null ? "tag:items:" + tagId : ((id = stack.func_77973_b().getRegistryName()) == null ? "item:minecraft:air" : "item:" + id);
            string.append("<").append(item).append(">");
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_NBT.get()).booleanValue() && !stack.func_190926_b() && stack.func_77942_o() && !item.startsWith("tag") && ModList.get().isLoaded("crafttweaker")) {
                INBT nbt = stack.serializeNBT().func_74781_a("tag");
                String tag = CraftTweakerUtils.writeTag(nbt);
                string.append(".withTag(").append(tag).append(")");
            }
            if (i == lastSlot) continue;
            string.append(", ");
        }
        string.append(System.lineSeparator()).append("]);");
        return string.toString();
    }

    private static String makeCraftTweakerCombinationRecipe(CraftingCoreTileEntity tile) {
        StringBuilder string = new StringBuilder();
        UUID uuid = UUID.randomUUID();
        string.append("mods.extendedcrafting.CombinationCrafting.addRecipe(\"").append(uuid).append("\", <>, 100000, [").append(NEW_LINE);
        ResourceLocation inputId = tile.getInventory().getStackInSlot(0).func_77973_b().getRegistryName();
        String input = "item:minecraft:air";
        if (inputId != null) {
            input = "item:" + inputId;
        }
        string.append("<").append(input).append(">, ");
        ItemStack[] stacks = (ItemStack[])tile.getPedestalsWithItems().values().stream().filter(s -> !s.func_190926_b()).toArray(ItemStack[]::new);
        for (int i = 0; i < stacks.length; ++i) {
            String item;
            ItemStack stack = stacks[i];
            ResourceLocation tagId = stack.func_77973_b().getTags().stream().findFirst().orElse(null);
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && tagId != null) {
                item = "tag:items:" + tagId;
            } else {
                ResourceLocation id = stack.func_77973_b().getRegistryName();
                String string2 = item = id == null ? "item:minecraft:air" : "item:" + id;
            }
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_NBT.get()).booleanValue() && !stack.func_190926_b() && stack.func_77942_o() && !item.startsWith("tag") && ModList.get().isLoaded("crafttweaker")) {
                INBT nbt = stack.serializeNBT().func_74781_a("tag");
                String tag = CraftTweakerUtils.writeTag(nbt);
                string.append(".withTag(").append(tag).append(")");
            }
            string.append("<").append(item).append(">");
            if (i == stacks.length - 1) continue;
            string.append(", ");
        }
        string.append(System.lineSeparator()).append("]);");
        return string.toString();
    }

    private static String makeShapedDatapackTableRecipe(IItemHandler inventory, String type) {
        JsonObject object = new JsonObject();
        object.addProperty("type", "TableCrafting".equals(type) ? "extendedcrafting:shaped_table" : "extendedcrafting:shaped_ender_crafter");
        LinkedHashMap<Object, Character> keysMap = new LinkedHashMap<Object, Character>();
        int slots = RecipeMakerItem.getGridSlots(inventory);
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b() || keysMap.keySet().stream().anyMatch(ing -> ing.test(stack))) continue;
            ResourceLocation tagId = stack.func_77973_b().getTags().stream().findFirst().orElse(null);
            ITag tag = tagId == null ? null : ItemTags.func_199903_a().func_199910_a(tagId);
            char key = KEYS[keysMap.size()];
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && tag != null) {
                keysMap.put(Ingredient.func_199805_a((ITag)tag), Character.valueOf(key));
            } else if (((Boolean)ModConfigs.RECIPE_MAKER_USE_NBT.get()).booleanValue() && stack.func_77942_o()) {
                keysMap.put((Object)new NBTIngredient(stack), Character.valueOf(key));
            } else {
                keysMap.put(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}), Character.valueOf(key));
            }
            if (keysMap.size() < KEYS.length) continue;
            return "TOO MANY ITEMS";
        }
        JsonArray pattern = new JsonArray();
        int size = (int)Math.sqrt(slots);
        Set keys = keysMap.entrySet();
        for (int i = 0; i < size; ++i) {
            StringBuilder line = new StringBuilder();
            for (int j = 0; j < size; ++j) {
                ItemStack stack = inventory.getStackInSlot(i * size + j);
                Map.Entry entry = keys.stream().filter(e -> ((Ingredient)e.getKey()).test(stack)).findFirst().orElse(null);
                if (entry == null) {
                    line.append(" ");
                    continue;
                }
                line.append(entry.getValue());
            }
            pattern.add(line.toString());
        }
        object.add("pattern", (JsonElement)pattern);
        JsonObject key = new JsonObject();
        for (Map.Entry entry : keys) {
            key.add(((Character)entry.getValue()).toString(), ((Ingredient)entry.getKey()).func_200304_c());
        }
        object.add("key", (JsonElement)key);
        JsonObject result = new JsonObject();
        result.addProperty("item", "");
        object.add("result", (JsonElement)result);
        return GSON.toJson((JsonElement)object);
    }

    private static String makeShapelessDatapackTableRecipe(IItemHandler inventory, String type) {
        JsonObject object = new JsonObject();
        object.addProperty("type", "TableCrafting".equals(type) ? "extendedcrafting:shapeless_table" : "extendedcrafting:shapeless_ender_crafter");
        JsonArray ingredients = new JsonArray();
        int slots = RecipeMakerItem.getGridSlots(inventory);
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ResourceLocation tagId = stack.func_77973_b().getTags().stream().findFirst().orElse(null);
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && tagId != null) {
                JsonObject tag = new JsonObject();
                tag.addProperty("tag", tagId.toString());
                ingredients.add((JsonElement)tag);
                continue;
            }
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_NBT.get()).booleanValue() && stack.func_77942_o()) {
                ingredients.add(new NBTIngredient(stack).func_200304_c());
                continue;
            }
            ingredients.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}).func_200304_c());
        }
        object.add("ingredients", (JsonElement)ingredients);
        JsonObject result = new JsonObject();
        result.addProperty("item", "");
        object.add("result", (JsonElement)result);
        return GSON.toJson((JsonElement)object);
    }

    private static String makeDatapackCombinationRecipe(CraftingCoreTileEntity core) {
        ItemStack[] stacks;
        JsonObject object = new JsonObject();
        object.addProperty("type", "extendedcrafting:combination");
        object.addProperty("powerCost", (Number)100000);
        ItemStack input = core.getInventory().getStackInSlot(0);
        object.add("input", Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}).func_200304_c());
        JsonArray ingredients = new JsonArray();
        for (ItemStack stack : stacks = (ItemStack[])core.getPedestalsWithItems().values().stream().filter(s -> !s.func_190926_b()).toArray(ItemStack[]::new)) {
            ResourceLocation tagId = stack.func_77973_b().getTags().stream().findFirst().orElse(null);
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && tagId != null) {
                JsonObject tag = new JsonObject();
                tag.addProperty("tag", tagId.toString());
                ingredients.add((JsonElement)tag);
                continue;
            }
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_NBT.get()).booleanValue() && stack.func_77942_o()) {
                ingredients.add(new NBTIngredient(stack).func_200304_c());
                continue;
            }
            ingredients.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}).func_200304_c());
        }
        object.add("ingredients", (JsonElement)ingredients);
        JsonObject result = new JsonObject();
        result.addProperty("item", "");
        object.add("result", (JsonElement)result);
        return GSON.toJson((JsonElement)object);
    }

    private static boolean isTable(TileEntity tile) {
        return tile instanceof BasicTableTileEntity || tile instanceof AdvancedTableTileEntity || tile instanceof EliteTableTileEntity || tile instanceof UltimateTableTileEntity || tile instanceof AutoTableTileEntity || tile instanceof EnderCrafterTileEntity;
    }

    private static String getModeString(ItemStack stack) {
        return RecipeMakerItem.isShapeless(stack) ? "Shapeless" : "Shaped";
    }

    private static boolean isShapeless(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)"Shapeless");
    }

    private static int getGridSlots(IItemHandler inventory) {
        int slots = inventory.getSlots();
        if (slots >= 81) {
            return 81;
        }
        if (slots >= 49) {
            return 49;
        }
        if (slots >= 25) {
            return 25;
        }
        return 9;
    }

    private static class NBTIngredient
    extends net.minecraftforge.common.crafting.NBTIngredient {
        public NBTIngredient(ItemStack stack) {
            super(stack);
        }
    }
}

