/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.init;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.item.BaseShinyItem;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.item.HandheldTableItem;
import com.blakebr0.extendedcrafting.item.RecipeMakerItem;
import com.blakebr0.extendedcrafting.item.SingularityItem;
import com.blakebr0.extendedcrafting.item.UltimateSingularityItem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModItems {
    public static final List<Supplier<Item>> BLOCK_ENTRIES = new ArrayList<Supplier<Item>>();
    public static final Map<RegistryObject<Item>, Supplier<Item>> ENTRIES = new LinkedHashMap<RegistryObject<Item>, Supplier<Item>>();
    public static final RegistryObject<Item> LUMINESSENCE = ModItems.register("luminessence");
    public static final RegistryObject<Item> BLACK_IRON_INGOT = ModItems.register("black_iron_ingot");
    public static final RegistryObject<Item> REDSTONE_INGOT = ModItems.register("redstone_ingot");
    public static final RegistryObject<Item> ENDER_INGOT = ModItems.register("ender_ingot");
    public static final RegistryObject<Item> ENHANCED_ENDER_INGOT = ModItems.register("enhanced_ender_ingot", () -> new BaseItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP).func_208103_a(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> CRYSTALTINE_INGOT = ModItems.register("crystaltine_ingot", () -> new BaseItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP).func_208103_a(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> THE_ULTIMATE_INGOT = ModItems.register("the_ultimate_ingot", () -> new BaseItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP).func_208103_a(Rarity.EPIC)));
    public static final RegistryObject<Item> BLACK_IRON_NUGGET = ModItems.register("black_iron_nugget");
    public static final RegistryObject<Item> REDSTONE_NUGGET = ModItems.register("redstone_nugget");
    public static final RegistryObject<Item> ENDER_NUGGET = ModItems.register("ender_nugget");
    public static final RegistryObject<Item> ENHANCED_ENDER_NUGGET = ModItems.register("enhanced_ender_nugget", () -> new BaseItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP).func_208103_a(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> CRYSTALTINE_NUGGET = ModItems.register("crystaltine_nugget", () -> new BaseItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP).func_208103_a(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> THE_ULTIMATE_NUGGET = ModItems.register("the_ultimate_nugget", () -> new BaseItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP).func_208103_a(Rarity.EPIC)));
    public static final RegistryObject<Item> BLACK_IRON_SLATE = ModItems.register("black_iron_slate");
    public static final RegistryObject<Item> BASIC_CATALYST = ModItems.register("basic_catalyst");
    public static final RegistryObject<Item> ADVANCED_CATALYST = ModItems.register("advanced_catalyst");
    public static final RegistryObject<Item> ELITE_CATALYST = ModItems.register("elite_catalyst");
    public static final RegistryObject<Item> ULTIMATE_CATALYST = ModItems.register("ultimate_catalyst");
    public static final RegistryObject<Item> REDSTONE_CATALYST = ModItems.register("redstone_catalyst");
    public static final RegistryObject<Item> ENDER_CATALYST = ModItems.register("ender_catalyst");
    public static final RegistryObject<Item> ENHANCED_ENDER_CATALYST = ModItems.register("enhanced_ender_catalyst", () -> new BaseItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP).func_208103_a(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> CRYSTALTINE_CATALYST = ModItems.register("crystaltine_catalyst", () -> new BaseItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP).func_208103_a(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> THE_ULTIMATE_CATALYST = ModItems.register("the_ultimate_catalyst", () -> new BaseItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP).func_208103_a(Rarity.EPIC)));
    public static final RegistryObject<Item> BASIC_COMPONENT = ModItems.register("basic_component");
    public static final RegistryObject<Item> ADVANCED_COMPONENT = ModItems.register("advanced_component");
    public static final RegistryObject<Item> ELITE_COMPONENT = ModItems.register("elite_component");
    public static final RegistryObject<Item> ULTIMATE_COMPONENT = ModItems.register("ultimate_component");
    public static final RegistryObject<Item> REDSTONE_COMPONENT = ModItems.register("redstone_component");
    public static final RegistryObject<Item> ENDER_COMPONENT = ModItems.register("ender_component");
    public static final RegistryObject<Item> ENHANCED_ENDER_COMPONENT = ModItems.register("enhanced_ender_component", () -> new BaseItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP).func_208103_a(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> CRYSTALTINE_COMPONENT = ModItems.register("crystaltine_component", () -> new BaseItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP).func_208103_a(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> THE_ULTIMATE_COMPONENT = ModItems.register("the_ultimate_component", () -> new BaseItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP).func_208103_a(Rarity.EPIC)));
    public static final RegistryObject<Item> ENDER_STAR = ModItems.register("ender_star", () -> new BaseShinyItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP).func_208103_a(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> HANDHELD_TABLE = ModItems.register("handheld_table", () -> new HandheldTableItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP)));
    public static final RegistryObject<Item> RECIPE_MAKER = ModItems.register("recipe_maker", () -> new RecipeMakerItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP)));
    public static final RegistryObject<Item> SINGULARITY = ModItems.register("singularity", () -> new SingularityItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP)));
    public static final RegistryObject<Item> ULTIMATE_SINGULARITY = ModItems.register("ultimate_singularity", () -> new UltimateSingularityItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP)));

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        BLOCK_ENTRIES.stream().map(Supplier::get).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        ENTRIES.forEach((reg, item) -> {
            registry.register((IForgeRegistryEntry)item.get());
            reg.updateReference(registry);
        });
    }

    private static RegistryObject<Item> register(String name) {
        return ModItems.register(name, () -> new BaseItem(p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP)));
    }

    private static RegistryObject<Item> register(String name, Supplier<Item> item) {
        ResourceLocation loc = new ResourceLocation("extendedcrafting", name);
        RegistryObject reg = RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.ITEMS);
        ENTRIES.put((RegistryObject<Item>)reg, () -> (Item)((Item)item.get()).setRegistryName(loc));
        return reg;
    }
}

