/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.init;

import com.blakebr0.extendedcrafting.client.screen.AdvancedAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.AdvancedTableScreen;
import com.blakebr0.extendedcrafting.client.screen.BasicAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.BasicTableScreen;
import com.blakebr0.extendedcrafting.client.screen.CompressorScreen;
import com.blakebr0.extendedcrafting.client.screen.CraftingCoreScreen;
import com.blakebr0.extendedcrafting.client.screen.EliteAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.EliteTableScreen;
import com.blakebr0.extendedcrafting.client.screen.EnderCrafterScreen;
import com.blakebr0.extendedcrafting.client.screen.UltimateAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.UltimateTableScreen;
import com.blakebr0.extendedcrafting.container.AdvancedAutoTableContainer;
import com.blakebr0.extendedcrafting.container.AdvancedTableContainer;
import com.blakebr0.extendedcrafting.container.BasicAutoTableContainer;
import com.blakebr0.extendedcrafting.container.BasicTableContainer;
import com.blakebr0.extendedcrafting.container.CompressorContainer;
import com.blakebr0.extendedcrafting.container.CraftingCoreContainer;
import com.blakebr0.extendedcrafting.container.EliteAutoTableContainer;
import com.blakebr0.extendedcrafting.container.EliteTableContainer;
import com.blakebr0.extendedcrafting.container.EnderCrafterContainer;
import com.blakebr0.extendedcrafting.container.UltimateAutoTableContainer;
import com.blakebr0.extendedcrafting.container.UltimateTableContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class ModContainerTypes {
    public static final List<Supplier<? extends ContainerType<?>>> ENTRIES = new ArrayList();
    public static final RegistryObject<ContainerType<CraftingCoreContainer>> CRAFTING_CORE = ModContainerTypes.register("crafting_core", () -> new ContainerType((ContainerType.IFactory)((IContainerFactory)CraftingCoreContainer::create)));
    public static final RegistryObject<ContainerType<BasicTableContainer>> BASIC_TABLE = ModContainerTypes.register("basic_table", () -> new ContainerType(BasicTableContainer::create));
    public static final RegistryObject<ContainerType<AdvancedTableContainer>> ADVANCED_TABLE = ModContainerTypes.register("advanced_table", () -> new ContainerType(AdvancedTableContainer::create));
    public static final RegistryObject<ContainerType<EliteTableContainer>> ELITE_TABLE = ModContainerTypes.register("elite_table", () -> new ContainerType(EliteTableContainer::create));
    public static final RegistryObject<ContainerType<UltimateTableContainer>> ULTIMATE_TABLE = ModContainerTypes.register("ultimate_table", () -> new ContainerType(UltimateTableContainer::create));
    public static final RegistryObject<ContainerType<BasicAutoTableContainer>> BASIC_AUTO_TABLE = ModContainerTypes.register("basic_auto_table", () -> new ContainerType((ContainerType.IFactory)((IContainerFactory)BasicAutoTableContainer::create)));
    public static final RegistryObject<ContainerType<AdvancedAutoTableContainer>> ADVANCED_AUTO_TABLE = ModContainerTypes.register("advanced_auto_table", () -> new ContainerType((ContainerType.IFactory)((IContainerFactory)AdvancedAutoTableContainer::create)));
    public static final RegistryObject<ContainerType<EliteAutoTableContainer>> ELITE_AUTO_TABLE = ModContainerTypes.register("elite_auto_table", () -> new ContainerType((ContainerType.IFactory)((IContainerFactory)EliteAutoTableContainer::create)));
    public static final RegistryObject<ContainerType<UltimateAutoTableContainer>> ULTIMATE_AUTO_TABLE = ModContainerTypes.register("ultimate_auto_table", () -> new ContainerType((ContainerType.IFactory)((IContainerFactory)UltimateAutoTableContainer::create)));
    public static final RegistryObject<ContainerType<CompressorContainer>> COMPRESSOR = ModContainerTypes.register("compressor", () -> new ContainerType((ContainerType.IFactory)((IContainerFactory)CompressorContainer::create)));
    public static final RegistryObject<ContainerType<EnderCrafterContainer>> ENDER_CRAFTER = ModContainerTypes.register("ender_crafter", () -> new ContainerType((ContainerType.IFactory)((IContainerFactory)EnderCrafterContainer::create)));

    @SubscribeEvent
    public void onRegisterContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        ENTRIES.stream().map(Supplier::get).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onClientSetup() {
        CRAFTING_CORE.ifPresent(container -> ScreenManager.func_216911_a((ContainerType)container, CraftingCoreScreen::new));
        BASIC_TABLE.ifPresent(container -> ScreenManager.func_216911_a((ContainerType)container, BasicTableScreen::new));
        ADVANCED_TABLE.ifPresent(container -> ScreenManager.func_216911_a((ContainerType)container, AdvancedTableScreen::new));
        ELITE_TABLE.ifPresent(container -> ScreenManager.func_216911_a((ContainerType)container, EliteTableScreen::new));
        ULTIMATE_TABLE.ifPresent(container -> ScreenManager.func_216911_a((ContainerType)container, UltimateTableScreen::new));
        BASIC_AUTO_TABLE.ifPresent(container -> ScreenManager.func_216911_a((ContainerType)container, BasicAutoTableScreen::new));
        ADVANCED_AUTO_TABLE.ifPresent(container -> ScreenManager.func_216911_a((ContainerType)container, AdvancedAutoTableScreen::new));
        ELITE_AUTO_TABLE.ifPresent(container -> ScreenManager.func_216911_a((ContainerType)container, EliteAutoTableScreen::new));
        ULTIMATE_AUTO_TABLE.ifPresent(container -> ScreenManager.func_216911_a((ContainerType)container, UltimateAutoTableScreen::new));
        COMPRESSOR.ifPresent(container -> ScreenManager.func_216911_a((ContainerType)container, CompressorScreen::new));
        ENDER_CRAFTER.ifPresent(container -> ScreenManager.func_216911_a((ContainerType)container, EnderCrafterScreen::new));
    }

    private static <T extends ContainerType<?>> RegistryObject<T> register(String name, Supplier<? extends ContainerType<?>> container) {
        ResourceLocation loc = new ResourceLocation("extendedcrafting", name);
        ENTRIES.add(() -> (ContainerType)((ContainerType)container.get()).setRegistryName(loc));
        return RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.CONTAINERS);
    }
}

