/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.init;

import com.blakebr0.cucumber.block.BaseBlock;
import com.blakebr0.cucumber.item.BaseBlockItem;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.block.AdvancedAutoTableBlock;
import com.blakebr0.extendedcrafting.block.AdvancedTableBlock;
import com.blakebr0.extendedcrafting.block.BasicAutoTableBlock;
import com.blakebr0.extendedcrafting.block.BasicTableBlock;
import com.blakebr0.extendedcrafting.block.CompressorBlock;
import com.blakebr0.extendedcrafting.block.CraftingCoreBlock;
import com.blakebr0.extendedcrafting.block.EliteAutoTableBlock;
import com.blakebr0.extendedcrafting.block.EliteTableBlock;
import com.blakebr0.extendedcrafting.block.EnderAlternatorBlock;
import com.blakebr0.extendedcrafting.block.EnderCrafterBlock;
import com.blakebr0.extendedcrafting.block.FrameBlock;
import com.blakebr0.extendedcrafting.block.PedestalBlock;
import com.blakebr0.extendedcrafting.block.UltimateAutoTableBlock;
import com.blakebr0.extendedcrafting.block.UltimateTableBlock;
import com.blakebr0.extendedcrafting.init.ModItems;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModBlocks {
    public static final Map<RegistryObject<Block>, Supplier<Block>> ENTRIES = new LinkedHashMap<RegistryObject<Block>, Supplier<Block>>();
    public static final RegistryObject<Block> LUMINESSENCE_BLOCK = ModBlocks.register("luminessence_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 5.0f, 10.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> BLACK_IRON_BLOCK = ModBlocks.register("black_iron_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 10.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> REDSTONE_INGOT_BLOCK = ModBlocks.register("redstone_ingot_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 10.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> ENDER_INGOT_BLOCK = ModBlocks.register("ender_ingot_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 10.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> ENHANCED_ENDER_INGOT_BLOCK = ModBlocks.register("enhanced_ender_ingot_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 10.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> CRYSTALTINE_BLOCK = ModBlocks.register("crystaltine_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 10.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> THE_ULTIMATE_BLOCK = ModBlocks.register("the_ultimate_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 10.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> NETHER_STAR_BLOCK = ModBlocks.register("nether_star_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 10.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> ENDER_STAR_BLOCK = ModBlocks.register("ender_star_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 10.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> FRAME = ModBlocks.register("frame", FrameBlock::new);
    public static final RegistryObject<Block> PEDESTAL = ModBlocks.register("pedestal", PedestalBlock::new);
    public static final RegistryObject<Block> CRAFTING_CORE = ModBlocks.register("crafting_core", CraftingCoreBlock::new);
    public static final RegistryObject<Block> BASIC_TABLE = ModBlocks.register("basic_table", BasicTableBlock::new);
    public static final RegistryObject<Block> ADVANCED_TABLE = ModBlocks.register("advanced_table", AdvancedTableBlock::new);
    public static final RegistryObject<Block> ELITE_TABLE = ModBlocks.register("elite_table", EliteTableBlock::new);
    public static final RegistryObject<Block> ULTIMATE_TABLE = ModBlocks.register("ultimate_table", UltimateTableBlock::new);
    public static final RegistryObject<Block> BASIC_AUTO_TABLE = ModBlocks.register("basic_auto_table", BasicAutoTableBlock::new);
    public static final RegistryObject<Block> ADVANCED_AUTO_TABLE = ModBlocks.register("advanced_auto_table", AdvancedAutoTableBlock::new);
    public static final RegistryObject<Block> ELITE_AUTO_TABLE = ModBlocks.register("elite_auto_table", EliteAutoTableBlock::new);
    public static final RegistryObject<Block> ULTIMATE_AUTO_TABLE = ModBlocks.register("ultimate_auto_table", UltimateAutoTableBlock::new);
    public static final RegistryObject<Block> COMPRESSOR = ModBlocks.register("compressor", CompressorBlock::new);
    public static final RegistryObject<Block> ENDER_ALTERNATOR = ModBlocks.register("ender_alternator", EnderAlternatorBlock::new);
    public static final RegistryObject<Block> ENDER_CRAFTER = ModBlocks.register("ender_crafter", EnderCrafterBlock::new);

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        ENTRIES.forEach((reg, block) -> {
            registry.register((IForgeRegistryEntry)block.get());
            reg.updateReference(registry);
        });
    }

    private static RegistryObject<Block> register(String name, Supplier<Block> block) {
        return ModBlocks.register(name, block, b -> () -> new BaseBlockItem((Block)b.get(), p -> p.func_200916_a(ExtendedCrafting.ITEM_GROUP)));
    }

    private static RegistryObject<Block> register(String name, Supplier<Block> block, Function<RegistryObject<Block>, Supplier<? extends BlockItem>> item) {
        ResourceLocation loc = new ResourceLocation("extendedcrafting", name);
        RegistryObject reg = RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.BLOCKS);
        ENTRIES.put((RegistryObject<Block>)reg, () -> (Block)((Block)block.get()).setRegistryName(loc));
        ModItems.BLOCK_ENTRIES.add(() -> (Item)((BlockItem)((Supplier)item.apply(reg)).get()).setRegistryName(loc));
        return reg;
    }
}

