/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.extendedcrafting.api.crafting.IEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapelessEnderCrafterRecipe
implements ISpecialRecipe,
IEnderCrafterRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int craftingTime;

    public ShapelessEnderCrafterRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, ItemStack output) {
        this(recipeId, inputs, output, (Integer)ModConfigs.ENDER_CRAFTER_TIME_REQUIRED.get());
    }

    public ShapelessEnderCrafterRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, ItemStack output, int craftingTime) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.output = output;
        this.craftingTime = craftingTime;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.SHAPELESS_ENDER_CRAFTER;
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.ENDER_CRAFTER;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.inputs.size();
    }

    public ItemStack getCraftingResult(IItemHandler inventory) {
        return this.output.func_77946_l();
    }

    public boolean matches(IItemHandler inventory) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int matched = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            inputs.add(stack);
            ++matched;
        }
        return matched == this.inputs.size() && RecipeMatcher.findMatches(inputs, this.inputs) != null;
    }

    @Override
    public int getCraftingTime() {
        return this.craftingTime;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapelessEnderCrafterRecipe> {
        public ShapelessEnderCrafterRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList inputs = NonNullList.func_191196_a();
            JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.func_199802_a((JsonElement)ingredients.get(i)));
            }
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            int craftingTime = JSONUtils.func_151208_a((JsonObject)json, (String)"craftingTime", (int)0);
            return new ShapelessEnderCrafterRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, craftingTime);
        }

        public ShapelessEnderCrafterRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int size = buffer.func_150792_a();
            NonNullList inputs = NonNullList.func_191197_a((int)size, (Object)Ingredient.field_193370_a);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack output = buffer.func_150791_c();
            int craftingTime = buffer.func_150792_a();
            return new ShapelessEnderCrafterRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, craftingTime);
        }

        public void toNetwork(PacketBuffer buffer, ShapelessEnderCrafterRecipe recipe) {
            buffer.func_150787_b(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.output);
            buffer.func_150787_b(recipe.craftingTime);
        }
    }
}

