/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.extendedcrafting.api.crafting.IEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapedEnderCrafterRecipe
implements ISpecialRecipe,
IEnderCrafterRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int width;
    private final int height;
    private final int craftingTime;

    public ShapedEnderCrafterRecipe(ResourceLocation recipeId, int width, int height, NonNullList<Ingredient> inputs, ItemStack output) {
        this(recipeId, width, height, inputs, output, (Integer)ModConfigs.ENDER_CRAFTER_TIME_REQUIRED.get());
    }

    public ShapedEnderCrafterRecipe(ResourceLocation recipeId, int width, int height, NonNullList<Ingredient> inputs, ItemStack output, int craftingTime) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.output = output;
        this.width = width;
        this.height = height;
        this.craftingTime = craftingTime;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack getCraftingResult(IItemHandler inventory) {
        return this.output.func_77946_l();
    }

    public boolean matches(IItemHandler inventory) {
        int size = (int)Math.sqrt(inventory.getSlots());
        for (int i = 0; i <= size - this.width; ++i) {
            for (int j = 0; j <= size - this.height; ++j) {
                if (this.checkMatch(inventory, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.SHAPED_ENDER_CRAFTER;
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.ENDER_CRAFTER;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    @Override
    public int getCraftingTime() {
        return this.craftingTime;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private boolean checkMatch(IItemHandler inventory, int x, int y, boolean mirror) {
        int size = (int)Math.sqrt(inventory.getSlots());
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int k = i - x;
                int l = j - y;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = mirror ? (Ingredient)this.inputs.get(this.width - k - 1 + l * this.width) : (Ingredient)this.inputs.get(k + l * this.width);
                }
                if (ingredient.test(inventory.getStackInSlot(i + j * size))) continue;
                return false;
            }
        }
        return true;
    }

    private static String[] patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        for (int i = 0; i < astring.length; ++i) {
            String s = JSONUtils.func_151206_a((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapedEnderCrafterRecipe> {
        public ShapedEnderCrafterRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Map map = ShapedRecipe.func_192408_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.func_194134_a((String[])ShapedEnderCrafterRecipe.patternFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList inputs = ShapedRecipe.func_192402_a((String[])pattern, (Map)map, (int)width, (int)height);
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            int craftingTime = JSONUtils.func_151208_a((JsonObject)json, (String)"craftingTime", (int)((Integer)ModConfigs.ENDER_CRAFTER_TIME_REQUIRED.get()));
            return new ShapedEnderCrafterRecipe(recipeId, width, height, (NonNullList<Ingredient>)inputs, output, craftingTime);
        }

        public ShapedEnderCrafterRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int width = buffer.func_150792_a();
            int height = buffer.func_150792_a();
            NonNullList inputs = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack output = buffer.func_150791_c();
            int craftingTime = buffer.func_150792_a();
            return new ShapedEnderCrafterRecipe(recipeId, width, height, (NonNullList<Ingredient>)inputs, output, craftingTime);
        }

        public void toNetwork(PacketBuffer buffer, ShapedEnderCrafterRecipe recipe) {
            buffer.func_150787_b(recipe.width);
            buffer.func_150787_b(recipe.height);
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.output);
            buffer.func_150787_b(recipe.craftingTime);
        }
    }
}

