/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.extendedcrafting.api.crafting.ICompressorRecipe;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CompressorRecipe
implements ISpecialRecipe,
ICompressorRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int inputCount;
    private final Ingredient catalyst;
    private final int powerCost;
    private final int powerRate;

    public CompressorRecipe(ResourceLocation recipeId, Ingredient input, ItemStack output, int inputCount, Ingredient catalyst, int powerCost) {
        this(recipeId, input, output, inputCount, catalyst, powerCost, (Integer)ModConfigs.COMPRESSOR_POWER_RATE.get());
    }

    public CompressorRecipe(ResourceLocation recipeId, Ingredient input, ItemStack output, int inputCount, Ingredient catalyst, int powerCost, int powerRate) {
        this.recipeId = recipeId;
        this.inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{input});
        this.output = output;
        this.inputCount = inputCount;
        this.catalyst = catalyst;
        this.powerCost = powerCost;
        this.powerRate = powerRate;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.COMPRESSOR;
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.COMPRESSOR;
    }

    public ItemStack getCraftingResult(IItemHandler inventory) {
        return this.output.func_77946_l();
    }

    public boolean matches(IItemHandler inventory, int startIndex, int endIndex) {
        ItemStack input = inventory.getStackInSlot(0);
        ItemStack catalyst = inventory.getStackInSlot(1);
        return ((Ingredient)this.inputs.get(0)).test(input) && this.catalyst.test(catalyst);
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    @Override
    public int getPowerCost() {
        return this.powerCost;
    }

    @Override
    public int getPowerRate() {
        return this.powerRate;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CompressorRecipe> {
        public CompressorRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("ingredient"));
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            int inputCount = JSONUtils.func_151208_a((JsonObject)json, (String)"inputCount", (int)10000);
            Ingredient catalyst = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"catalyst"));
            int powerCost = JSONUtils.func_151203_m((JsonObject)json, (String)"powerCost");
            int powerRate = JSONUtils.func_151208_a((JsonObject)json, (String)"powerRate", (int)((Integer)ModConfigs.COMPRESSOR_POWER_RATE.get()));
            return new CompressorRecipe(recipeId, input, output, inputCount, catalyst, powerCost, powerRate);
        }

        public CompressorRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack output = buffer.func_150791_c();
            int inputCount = buffer.readInt();
            Ingredient catalyst = Ingredient.func_199566_b((PacketBuffer)buffer);
            int powerCost = buffer.readInt();
            int powerRate = buffer.readInt();
            return new CompressorRecipe(recipeId, input, output, inputCount, catalyst, powerCost, powerRate);
        }

        public void toNetwork(PacketBuffer buffer, CompressorRecipe recipe) {
            ((Ingredient)recipe.inputs.get(0)).func_199564_a(buffer);
            buffer.func_150788_a(recipe.output);
            buffer.writeInt(recipe.inputCount);
            recipe.catalyst.func_199564_a(buffer);
            buffer.writeInt(recipe.powerCost);
            buffer.writeInt(recipe.powerRate);
        }
    }
}

