/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.extendedcrafting.api.crafting.ICombinationRecipe;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CombinationRecipe
implements ISpecialRecipe,
ICombinationRecipe {
    private final ResourceLocation recipeId;
    private final ItemStack output;
    private final NonNullList<Ingredient> ingredients;
    private final int powerCost;
    private final int powerRate;
    private final List<ITextComponent> inputsList;

    public CombinationRecipe(ResourceLocation recipeId, NonNullList<Ingredient> ingredients, ItemStack output, int powerCost) {
        this(recipeId, ingredients, output, powerCost, (Integer)ModConfigs.CRAFTING_CORE_POWER_RATE.get());
    }

    public CombinationRecipe(ResourceLocation recipeId, NonNullList<Ingredient> ingredients, ItemStack output, int powerCost, int powerRate) {
        this.recipeId = recipeId;
        this.ingredients = ingredients;
        this.output = output;
        this.powerCost = powerCost;
        this.powerRate = powerRate;
        this.inputsList = new ArrayList<ITextComponent>();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.COMBINATION;
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.COMBINATION;
    }

    public ItemStack getCraftingResult(IItemHandler inventory) {
        return this.output.func_77946_l();
    }

    public boolean matches(IItemHandler inventory) {
        ItemStack input = inventory.getStackInSlot(0);
        return ((Ingredient)this.ingredients.get(0)).test(input) && super.matches(inventory);
    }

    @Override
    public int getPowerCost() {
        return this.powerCost;
    }

    @Override
    public int getPowerRate() {
        return this.powerRate;
    }

    @Override
    public List<ITextComponent> getInputsList() {
        return this.inputsList;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CombinationRecipe> {
        public CombinationRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList inputs = NonNullList.func_191196_a();
            Ingredient input = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
            inputs.add((Object)input);
            JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredients.get(i));
                inputs.add((Object)ingredient);
            }
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            if (!json.has("powerCost")) {
                throw new JsonSyntaxException("Missing powerCost for combination crafting recipe");
            }
            int powerCost = JSONUtils.func_151203_m((JsonObject)json, (String)"powerCost");
            int powerRate = JSONUtils.func_151208_a((JsonObject)json, (String)"powerRate", (int)((Integer)ModConfigs.CRAFTING_CORE_POWER_RATE.get()));
            return new CombinationRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, powerCost, powerRate);
        }

        public CombinationRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int size = buffer.func_150792_a();
            NonNullList inputs = NonNullList.func_191197_a((int)size, (Object)Ingredient.field_193370_a);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack output = buffer.func_150791_c();
            int powerCost = buffer.func_150792_a();
            int powerRate = buffer.func_150792_a();
            return new CombinationRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, powerCost, powerRate);
        }

        public void toNetwork(PacketBuffer buffer, CombinationRecipe recipe) {
            buffer.func_150787_b(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.output);
            buffer.func_150787_b(recipe.powerCost);
            buffer.func_150787_b(recipe.powerRate);
        }
    }
}

