/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.table;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.compat.jei.JeiCompat;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedTableRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessTableRecipe;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class AdvancedTableCategory
implements IRecipeCategory<ITableRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("extendedcrafting", "advanced_crafting");
    private static final ResourceLocation TEXTURE = new ResourceLocation("extendedcrafting", "textures/gui/jei/advanced_crafting.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable required;
    private final IDrawable shapeless;

    public AdvancedTableCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 150, 90);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.ADVANCED_TABLE.get()));
        this.required = helper.createDrawable(JeiCompat.ICONS, 0, 0, 15, 15);
        this.shapeless = helper.createDrawable(JeiCompat.ICONS, 17, 0, 19, 15);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends ITableRecipe> getRecipeClass() {
        return ITableRecipe.class;
    }

    public String getTitle() {
        return Localizable.of((String)"jei.category.extendedcrafting.advanced_crafting").buildString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ITableRecipe recipe, MatrixStack stack, double mouseX, double mouseY) {
        stack.func_227860_a_();
        stack.func_227862_a_(0.5f, 0.5f, 0.5f);
        boolean shapeless = recipe instanceof ShapelessTableRecipe;
        if (recipe.hasRequiredTier()) {
            this.required.draw(stack, shapeless ? 265 : 285, 0);
        }
        if (shapeless) {
            this.shapeless.draw(stack, 285, 0);
        }
        stack.func_227865_b_();
    }

    public List<ITextComponent> getTooltipStrings(ITableRecipe recipe, double mouseX, double mouseY) {
        boolean shapeless = recipe instanceof ShapelessTableRecipe;
        int sX = (shapeless ? 265 : 285) / 2;
        int sY = 0;
        if (recipe.hasRequiredTier() && mouseX > (double)(sX - 1) && mouseX < (double)(sX + 8) && mouseY > (double)(sY - 1) && mouseY < (double)(sY + 8)) {
            return Collections.singletonList(ModTooltips.REQUIRES_TABLE.args(new Object[]{recipe.getTier()}).color(TextFormatting.WHITE).build());
        }
        if (shapeless && mouseX > (double)(sX + 10) && mouseX < (double)(sX + 20) && mouseY > (double)(sY - 1) && mouseY < (double)(sY + 8)) {
            return Collections.singletonList(Localizable.of((String)"jei.tooltip.shapeless.recipe").build());
        }
        return Collections.emptyList();
    }

    public void setIngredients(ITableRecipe recipe, IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
        ingredients.setInputIngredients((List)recipe.func_192400_c());
    }

    public void setRecipe(IRecipeLayout layout, ITableRecipe recipe, IIngredients ingredients) {
        int i;
        IGuiItemStackGroup stacks = layout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0);
        stacks.init(0, false, 128, 35);
        stacks.set(0, outputs);
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                int index = 1 + j + i * 5;
                stacks.init(index, true, j * 18, i * 18);
            }
        }
        if (recipe instanceof ShapedTableRecipe) {
            ShapedTableRecipe shaped = (ShapedTableRecipe)recipe;
            int heightOffset = Math.floorDiv(5 - shaped.getHeight(), 2);
            int widthOffset = Math.floorDiv(5 - shaped.getWidth(), 2);
            int stackIndex = 0;
            for (int i2 = heightOffset; i2 < shaped.getHeight() + heightOffset; ++i2) {
                for (int j = widthOffset; j < shaped.getWidth() + widthOffset; ++j) {
                    int index = 1 + i2 * 5 + j;
                    stacks.set(index, (List)inputs.get(stackIndex));
                    ++stackIndex;
                }
            }
        } else if (recipe instanceof ShapelessTableRecipe) {
            for (i = 0; i < inputs.size(); ++i) {
                stacks.set(i + 1, (List)inputs.get(i));
            }
        }
        layout.moveRecipeTransferButton(137, 77);
    }
}

