/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.client.screen.AdvancedAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.AdvancedTableScreen;
import com.blakebr0.extendedcrafting.client.screen.BasicAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.BasicTableScreen;
import com.blakebr0.extendedcrafting.client.screen.CompressorScreen;
import com.blakebr0.extendedcrafting.client.screen.CraftingCoreScreen;
import com.blakebr0.extendedcrafting.client.screen.EliteAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.EliteTableScreen;
import com.blakebr0.extendedcrafting.client.screen.EnderCrafterScreen;
import com.blakebr0.extendedcrafting.client.screen.UltimateAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.UltimateTableScreen;
import com.blakebr0.extendedcrafting.compat.jei.CombinationCraftingCategory;
import com.blakebr0.extendedcrafting.compat.jei.CompressorCraftingCategory;
import com.blakebr0.extendedcrafting.compat.jei.EnderCrafterCategory;
import com.blakebr0.extendedcrafting.compat.jei.table.AdvancedTableCategory;
import com.blakebr0.extendedcrafting.compat.jei.table.BasicTableCategory;
import com.blakebr0.extendedcrafting.compat.jei.table.EliteTableCategory;
import com.blakebr0.extendedcrafting.compat.jei.table.UltimateTableCategory;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.AdvancedAutoTableContainer;
import com.blakebr0.extendedcrafting.container.AdvancedTableContainer;
import com.blakebr0.extendedcrafting.container.BasicAutoTableContainer;
import com.blakebr0.extendedcrafting.container.BasicTableContainer;
import com.blakebr0.extendedcrafting.container.EliteAutoTableContainer;
import com.blakebr0.extendedcrafting.container.EliteTableContainer;
import com.blakebr0.extendedcrafting.container.EnderCrafterContainer;
import com.blakebr0.extendedcrafting.container.UltimateAutoTableContainer;
import com.blakebr0.extendedcrafting.container.UltimateTableContainer;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.blakebr0.extendedcrafting.init.ModItems;
import com.blakebr0.extendedcrafting.singularity.Singularity;
import com.blakebr0.extendedcrafting.singularity.SingularityUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public final class JeiCompat
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("extendedcrafting", "jei_plugin");
    public static final ResourceLocation ICONS = new ResourceLocation("extendedcrafting", "textures/gui/jei/icons.png");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        if (((Boolean)ModConfigs.ENABLE_CRAFTING_CORE.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new CombinationCraftingCategory(helper)});
        }
        if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new BasicTableCategory(helper), new AdvancedTableCategory(helper), new EliteTableCategory(helper), new UltimateTableCategory(helper)});
        }
        if (((Boolean)ModConfigs.ENABLE_COMPRESSOR.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new CompressorCraftingCategory(helper)});
        }
        if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new EnderCrafterCategory(helper)});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            RecipeManager manager = world.func_199532_z();
            if (((Boolean)ModConfigs.ENABLE_CRAFTING_CORE.get()).booleanValue()) {
                registration.addRecipes(manager.func_215366_a(RecipeTypes.COMBINATION).values(), CombinationCraftingCategory.UID);
            }
            if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
                Map<Integer, List> recipes = Stream.of(1, 2, 3, 4).collect(Collectors.toMap(tier -> tier, tier -> manager.func_215366_a(RecipeTypes.TABLE).values().stream().map(recipe -> (ITableRecipe)recipe).filter(recipe -> recipe.hasRequiredTier() ? tier.intValue() == recipe.getTier() : tier >= recipe.getTier()).collect(Collectors.toList())));
                registration.addRecipes((Collection)recipes.getOrDefault(1, new ArrayList()), BasicTableCategory.UID);
                registration.addRecipes((Collection)recipes.getOrDefault(2, new ArrayList()), AdvancedTableCategory.UID);
                registration.addRecipes((Collection)recipes.getOrDefault(3, new ArrayList()), EliteTableCategory.UID);
                registration.addRecipes((Collection)recipes.getOrDefault(4, new ArrayList()), UltimateTableCategory.UID);
            }
            if (((Boolean)ModConfigs.ENABLE_COMPRESSOR.get()).booleanValue()) {
                registration.addRecipes(manager.func_215366_a(RecipeTypes.COMPRESSOR).values(), CompressorCraftingCategory.UID);
            }
            if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
                registration.addRecipes(manager.func_215366_a(RecipeTypes.ENDER_CRAFTER).values(), EnderCrafterCategory.UID);
            }
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (((Boolean)ModConfigs.ENABLE_HANDHELD_WORKBENCH.get()).booleanValue()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.HANDHELD_TABLE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        }
        if (((Boolean)ModConfigs.ENABLE_CRAFTING_CORE.get()).booleanValue()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.CRAFTING_CORE.get()), new ResourceLocation[]{CombinationCraftingCategory.UID});
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.PEDESTAL.get()), new ResourceLocation[]{CombinationCraftingCategory.UID});
        }
        if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.BASIC_TABLE.get()), new ResourceLocation[]{BasicTableCategory.UID});
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ADVANCED_TABLE.get()), new ResourceLocation[]{AdvancedTableCategory.UID});
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ELITE_TABLE.get()), new ResourceLocation[]{EliteTableCategory.UID});
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ULTIMATE_TABLE.get()), new ResourceLocation[]{UltimateTableCategory.UID});
            if (((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue()) {
                registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.BASIC_TABLE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
            }
            if (((Boolean)ModConfigs.ENABLE_AUTO_TABLES.get()).booleanValue()) {
                registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.BASIC_AUTO_TABLE.get()), new ResourceLocation[]{BasicTableCategory.UID});
                registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ADVANCED_AUTO_TABLE.get()), new ResourceLocation[]{AdvancedTableCategory.UID});
                registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ELITE_AUTO_TABLE.get()), new ResourceLocation[]{EliteTableCategory.UID});
                registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ULTIMATE_AUTO_TABLE.get()), new ResourceLocation[]{UltimateTableCategory.UID});
                if (((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue()) {
                    registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.BASIC_AUTO_TABLE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
                }
            }
        }
        if (((Boolean)ModConfigs.ENABLE_COMPRESSOR.get()).booleanValue()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.COMPRESSOR.get()), new ResourceLocation[]{CompressorCraftingCategory.UID});
        }
        if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ENDER_CRAFTER.get()), new ResourceLocation[]{EnderCrafterCategory.UID});
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ENDER_ALTERNATOR.get()), new ResourceLocation[]{EnderCrafterCategory.UID});
        }
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
            registration.addRecipeTransferHandler(BasicTableContainer.class, BasicTableCategory.UID, 1, 9, 10, 36);
            registration.addRecipeTransferHandler(AdvancedTableContainer.class, AdvancedTableCategory.UID, 1, 25, 26, 36);
            registration.addRecipeTransferHandler(EliteTableContainer.class, EliteTableCategory.UID, 1, 49, 50, 36);
            registration.addRecipeTransferHandler(UltimateTableContainer.class, UltimateTableCategory.UID, 1, 81, 82, 36);
            if (((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue()) {
                registration.addRecipeTransferHandler(BasicTableContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
            }
            if (((Boolean)ModConfigs.ENABLE_AUTO_TABLES.get()).booleanValue()) {
                registration.addRecipeTransferHandler(BasicAutoTableContainer.class, BasicTableCategory.UID, 1, 9, 11, 36);
                registration.addRecipeTransferHandler(AdvancedAutoTableContainer.class, AdvancedTableCategory.UID, 1, 25, 27, 36);
                registration.addRecipeTransferHandler(EliteAutoTableContainer.class, EliteTableCategory.UID, 1, 49, 51, 36);
                registration.addRecipeTransferHandler(UltimateAutoTableContainer.class, UltimateTableCategory.UID, 1, 81, 83, 36);
                if (((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue()) {
                    registration.addRecipeTransferHandler(BasicAutoTableContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 11, 36);
                }
            }
        }
        if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
            registration.addRecipeTransferHandler(EnderCrafterContainer.class, EnderCrafterCategory.UID, 1, 9, 10, 36);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (((Boolean)ModConfigs.ENABLE_CRAFTING_CORE.get()).booleanValue()) {
            registration.addRecipeClickArea(CraftingCoreScreen.class, 117, 47, 21, 14, new ResourceLocation[]{CombinationCraftingCategory.UID});
        }
        if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
            registration.addRecipeClickArea(BasicTableScreen.class, 91, 37, 21, 14, new ResourceLocation[]{BasicTableCategory.UID});
            registration.addRecipeClickArea(AdvancedTableScreen.class, 109, 54, 21, 14, new ResourceLocation[]{AdvancedTableCategory.UID});
            registration.addRecipeClickArea(EliteTableScreen.class, 139, 72, 21, 14, new ResourceLocation[]{EliteTableCategory.UID});
            registration.addRecipeClickArea(UltimateTableScreen.class, 174, 90, 21, 14, new ResourceLocation[]{UltimateTableCategory.UID});
            if (((Boolean)ModConfigs.ENABLE_AUTO_TABLES.get()).booleanValue()) {
                registration.addRecipeClickArea(BasicAutoTableScreen.class, 97, 36, 21, 14, new ResourceLocation[]{BasicTableCategory.UID});
                registration.addRecipeClickArea(AdvancedAutoTableScreen.class, 121, 39, 21, 14, new ResourceLocation[]{AdvancedTableCategory.UID});
                registration.addRecipeClickArea(EliteAutoTableScreen.class, 158, 72, 21, 14, new ResourceLocation[]{EliteTableCategory.UID});
                registration.addRecipeClickArea(UltimateAutoTableScreen.class, 193, 90, 21, 14, new ResourceLocation[]{UltimateTableCategory.UID});
            }
        }
        if (((Boolean)ModConfigs.ENABLE_COMPRESSOR.get()).booleanValue()) {
            registration.addRecipeClickArea(CompressorScreen.class, 97, 47, 21, 14, new ResourceLocation[]{CompressorCraftingCategory.UID});
        }
        if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
            registration.addRecipeClickArea(EnderCrafterScreen.class, 90, 36, 21, 14, new ResourceLocation[]{EnderCrafterCategory.UID});
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        ModItems.SINGULARITY.ifPresent(item -> registration.registerSubtypeInterpreter(item, stack -> {
            Singularity singularity = SingularityUtils.getSingularity(stack);
            return singularity != null ? singularity.getId().toString() : "";
        }));
        ModItems.RECIPE_MAKER.ifPresent(item -> registration.registerSubtypeInterpreter(item, stack -> NBTHelper.getString((ItemStack)stack, (String)"Type")));
    }
}

