/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.IEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class EnderCrafterCategory
implements IRecipeCategory<IEnderCrafterRecipe> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("extendedcrafting", "textures/gui/jei/ender_crafting.png");
    public static final ResourceLocation UID = new ResourceLocation("extendedcrafting", "ender_crafting");
    private final IDrawable background;
    private final IDrawableAnimated arrow;
    private final IDrawable icon;

    public EnderCrafterCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 116, 54);
        IDrawableStatic arrowDrawable = helper.createDrawable(TEXTURE, 195, 0, 24, 17);
        this.arrow = helper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.ENDER_CRAFTER.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends IEnderCrafterRecipe> getRecipeClass() {
        return IEnderCrafterRecipe.class;
    }

    public String getTitle() {
        return Localizable.of((String)"jei.category.extendedcrafting.ender_crafting").buildString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(IEnderCrafterRecipe recipe, MatrixStack stack, double mouseX, double mouseY) {
        this.arrow.draw(stack, 61, 19);
    }

    public List<ITextComponent> getTooltipStrings(IEnderCrafterRecipe recipe, double mouseX, double mouseY) {
        if (mouseX > 60.0 && mouseX < 83.0 && mouseY > 19.0 && mouseY < 34.0) {
            return Collections.singletonList(ModTooltips.SECONDS.args(new Object[]{recipe.getCraftingTime()}).color(TextFormatting.WHITE).build());
        }
        return Collections.emptyList();
    }

    public void setIngredients(IEnderCrafterRecipe recipe, IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
        ingredients.setInputIngredients((List)recipe.func_192400_c());
    }

    public void setRecipe(IRecipeLayout layout, IEnderCrafterRecipe recipe, IIngredients ingredients) {
        int i;
        IGuiItemStackGroup stacks = layout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0);
        stacks.init(0, false, 94, 18);
        stacks.set(0, outputs);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = 1 + j + i * 3;
                stacks.init(index, true, j * 18, i * 18);
            }
        }
        if (recipe instanceof ShapedEnderCrafterRecipe) {
            ShapedEnderCrafterRecipe shaped = (ShapedEnderCrafterRecipe)recipe;
            int stackIndex = 0;
            for (int i2 = 0; i2 < shaped.getHeight(); ++i2) {
                for (int j = 0; j < shaped.getWidth(); ++j) {
                    int index = 1 + i2 * 3 + j;
                    stacks.set(index, (List)inputs.get(stackIndex));
                    ++stackIndex;
                }
            }
        } else if (recipe instanceof ShapelessEnderCrafterRecipe) {
            for (i = 0; i < inputs.size(); ++i) {
                stacks.set(i + 1, (List)inputs.get(i));
            }
            layout.setShapeless();
        }
        layout.moveRecipeTransferButton(122, 41);
    }
}

