/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedTableRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessTableRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.extendedcrafting.TableCrafting")
@ZenRegister
public final class TableCrafting {
    @ZenCodeType.Method
    public static void addShaped(String id, IItemStack output, IIngredient[][] inputs) {
        TableCrafting.addShaped(id, 0, output, inputs);
    }

    @ZenCodeType.Method
    public static void addShaped(final String id, final int tier, final IItemStack output, final IIngredient[][] inputs) {
        if (tier > 4 || tier < 0) {
            CraftTweakerAPI.logError((String)("Unable to assign a tier to the Table Recipe for stack " + output.getCommandString() + ". Tier cannot be greater than 4 or less than 0."), (Object[])new Object[0]);
        }
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                int height = inputs.length;
                int width = 0;
                for (IIngredient[] row : inputs) {
                    if (width >= row.length) continue;
                    width = row.length;
                }
                NonNullList ingredients = NonNullList.func_191197_a((int)(height * width), (Object)Ingredient.field_193370_a);
                HashMap<Integer, Function<ItemStack, ItemStack>> transformers = new HashMap<Integer, Function<ItemStack, ItemStack>>();
                for (int a = 0; a < height; ++a) {
                    for (int b = 0; b < inputs[a].length; ++b) {
                        IIngredient iing = inputs[a][b];
                        Ingredient ing = iing.asVanillaIngredient();
                        int i = a * width + b;
                        ingredients.set(i, (Object)ing);
                        if (ing == Ingredient.field_193370_a) continue;
                        transformers.put(i, stack -> {
                            IItemStack istack = iing.getRemainingItem((IItemStack)new MCItemStack(stack));
                            return istack.getInternal();
                        });
                    }
                }
                ShapedTableRecipe recipe = new ShapedTableRecipe(new ResourceLocation("crafttweaker", id), width, height, (NonNullList<Ingredient>)ingredients, output.getInternal(), TableCrafting.clampTier(tier));
                recipe.setTransformers(transformers);
                RecipeHelper.addRecipe((IRecipe)recipe);
            }

            public String describe() {
                return "Adding Shaped Table recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void addShapeless(String id, IItemStack output, IIngredient[] inputs) {
        TableCrafting.addShapeless(id, 0, output, inputs);
    }

    @ZenCodeType.Method
    public static void addShapeless(final String id, final int tier, final IItemStack output, final IIngredient[] inputs) {
        if (tier > 4 || tier < 0) {
            CraftTweakerAPI.logError((String)("Unable to assign a tier to the Table Recipe for stack " + output.getCommandString() + ". Tier cannot be greater than 4 or less than 0."), (Object[])new Object[0]);
        }
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                HashMap<Integer, Function<ItemStack, ItemStack>> transformers = new HashMap<Integer, Function<ItemStack, ItemStack>>();
                for (int i = 0; i < inputs.length; ++i) {
                    IIngredient iing = inputs[i];
                    Ingredient ing = iing.asVanillaIngredient();
                    if (ing == Ingredient.field_193370_a) continue;
                    transformers.put(i, stack -> {
                        IItemStack istack = iing.getRemainingItem((IItemStack)new MCItemStack(stack));
                        return istack.getInternal();
                    });
                }
                ShapelessTableRecipe recipe = new ShapelessTableRecipe(new ResourceLocation("crafttweaker", id), (NonNullList<Ingredient>)TableCrafting.toIngredientsList(inputs), output.getInternal(), TableCrafting.clampTier(tier));
                recipe.setTransformers(transformers);
                RecipeHelper.addRecipe((IRecipe)recipe);
            }

            public String describe() {
                return "Adding Shapeless Table Crafting recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                List<ResourceLocation> recipes = ((Map)RecipeHelper.getRecipes().getOrDefault(RecipeTypes.TABLE, new HashMap())).values().stream().filter(r -> r.func_77571_b().func_77969_a(stack.getInternal())).map(IRecipe::func_199560_c).collect(Collectors.toList());
                recipes.forEach(r -> ((Map)RecipeHelper.getRecipes().get(RecipeTypes.TABLE)).remove(r));
            }

            public String describe() {
                return "Removing Table Crafting recipes for " + stack.getCommandString();
            }
        });
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }

    private static int clampTier(int tier) {
        return tier > 4 || tier < 0 ? 0 : tier;
    }
}

