/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessEnderCrafterRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.extendedcrafting.EnderCrafting")
@ZenRegister
public final class EnderCrafting
implements IRecipeManager {
    @ZenCodeType.Method
    public static void addShaped(String id, IItemStack output, IIngredient[][] inputs) {
        EnderCrafting.addShaped(id, output, inputs, (Integer)ModConfigs.ENDER_CRAFTER_TIME_REQUIRED.get());
    }

    @ZenCodeType.Method
    public static void addShaped(final String id, final IItemStack output, final IIngredient[][] inputs, final int time) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                int height = inputs.length;
                int width = 0;
                for (IIngredient[] row : inputs) {
                    if (width >= row.length) continue;
                    width = row.length;
                }
                NonNullList ingredients = NonNullList.func_191197_a((int)(height * width), (Object)Ingredient.field_193370_a);
                for (int a = 0; a < height; ++a) {
                    for (int b = 0; b < inputs[a].length; ++b) {
                        Ingredient ing = inputs[a][b].asVanillaIngredient();
                        int i = a * width + b;
                        ingredients.set(i, (Object)ing);
                    }
                }
                ShapedEnderCrafterRecipe recipe = new ShapedEnderCrafterRecipe(new ResourceLocation("crafttweaker", id), width, height, (NonNullList<Ingredient>)ingredients, output.getInternal(), time);
                RecipeHelper.addRecipe((IRecipe)recipe);
            }

            public String describe() {
                return "Adding Shaped Ender Crafting recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void addShapeless(String id, IItemStack output, IIngredient[] inputs) {
        EnderCrafting.addShapeless(id, output, inputs, (Integer)ModConfigs.ENDER_CRAFTER_TIME_REQUIRED.get());
    }

    @ZenCodeType.Method
    public static void addShapeless(final String id, final IItemStack output, final IIngredient[] inputs, final int time) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                ShapelessEnderCrafterRecipe recipe = new ShapelessEnderCrafterRecipe(new ResourceLocation("crafttweaker", id), (NonNullList<Ingredient>)EnderCrafting.toIngredientsList(inputs), output.getInternal(), time);
                RecipeHelper.addRecipe((IRecipe)recipe);
            }

            public String describe() {
                return "Adding Shapeless Ender Crafter recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                List<ResourceLocation> recipes = ((Map)RecipeHelper.getRecipes().getOrDefault(RecipeTypes.ENDER_CRAFTER, new HashMap())).values().stream().filter(r -> r.func_77571_b().func_77969_a(stack.getInternal())).map(IRecipe::func_199560_c).collect(Collectors.toList());
                recipes.forEach(r -> ((Map)RecipeHelper.getRecipes().get(RecipeTypes.ENDER_CRAFTER)).remove(r));
            }

            public String describe() {
                return "Removing Ender Crafter recipes for " + stack.getCommandString();
            }
        });
    }

    public IRecipeType<?> getRecipeType() {
        return RecipeTypes.ENDER_CRAFTER;
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }
}

