/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.screen;

import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.extendedcrafting.container.CraftingCoreContainer;
import com.blakebr0.extendedcrafting.crafting.recipe.CombinationRecipe;
import com.blakebr0.extendedcrafting.tileentity.CraftingCoreTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class CraftingCoreScreen
extends BaseContainerScreen<CraftingCoreContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("extendedcrafting", "textures/gui/crafting_core.png");
    private CraftingCoreTileEntity tile;

    public CraftingCoreScreen(CraftingCoreContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title, BACKGROUND, 176, 194);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.tile = this.getTileEntity();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        if (this.hasRecipe()) {
            ItemStack output = this.getRecipeOutput();
            this.drawItemStack(output, x + 148, y + 47);
            if (CraftingCoreScreen.isHoveringSlot(x + 148, y + 47, mouseX, mouseY)) {
                this.func_230457_a_(stack, output, mouseX, mouseY);
            }
        }
        if (mouseX > x + 7 && mouseX < x + 20 && mouseY > y + 17 && mouseY < y + 94) {
            StringTextComponent text = new StringTextComponent(CraftingCoreScreen.number((Object)this.getEnergyStored()) + " / " + CraftingCoreScreen.number((Object)this.getMaxEnergyStored()) + " FE");
            this.func_238652_a_(stack, (ITextComponent)text, mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        String title = this.func_231171_q_().getString();
        this.field_230712_o_.func_238421_b_(stack, title, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_78256_a(title) / 2), 6.0f, 0x404040);
        String inventory = this.field_213127_e.func_145748_c_().getString();
        this.field_230712_o_.func_238421_b_(stack, inventory, 8.0f, (float)this.field_147000_g - 94.0f, 0x404040);
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)0.75f, (float)0.75f, (float)0.75f);
        this.field_230712_o_.func_238421_b_(stack, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.pedestals", (Object[])new Object[]{this.getPedestalCount()}), 36.0f, 36.0f, -1);
        if (!this.hasRecipe()) {
            this.field_230712_o_.func_238421_b_(stack, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.no_recipe", (Object[])new Object[0]), 36.0f, 56.0f, -1);
        } else {
            this.field_230712_o_.func_238421_b_(stack, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.power_cost", (Object[])new Object[]{CraftingCoreScreen.number((Object)this.getEnergyRequired())}) + " FE", 36.0f, 56.0f, -1);
            this.field_230712_o_.func_238421_b_(stack, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.power_rate", (Object[])new Object[]{CraftingCoreScreen.number((Object)this.getEnergyRate())}) + " FE/t", 36.0f, 66.0f, -1);
            if (this.getEnergyStored() < this.getEnergyRate()) {
                this.field_230712_o_.func_238421_b_(stack, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.no_power", (Object[])new Object[0]), 36.0f, 86.0f, -1);
            }
        }
        RenderSystem.popMatrix();
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(stack, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        int i1 = this.getEnergyBarScaled();
        this.func_238474_b_(stack, x + 7, y + 95 - i1, 178, 78 - i1, 15, i1 + 1);
        if (this.hasRecipe()) {
            if (this.getProgress() > 0 && this.getEnergyRate() > 0) {
                int i2 = this.getProgressBarScaled();
                this.func_238474_b_(stack, x + 116, y + 47, 194, 0, i2 + 1, 16);
            }
            ItemStack output = this.getRecipeOutput();
            this.drawItemStack(output, x + 148, y + 47);
            if (CraftingCoreScreen.isHoveringSlot(x + 148, y + 47, mouseX, mouseY)) {
                this.drawItemHoverOverlay(stack, x + 148, y + 47);
            }
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        RenderSystem.pushMatrix();
        RenderHelper.func_227780_a_();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-32.0f);
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_230712_o_;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230707_j_.func_180450_b(stack, x, y);
        this.field_230707_j_.func_180453_a(font, stack, x, y, null);
        RenderHelper.func_74518_a();
        RenderSystem.popMatrix();
    }

    private void drawItemHoverOverlay(MatrixStack stack, int x, int y) {
        RenderSystem.pushMatrix();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.func_238468_a_(stack, x, y, x + 16, y + 16, -2130706433, -2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableLighting();
        RenderSystem.enableDepthTest();
        RenderSystem.popMatrix();
    }

    private CraftingCoreTileEntity getTileEntity() {
        TileEntity tile;
        ClientWorld world = this.getMinecraft().field_71441_e;
        if (world != null && (tile = world.func_175625_s(((CraftingCoreContainer)this.func_212873_a_()).getPos())) instanceof CraftingCoreTileEntity) {
            return (CraftingCoreTileEntity)tile;
        }
        return null;
    }

    private boolean hasRecipe() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.hasRecipe();
    }

    private ItemStack getRecipeOutput() {
        if (this.tile == null) {
            return ItemStack.field_190927_a;
        }
        CombinationRecipe recipe = this.tile.getActiveRecipe();
        if (recipe != null) {
            return recipe.func_77571_b();
        }
        return ItemStack.field_190927_a;
    }

    private int getEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getEnergyStored();
    }

    private int getMaxEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getMaxEnergyStored();
    }

    private int getEnergyRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergyRequired();
    }

    private int getEnergyRate() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergyRate();
    }

    private int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    private int getPedestalCount() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getPedestalCount();
    }

    private int getEnergyBarScaled() {
        int i = this.getEnergyStored();
        int j = this.getMaxEnergyStored();
        return (int)(j != 0 && i != 0 ? (long)i * 78L / (long)j : 0L);
    }

    private int getProgressBarScaled() {
        int i = this.getProgress();
        long j = this.getEnergyRequired();
        return (int)(j != 0L && i != 0 ? (long)i * 24L / j : 0L);
    }

    private static boolean isHoveringSlot(int x, int y, int mouseX, int mouseY) {
        return mouseX > x - 1 && mouseX < x + 16 && mouseY > y - 1 && mouseY < y + 16;
    }
}

