/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.screen;

import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.extendedcrafting.client.screen.button.EjectModeSwitchButton;
import com.blakebr0.extendedcrafting.client.screen.button.InputLimitSwitchButton;
import com.blakebr0.extendedcrafting.container.CompressorContainer;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.tileentity.CompressorTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class CompressorScreen
extends BaseContainerScreen<CompressorContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("extendedcrafting", "textures/gui/compressor.png");
    private CompressorTileEntity tile;

    public CompressorScreen(CompressorContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title, BACKGROUND, 176, 194);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        BlockPos pos = ((CompressorContainer)this.func_212873_a_()).getPos();
        this.func_230480_a_((Widget)new EjectModeSwitchButton(x + 69, y + 30, pos));
        this.func_230480_a_((Widget)new InputLimitSwitchButton(x + 91, y + 74, pos, this::isLimitingInput));
        this.tile = this.getTileEntity();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        if (mouseX > x + 7 && mouseX < x + 20 && mouseY > y + 17 && mouseY < y + 94) {
            StringTextComponent text = new StringTextComponent(CompressorScreen.number((Object)this.getEnergyStored()) + " / " + CompressorScreen.number((Object)this.getMaxEnergyStored()) + " FE");
            this.func_238652_a_(stack, (ITextComponent)text, mouseX, mouseY);
        }
        if (mouseX > x + 60 && mouseX < x + 85 && mouseY > y + 74 && mouseY < y + 83) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (this.getMaterialCount() < 1) {
                tooltip.add(ModTooltips.EMPTY.color(TextFormatting.WHITE).build());
            } else {
                if (this.hasMaterialStack()) {
                    tooltip.add(this.getMaterialStackDisplayName());
                }
                StringTextComponent text = new StringTextComponent(CompressorScreen.number((Object)this.getMaterialCount()) + " / " + CompressorScreen.number((Object)this.getMaterialsRequired()));
                tooltip.add(text);
            }
            this.func_243308_b(stack, tooltip, mouseX, mouseY);
        }
        if (mouseX > x + 68 && mouseX < x + 79 && mouseY > y + 28 && mouseY < y + 39) {
            if (this.isEjecting()) {
                this.func_238652_a_(stack, (ITextComponent)ModTooltips.EJECTING.color(TextFormatting.WHITE).build(), mouseX, mouseY);
            } else {
                this.func_238652_a_(stack, (ITextComponent)ModTooltips.EJECT.color(TextFormatting.WHITE).build(), mouseX, mouseY);
            }
        }
        if (mouseX > x + 90 && mouseX < x + 98 && mouseY > y + 73 && mouseY < y + 84) {
            if (this.isLimitingInput()) {
                this.func_238652_a_(stack, (ITextComponent)ModTooltips.LIMITED_INPUT.color(TextFormatting.WHITE).build(), mouseX, mouseY);
            } else {
                this.func_238652_a_(stack, (ITextComponent)ModTooltips.UNLIMITED_INPUT.color(TextFormatting.WHITE).build(), mouseX, mouseY);
            }
        }
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        String title = this.func_231171_q_().getString();
        this.field_230712_o_.func_238421_b_(stack, title, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_78256_a(title) / 2), 6.0f, 0x404040);
        String inventory = this.field_213127_e.func_145748_c_().getString();
        this.field_230712_o_.func_238421_b_(stack, inventory, 8.0f, (float)this.field_147000_g - 94.0f, 0x404040);
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(stack, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        int i1 = this.getEnergyBarScaled(78);
        this.func_238474_b_(stack, x + 7, y + 95 - i1, 178, 78 - i1, 15, i1 + 1);
        if (this.hasRecipe()) {
            int i2;
            if (this.getMaterialCount() > 0 && this.getMaterialsRequired() > 0) {
                i2 = this.getMaterialBarScaled(26);
                this.func_238474_b_(stack, x + 60, y + 74, 194, 19, i2 + 1, 10);
            }
            if (this.getProgress() > 0 && this.getEnergyRequired() > 0) {
                i2 = this.getProgressBarScaled(24);
                this.func_238474_b_(stack, x + 96, y + 47, 194, 0, i2 + 1, 16);
            }
        }
        if (this.isLimitingInput()) {
            this.func_238474_b_(stack, x + 90, y + 74, 203, 56, 9, 10);
        }
    }

    private ITextComponent getMaterialStackDisplayName() {
        CompressorContainer container;
        TileEntity tile;
        ClientWorld world = this.getMinecraft().field_71441_e;
        if (world != null && (tile = world.func_175625_s((container = (CompressorContainer)this.func_212873_a_()).getPos())) instanceof CompressorTileEntity) {
            CompressorTileEntity compressor = (CompressorTileEntity)tile;
            ItemStack materialStack = compressor.getMaterialStack();
            return materialStack.func_200301_q();
        }
        return new StringTextComponent("");
    }

    private CompressorTileEntity getTileEntity() {
        TileEntity tile;
        ClientWorld world = this.getMinecraft().field_71441_e;
        if (world != null && (tile = world.func_175625_s(((CompressorContainer)this.func_212873_a_()).getPos())) instanceof CompressorTileEntity) {
            return (CompressorTileEntity)tile;
        }
        return null;
    }

    public boolean isEjecting() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.isEjecting();
    }

    public boolean isLimitingInput() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.isLimitingInput();
    }

    public boolean hasRecipe() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.hasRecipe();
    }

    public boolean hasMaterialStack() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.hasMaterialStack();
    }

    public int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    public int getMaterialCount() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getMaterialCount();
    }

    public int getEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getMaxEnergyStored();
    }

    public int getEnergyRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergyRequired();
    }

    public int getMaterialsRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getMaterialsRequired();
    }

    public int getEnergyBarScaled(int pixels) {
        int i = this.getEnergyStored();
        int j = this.getMaxEnergyStored();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }

    public int getMaterialBarScaled(int pixels) {
        int i = MathHelper.func_76125_a((int)this.getMaterialCount(), (int)0, (int)this.getMaterialsRequired());
        int j = this.getMaterialsRequired();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getProgressBarScaled(int pixels) {
        int i = this.getProgress();
        int j = this.getEnergyRequired();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }
}

