/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.screen;

import com.blakebr0.cucumber.client.render.GhostItemRenderer;
import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.extendedcrafting.client.screen.button.RecipeSelectButton;
import com.blakebr0.extendedcrafting.client.screen.button.ToggleTableRunningButton;
import com.blakebr0.extendedcrafting.container.BasicAutoTableContainer;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class BasicAutoTableScreen
extends BaseContainerScreen<BasicAutoTableContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("extendedcrafting", "textures/gui/basic_auto_table.png");
    private final RecipeSelectButton[] recipeSelectButtons = new RecipeSelectButton[3];
    private AutoTableTileEntity tile;

    public BasicAutoTableScreen(BasicAutoTableContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title, BACKGROUND, 176, 194);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        BlockPos pos = ((BasicAutoTableContainer)this.func_212873_a_()).getPos();
        this.func_230480_a_((Widget)new ToggleTableRunningButton(x + 130, y + 59, pos, this::isRunning));
        this.recipeSelectButtons[0] = (RecipeSelectButton)this.func_230480_a_((Widget)new RecipeSelectButton(x + 132, y + 7, pos, 0, this::isRecipeSelected));
        this.recipeSelectButtons[1] = (RecipeSelectButton)this.func_230480_a_((Widget)new RecipeSelectButton(x + 145, y + 7, pos, 1, this::isRecipeSelected));
        this.recipeSelectButtons[2] = (RecipeSelectButton)this.func_230480_a_((Widget)new RecipeSelectButton(x + 158, y + 7, pos, 2, this::isRecipeSelected));
        this.tile = this.getTileEntity();
    }

    protected void func_230459_a_(MatrixStack stack, int mouseX, int mouseY) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.func_230459_a_(stack, mouseX, mouseY);
        if (mouseX > x + 7 && mouseX < x + 20 && mouseY > y + 17 && mouseY < y + 94) {
            StringTextComponent text = new StringTextComponent(BasicAutoTableScreen.number((Object)this.getEnergyStored()) + " / " + BasicAutoTableScreen.number((Object)this.getMaxEnergyStored()) + " FE");
            this.func_238652_a_(stack, (ITextComponent)text, mouseX, mouseY);
        }
        if (mouseX > x + 129 && mouseX < x + 142 && mouseY > y + 58 && mouseY < y + 73) {
            this.func_238652_a_(stack, (ITextComponent)ModTooltips.TOGGLE_AUTO_CRAFTING.color(TextFormatting.WHITE).build(), mouseX, mouseY);
        }
        for (RecipeSelectButton button : this.recipeSelectButtons) {
            ArrayList tooltip;
            boolean hasRecipe;
            BaseItemStackHandler recipe;
            if (!button.func_230449_g_() || (recipe = this.getRecipeInfo(button.getIndex())) == null) continue;
            boolean bl = hasRecipe = !recipe.getStacks().stream().allMatch(ItemStack::func_190926_b);
            if (hasRecipe) {
                ItemStack output = recipe.getStackInSlot(recipe.getSlots() - 1);
                tooltip = Lists.newArrayList((Object[])new ITextComponent[]{new StringTextComponent(output.func_190916_E() + "x " + output.func_200301_q().getString()), new StringTextComponent(""), ModTooltips.AUTO_TABLE_DELETE_RECIPE.color(TextFormatting.WHITE).build()});
                if (this.getSelected() == button.getIndex()) {
                    tooltip.add(1, ModTooltips.SELECTED.color(TextFormatting.GREEN).build());
                }
            } else {
                tooltip = Lists.newArrayList((Object[])new ITextComponent[]{ModTooltips.AUTO_TABLE_SAVE_RECIPE.color(TextFormatting.WHITE).build()});
                if (this.getSelected() == button.getIndex()) {
                    tooltip.add(0, ModTooltips.SELECTED.color(TextFormatting.GREEN).build());
                    tooltip.add(1, new StringTextComponent(""));
                }
            }
            this.func_243308_b(stack, tooltip, mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        String title = this.func_231171_q_().getString();
        this.field_230712_o_.func_238421_b_(stack, title, 32.0f, 6.0f, 0x404040);
        String inventory = this.field_213127_e.func_145748_c_().getString();
        this.field_230712_o_.func_238421_b_(stack, inventory, 8.0f, (float)this.field_147000_g - 94.0f, 0x404040);
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        BaseItemStackHandler recipe;
        super.func_230450_a_(stack, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        int i1 = this.getEnergyBarScaled();
        this.func_238474_b_(stack, x + 7, y + 95 - i1, 178, 78 - i1, 15, i1 + 1);
        if (this.isRunning()) {
            int i2 = this.getProgressBarScaled();
            this.func_238474_b_(stack, x + 129, y + 58, 194, 0, 13, i2);
        }
        if ((recipe = this.getSelectedRecipe()) != null) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = i * 3 + j;
                    ItemStack item = recipe.getStackInSlot(index);
                    GhostItemRenderer.renderItemIntoGui((ItemStack)item, (int)(x + 33 + j * 18), (int)(y + 30 + i * 18), (ItemRenderer)this.field_230707_j_);
                }
            }
            ItemStack output = recipe.getStackInSlot(recipe.getSlots() - 1);
            GhostItemRenderer.renderItemIntoGui((ItemStack)output, (int)(x + 129), (int)(y + 34), (ItemRenderer)this.field_230707_j_);
        }
    }

    private boolean isRecipeSelected(int index) {
        return index == this.getSelected();
    }

    private AutoTableTileEntity getTileEntity() {
        TileEntity tile;
        ClientWorld world = this.getMinecraft().field_71441_e;
        if (world != null && (tile = world.func_175625_s(((BasicAutoTableContainer)this.func_212873_a_()).getPos())) instanceof AutoTableTileEntity) {
            return (AutoTableTileEntity)tile;
        }
        return null;
    }

    private boolean isRunning() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.isRunning();
    }

    private BaseItemStackHandler getRecipeInfo(int selected) {
        if (this.tile == null) {
            return null;
        }
        return this.tile.getRecipeStorage().getRecipe(selected);
    }

    private BaseItemStackHandler getSelectedRecipe() {
        if (this.tile == null) {
            return null;
        }
        return this.tile.getRecipeStorage().getSelectedRecipe();
    }

    private int getSelected() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getRecipeStorage().getSelected();
    }

    private int getEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getEnergyStored();
    }

    private int getMaxEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getMaxEnergyStored();
    }

    private int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    private int getProgressRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgressRequired();
    }

    private int getEnergyBarScaled() {
        int i = this.getEnergyStored();
        int j = this.getMaxEnergyStored();
        return (int)(j != 0 && i != 0 ? (long)i * 78L / (long)j : 0L);
    }

    private int getProgressBarScaled() {
        int i = this.getProgress();
        int j = this.getProgressRequired();
        return j != 0 && i != 0 ? i * 16 / j : 0;
    }
}

