/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.util.VoxelShapeBuilder;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.tileentity.EliteTableTileEntity;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class EliteTableBlock
extends BaseTileEntityBlock
implements IEnableable {
    public static final VoxelShape ELITE_TABLE_SHAPE = new VoxelShapeBuilder().cuboid(14.0, 2.0, 14.0, 2.0, 0.0, 2.0).cuboid(5.0, 10.0, 5.0, 3.0, 2.0, 3.0).cuboid(13.0, 10.0, 13.0, 11.0, 2.0, 11.0).cuboid(13.0, 10.0, 5.0, 11.0, 2.0, 3.0).cuboid(5.0, 10.0, 13.0, 3.0, 2.0, 11.0).cuboid(16.0, 16.0, 16.0, 0.0, 10.0, 0.0).build();

    public EliteTableBlock() {
        super(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 10.0f, ToolType.PICKAXE);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EliteTableTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        TileEntity tile;
        if (!world.func_201670_d() && (tile = world.func_175625_s(pos)) instanceof EliteTableTileEntity) {
            player.func_213829_a((INamedContainerProvider)((EliteTableTileEntity)tile));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof EliteTableTileEntity) {
            EliteTableTileEntity table = (EliteTableTileEntity)tile;
            InventoryHelper.func_219961_a((World)world, (BlockPos)pos, (NonNullList)table.getInventory().getStacks());
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return ELITE_TABLE_SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)ModTooltips.TIER.args(new Object[]{3}).build());
    }

    public boolean isEnabled() {
        return (Boolean)ModConfigs.ENABLE_TABLES.get();
    }
}

