/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.util.VoxelShapeBuilder;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.tileentity.CraftingCoreTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class CraftingCoreBlock
extends BaseTileEntityBlock
implements IEnableable {
    public static final VoxelShape CRAFTING_CORE_SHAPE = new VoxelShapeBuilder().cuboid(14.0, 2.0, 14.0, 2.0, 0.0, 2.0).cuboid(16.0, 5.0, 16.0, 0.0, 2.0, 0.0).cuboid(15.0, 6.0, 15.0, 1.0, 5.0, 1.0).cuboid(16.0, 12.0, 16.0, 0.0, 6.0, 0.0).cuboid(15.0, 13.0, 15.0, 1.0, 12.0, 1.0).cuboid(16.0, 16.0, 16.0, 0.0, 13.0, 0.0).build();

    public CraftingCoreBlock() {
        super(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 10.0f, ToolType.PICKAXE);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CraftingCoreTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        TileEntity tile;
        ItemStack held = player.func_184586_b(hand);
        if (!world.func_201670_d() && (tile = world.func_175625_s(pos)) instanceof CraftingCoreTileEntity) {
            CraftingCoreTileEntity core = (CraftingCoreTileEntity)tile;
            if (trace.func_216354_b() == Direction.UP) {
                BaseItemStackHandler inventory = core.getInventory();
                ItemStack stack = inventory.getStackInSlot(0);
                if (stack.func_190926_b()) {
                    if (!held.func_190926_b()) {
                        inventory.setStackInSlot(0, StackHelper.withSize((ItemStack)held, (int)1, (boolean)false));
                        player.func_184611_a(hand, StackHelper.shrink((ItemStack)held, (int)1, (boolean)false));
                        world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    ItemEntity item = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack);
                    item.func_174868_q();
                    world.func_217376_c((Entity)item);
                    inventory.setStackInSlot(0, ItemStack.field_190927_a);
                }
            } else {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)core, (BlockPos)pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile;
        if (state.func_177230_c() != newState.func_177230_c() && (tile = world.func_175625_s(pos)) instanceof CraftingCoreTileEntity) {
            CraftingCoreTileEntity core = (CraftingCoreTileEntity)tile;
            InventoryHelper.func_219961_a((World)world, (BlockPos)pos, (NonNullList)core.getInventory().getStacks());
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return CRAFTING_CORE_SHAPE;
    }

    public boolean isEnabled() {
        return (Boolean)ModConfigs.ENABLE_CRAFTING_CORE.get();
    }
}

