/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.elements.AbstractElementPanel;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import net.minecraft.network.PacketBuffer;

public class ElementHorizontal
extends AbstractElementPanel {
    public static final int SPACING = 5;

    public ElementHorizontal() {
        super(new LayoutStyle());
    }

    public ElementHorizontal(ILayoutStyle style) {
        super(style);
    }

    @Deprecated
    public ElementHorizontal(Integer borderColor, int spacing, ElementAlignment alignment) {
        super(borderColor, spacing, alignment);
    }

    public ElementHorizontal(PacketBuffer buf) {
        super(buf);
    }

    @Override
    public void render(MatrixStack matrixStack, int x, int y) {
        super.render(matrixStack, x, y);
        if (this.layout.getBorderColor() != null) {
            x += 3;
            y += 3;
        }
        x += this.layout.getLeftPadding();
        int totHeight = this.getHeight() - this.getYPadding();
        for (IElement element : this.children) {
            int h = element.getHeight();
            int cy = y;
            switch (this.layout.getAlignment()) {
                case ALIGN_TOPLEFT: {
                    break;
                }
                case ALIGN_CENTER: {
                    cy = y + (totHeight - h) / 2;
                    break;
                }
                case ALIGN_BOTTOMRIGHT: {
                    cy = y + totHeight - h;
                }
            }
            element.render(matrixStack, x, cy + this.layout.getTopPadding());
            x += element.getWidth() + this.layout.getSpacing();
        }
    }

    private int getBorderSpacing() {
        return this.layout.getBorderColor() == null ? 0 : 6;
    }

    @Override
    public int getWidth() {
        int w = 0;
        for (IElement element : this.children) {
            w += element.getWidth();
        }
        return w + this.layout.getSpacing() * (this.children.size() - 1) + this.getBorderSpacing() + this.getXPadding();
    }

    @Override
    public int getHeight() {
        int h = 0;
        for (IElement element : this.children) {
            h = Math.max(h, element.getHeight());
        }
        return h + this.getBorderSpacing() + this.getYPadding();
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_HORIZONTAL;
    }
}

