/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks.base;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.blocks.base.IConnects;
import com.mrh0.buildersaddition.state.PillarState;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class BasePillar
extends BaseDerivativeBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<PillarState> STATE = EnumProperty.func_177709_a((String)"state", PillarState.class);
    protected static final AxisAlignedBB PILLAR = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    protected static final AxisAlignedBB PILLAR_NOT_CONNECTED = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
    protected static final AxisAlignedBB PILLAR_BOTTOM = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.125, 0.9375);
    protected static final AxisAlignedBB PILLAR_TOP = new AxisAlignedBB(0.0625, 0.875, 0.0625, 0.9375, 1.0, 0.9375);
    private final int light;
    private final IConnects iconnect;

    public BasePillar(String name, Block source, int light, IConnects connects) {
        super("cut_" + name + "_pillar", source);
        this.light = light;
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)PillarState.Both))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.iconnect = connects;
    }

    public BasePillar(String name, Block source, IConnects connects) {
        this(name, source, 0, connects);
    }

    public BasePillar(String name, Block source, int light) {
        this(name, source, (BlockState state, Block b) -> state.func_177230_c() == b);
    }

    public BasePillar(String name, Block source) {
        this(name, source, 0);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_177229_b(STATE) == PillarState.Top ? this.light : 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STATE, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state) {
        switch ((PillarState)((Object)state.func_177229_b(STATE))) {
            case None: {
                return VoxelShapes.func_197881_a((AxisAlignedBB)PILLAR);
            }
            case Top: {
                return VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)PILLAR), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)PILLAR_TOP));
            }
            case Bottom: {
                return VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)PILLAR), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)PILLAR_BOTTOM));
            }
            case Both: {
                return VoxelShapes.func_197881_a((AxisAlignedBB)PILLAR_NOT_CONNECTED);
            }
        }
        return VoxelShapes.func_197881_a((AxisAlignedBB)PILLAR);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShape(state);
    }

    public BlockState getState(BlockState state, IWorld worldIn, BlockPos pos) {
        boolean bottom;
        BlockState bstop = worldIn.func_180495_p(pos.func_177984_a());
        BlockState bsbottom = worldIn.func_180495_p(pos.func_177977_b());
        boolean top = !this.connects(bstop, this);
        boolean bl = bottom = !this.connects(bsbottom, this);
        if (top && bottom) {
            return (BlockState)state.func_206870_a(STATE, (Comparable)((Object)PillarState.Both));
        }
        if (top) {
            return (BlockState)state.func_206870_a(STATE, (Comparable)((Object)PillarState.Top));
        }
        if (bottom) {
            return (BlockState)state.func_206870_a(STATE, (Comparable)((Object)PillarState.Bottom));
        }
        return (BlockState)state.func_206870_a(STATE, (Comparable)((Object)PillarState.None));
    }

    public BlockState getState(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return this.getState(state, (IWorld)worldIn, pos);
    }

    public BlockState func_196258_a(BlockItemUseContext c) {
        return (BlockState)this.getState(this.func_176223_P(), (IWorld)c.func_195991_k(), c.func_195995_a()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(c.func_195991_k().func_204610_c(c.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public boolean connects(BlockState state, Block b) {
        return this.iconnect.connect(state, b);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return this.getState(stateIn, worldIn, currentPos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }
}

