/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.blocks.base.ISeat;
import com.mrh0.buildersaddition.entity.SeatEntity;
import com.mrh0.buildersaddition.state.BenchState;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class Bench
extends BaseDerivativeBlock
implements ISeat {
    public static final EnumProperty<BenchState> STATE = EnumProperty.func_177709_a((String)"state", BenchState.class);
    protected static final VoxelShape SHAPE_X = Block.func_208617_a((double)0.0, (double)7.0, (double)2.0, (double)16.0, (double)9.0, (double)14.0);
    protected static final VoxelShape SHAPE_Z = Block.func_208617_a((double)2.0, (double)7.0, (double)0.0, (double)14.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)7.0, (double)3.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)7.0, (double)15.0);
    protected static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)1.0, (double)0.0, (double)3.0, (double)3.0, (double)7.0, (double)13.0);
    protected static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)13.0, (double)0.0, (double)3.0, (double)15.0, (double)7.0, (double)13.0);

    public Bench(String name) {
        super("bench_" + name, Blocks.field_196662_n);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BenchState.Both_X)));
    }

    public Bench(String name, Block source) {
        super("bench_" + name, source);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BenchState.Both_X)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STATE});
    }

    public VoxelShape getShape(BlockState state) {
        VoxelShape shape = SHAPE_X;
        BenchState bs = (BenchState)((Object)state.func_177229_b(STATE));
        if (bs.getAxis() == Direction.Axis.Z) {
            shape = SHAPE_Z;
        }
        if (bs.hasLegNorth()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
        }
        if (bs.hasLegWest()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
        }
        if (bs.hasLegSouth()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
        }
        if (bs.hasLegEast()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
        }
        return shape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShape(state);
    }

    public boolean connects(Direction.Axis current, IWorld worldIn, BlockPos pos, Direction dir) {
        BlockState state = worldIn.func_180495_p(pos.func_177972_a(dir));
        if (state.func_177230_c() instanceof Bench) {
            return ((BenchState)((Object)state.func_177229_b(STATE))).getAxis() == current;
        }
        return false;
    }

    public BlockState getState(Direction.Axis current, IWorld worldIn, BlockPos pos) {
        if (current == Direction.Axis.Z) {
            boolean n = this.connects(current, worldIn, pos, Direction.NORTH);
            boolean s = this.connects(current, worldIn, pos, Direction.SOUTH);
            if (n && !s) {
                return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BenchState.North));
            }
            if (!n && s) {
                return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BenchState.South));
            }
            if (n && s) {
                return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BenchState.None_Z));
            }
            return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BenchState.Both_Z));
        }
        boolean w = this.connects(current, worldIn, pos, Direction.WEST);
        boolean e = this.connects(current, worldIn, pos, Direction.EAST);
        if (e && !w) {
            return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BenchState.East));
        }
        if (!e && w) {
            return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BenchState.West));
        }
        if (e && w) {
            return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BenchState.None_X));
        }
        return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BenchState.Both_X));
    }

    public BlockState func_196258_a(BlockItemUseContext c) {
        if (c.func_225518_g_()) {
            return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)(c.func_195992_f().func_176746_e().func_176740_k() == Direction.Axis.X ? BenchState.Both_X : BenchState.Both_Z)));
        }
        return this.getState(c.func_195992_f().func_176746_e().func_176740_k(), (IWorld)c.func_195991_k(), c.func_195995_a());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos pos, BlockPos otherPos) {
        return this.getState(((BenchState)((Object)stateIn.func_177229_b(STATE))).getAxis(), worldIn, pos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return SeatEntity.createSeat(worldIn, pos, (LivingEntity)player, SoundEvents.field_187889_gU);
    }
}

