/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.tileentity.BedsideTileEntity;
import com.mrh0.buildersaddition.util.IComparetorOverride;
import com.mrh0.buildersaddition.util.Util;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BedsideTable
extends BaseDerivativeBlock
implements IWaterLoggable,
ITileEntityProvider {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    protected static final VoxelShape SHAPE_BASE = Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_NW = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0);
    protected static final VoxelShape SHAPE_NE = Block.func_208617_a((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0);
    protected static final VoxelShape SHAPE_SW = Block.func_208617_a((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SHAPE_SE = Block.func_208617_a((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SHAPE_BOX_X = Block.func_208617_a((double)1.0, (double)8.0, (double)3.0, (double)15.0, (double)16.0, (double)13.0);
    protected static final VoxelShape SHAPE_BOX_Z = Block.func_208617_a((double)3.0, (double)8.0, (double)1.0, (double)13.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SHAPE_X = VoxelShapes.func_216384_a((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_NW, SHAPE_NE, SHAPE_SW, SHAPE_SE, SHAPE_BOX_X});
    protected static final VoxelShape SHAPE_Z = VoxelShapes.func_216384_a((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_NW, SHAPE_NE, SHAPE_SW, SHAPE_SE, SHAPE_BOX_Z});

    public BedsideTable(String name, Block source) {
        super("bedside_table_" + name, source);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext c) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)c.func_195992_f())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(c.func_195991_k().func_204610_c(c.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    private VoxelShape getShapeForDirection(Direction d) {
        switch (d) {
            case NORTH: {
                return SHAPE_Z;
            }
            case SOUTH: {
                return SHAPE_Z;
            }
            case EAST: {
                return SHAPE_X;
            }
            case WEST: {
                return SHAPE_X;
            }
        }
        return SHAPE_Z;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShapeForDirection((Direction)state.func_177229_b((Property)FACING));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (!Util.accessCheck(worldIn, pos, ((Direction)state.func_177229_b((Property)FACING)).func_176734_d())) {
            return ActionResultType.CONSUME;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof BedsideTileEntity) {
            player.func_213829_a((INamedContainerProvider)((BedsideTileEntity)tileentity));
            PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
        }
        return ActionResultType.CONSUME;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof BedsideTileEntity) {
            ((BedsideTileEntity)tileentity).invTick();
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof BedsideTileEntity) {
            ((BedsideTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof INamedContainerProvider ? (INamedContainerProvider)tileentity : null;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new BedsideTileEntity();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return IComparetorOverride.getComparetorOverride(worldIn, pos);
    }
}

