/*
 * Decompiled with CFR 0.152.
 */
package net.sf.image4j.codec.bmp;

import java.awt.image.BufferedImage;
import net.sf.image4j.codec.bmp.InfoHeader;

public class BMPImage {
    protected InfoHeader infoHeader;
    protected BufferedImage image;

    public BMPImage(BufferedImage bufferedImage, InfoHeader infoHeader) {
        this.image = bufferedImage;
        this.infoHeader = infoHeader;
    }

    public InfoHeader getInfoHeader() {
        return this.infoHeader;
    }

    public void setInfoHeader(InfoHeader infoHeader) {
        this.infoHeader = infoHeader;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public int getWidth() {
        return this.infoHeader == null ? -1 : this.infoHeader.iWidth;
    }

    public int getHeight() {
        return this.infoHeader == null ? -1 : this.infoHeader.iHeight;
    }

    public int getColourDepth() {
        return this.infoHeader == null ? -1 : (int)this.infoHeader.sBitCount;
    }

    public int getColourCount() {
        int n = this.infoHeader.sBitCount == 32 ? 24 : (int)this.infoHeader.sBitCount;
        return n == -1 ? -1 : 1 << n;
    }

    public boolean isIndexed() {
        return this.infoHeader == null ? false : this.infoHeader.sBitCount <= 8;
    }
}

